#pragma once

#include <kernel/lemmer/core/lemmer.h>

namespace NText2Shingles {
    TVector<TString> Text2Shingles(const TStringBuf& src, ELanguage langCode, bool lemmatize, size_t maxWords = 1000);

    TMaybe<TYandexLemma> MakeLemmaFromWord(const TUtf16String& word, ELanguage language);

    bool IsStopWord(const TString& loweredUTF8Word);
}   //  NText2Shingles
