#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/maybe.h>
#include <util/string/vector.h>
#include "text2shingles.h"

Y_UNIT_TEST_SUITE(Text2Shinlges) {
    Y_UNIT_TEST(IsStopWord) {
        UNIT_ASSERT(NText2Shingles::IsStopWord("все"));
        UNIT_ASSERT(NText2Shingles::IsStopWord("нам"));
        UNIT_ASSERT(!NText2Shingles::IsStopWord("yandex"));
    }
    Y_UNIT_TEST(MakeLemma) {
        {
            auto res = NText2Shingles::MakeLemmaFromWord(u"человека", ELanguage::LANG_RUS);
            UNIT_ASSERT(res.Defined());
            UNIT_ASSERT_EQUAL(TUtf16String(res->GetText(), res->GetTextLength()), u"человек");

        }
        {
            auto res = NText2Shingles::MakeLemmaFromWord(u"человека", ELanguage::LANG_UNK);
            UNIT_ASSERT(res.Defined());
            UNIT_ASSERT_EQUAL(TUtf16String(res->GetText(), res->GetTextLength()), u"человек");

        }
        {
            auto res = NText2Shingles::MakeLemmaFromWord(u"человека", ELanguage::LANG_MAY);
            UNIT_ASSERT(res.Defined());
            UNIT_ASSERT_EQUAL(TUtf16String(res->GetText(), res->GetTextLength()), u"человека");

        }
        {
            auto res = NText2Shingles::MakeLemmaFromWord(u"", ELanguage::LANG_MAY);
            UNIT_ASSERT(!res.Defined());
        }
        TMaybe<TYandexLemma> MakeLemmaFromWord(const TUtf16String& word, ELanguage language);
    }
    Y_UNIT_TEST(Text2Shingles) {
        const auto text1 = "Представьте себе человека, ночью выбегающего с криками из офисного центра и начинающего ломать бордюр";
        const auto text2 = "ПрЕдставьте Себе Человека, Ночью Выбегающего С Криками Из Офисного Центра И Начинающего Ломать Бордюр";
        {
            auto shingles = NText2Shingles::Text2Shingles(text1, ELanguage::LANG_RUS, true);
            auto shingles1 = NText2Shingles::Text2Shingles(text2, ELanguage::LANG_UNK, true);

            const TVector<TString> expected = {
                    "72311009243dcd66",
                    "3896cbeb2c2dd65b",
                    "21c53ed2a5713795",
                    "8ad9c8e3a305f195",
                    "fa650c26d5fa998d",
                    "1de4035fe5312de5",
                    "34e5b34d3abd7e05",
                    "c4e5b2ef84264342",
                    "808fc1a118f1a640",
                    "f1d99924451162b6"
            };
            UNIT_ASSERT_EQUAL(shingles, expected);
            UNIT_ASSERT_EQUAL(shingles1, expected);
        }
        {
            auto shingles = NText2Shingles::Text2Shingles(text1, ELanguage::LANG_RUS, false);
            auto shingles1 = NText2Shingles::Text2Shingles(text2, ELanguage::LANG_UNK, false);

            UNIT_ASSERT_UNEQUAL(shingles, shingles1);
        }
        const auto stops = "Себе ,  ;;  С  Из   И   себе";
        {
            auto shingles = NText2Shingles::Text2Shingles(stops, ELanguage::LANG_UNK, false);

            UNIT_ASSERT_EQUAL(shingles.size(), 0);
        }
    }
}
