#pragma once

#include <array>
#include <util/ysaveload.h>
#include <util/generic/strbuf.h>

namespace NYT {
    class TNode;
}

class TUidStats {
public:
    static constexpr const size_t STATS_COUNT = 6;
    static constexpr const std::array<TStringBuf, STATS_COUNT> STATS_SUFFIXES{
            TStringBuf("_YESTERDAY"),
            TStringBuf("_LAST_WEEK"),
            TStringBuf("_LAST_2_WEEKS"),
            TStringBuf("_LAST_MONTH"),
            TStringBuf("_LAST_2_MONTHS"),
            TStringBuf("_LAST_3_MONTHS"),
    };
    using TPeriodStats = std::array<ui32, STATS_COUNT>;
    static constexpr const std::array<TStringBuf, 28> FIELDS_NAMES{
            TStringBuf("ham"),
            TStringBuf("spam"),
            TStringBuf("foo"),
            TStringBuf("antifoo"),
            TStringBuf("unread_trash"),
            TStringBuf("ham_read"),
            TStringBuf("spam_read"),
            TStringBuf("email_receive_unique"),
            TStringBuf("email_send_unique"),
            TStringBuf("deleted"),
            TStringBuf("labeled"),
            TStringBuf("unlabeled"),
            TStringBuf("mark_read"),
            TStringBuf("mark_unread"),
            TStringBuf("link_click"),
            TStringBuf("move_to_spam"),
            TStringBuf("move_to_ham"),
            TStringBuf("move_to_trash"),
            TStringBuf("move_to_custom"),
            TStringBuf("move"),
            TStringBuf("deleted_final"),
            TStringBuf("search"),
            TStringBuf("copy_to_spam"),
            TStringBuf("copy_to_ham"),
            TStringBuf("copy_to_trash"),
            TStringBuf("copy_to_custom"),
            TStringBuf("copy"),
            TStringBuf("email_send_count")};

    Y_SAVELOAD_DEFINE(Stats);

    void AddStat(ui8 fieldIndex, TPeriodStats &&stats);

    void ToFeatures(THashMap<TString, float> &features) const;

private:
    THashMap<ui8, TPeriodStats> Stats;
};

class TUidsStats {
public:
    explicit TUidsStats(size_t size = 0) : UidsStats(size) {}

    Y_SAVELOAD_DEFINE(UidsStats);

    void AddNode(const NYT::TNode &node);

    const TUidStats *GetStatsOrNull(ui64 uid) const;

    size_t Size() const;

private:
    THashMap<ui64, TUidStats> UidsStats;
};
