
#include <library/cpp/yson/node/node.h>
#include <mapreduce/yt/interface/init.h>
#include <mapreduce/yt/interface/client.h>

#include <mail/so/spamstop/tools/uids_features_reader/lib/uids_features_reader.h>
#include <library/cpp/iterator/enumerate.h>
#include <library/cpp/getopt/last_getopt.h>

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);

    const auto[srcTable, dstFile] = [argc, argv]() {
        NLastGetopt::TOpts opts;
        TString srcTable, dstFile;
        opts.AddCharOption('s', "src table").StoreResult(&srcTable).Required();
        opts.AddCharOption('d', "dst file").StoreResult(&dstFile).Required();
        NLastGetopt::TOptsParseResult parsedOpts(&opts, argc, argv);
        return std::make_tuple(std::move(srcTable), std::move(dstFile));
    }();

    const auto client = NYT::CreateClientFromEnv();

    const auto rowsCount = client->Get(srcTable + "/@row_count").AsInt64();

    TUidsStats uidsStats(rowsCount);

    for (const NYT::TTableReaderPtr<NYT::TNode> reader = client->CreateTableReader<NYT::TNode>(srcTable);
         reader->IsValid(); reader->Next()) {

        const NYT::TNode &node = reader->MoveRow();
        uidsStats.AddNode(node);

        if (reader->GetRowIndex() % 1000 == 0) {
            Cout << reader->GetRowIndex() << '/' << rowsCount << '\n';
        }
    }

    {
        TFileOutput fileOutput(dstFile);
        ::Save(&fileOutput, uidsStats);
    }

    return 0;
}
