#include <mail/so/libs/unperson/lemmercache.h>
#include <mail/so/libs/unperson/unperson.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/stream/input.h>
#include <util/stream/output.h>
#include <util/system/compiler.h>

int main(int argc, char* argv[]) {
    Y_UNUSED(argv);
    NUnperson::TUnperson unperson(argc == 1);
    TString line;
    size_t lines = 0;
    size_t failedLines = 0;
    TUtf16String input;
    while (Cin.ReadLine(line)) {
        ++lines;
        try {
            input.AppendUtf8(line);
            input.append('\n');
        } catch (...) {
            ++failedLines;
        }
    }
    NUnperson::TLemmerCache lemmerCache(16384);
    TInstant start = Now();
    TUtf16String result = unperson.UnpersonText(input, lemmerCache);
    TInstant end = Now();
    TUtf16String result2 = unperson.UnpersonText(input, lemmerCache);
    TInstant end2 = Now();
    Cout << result;
    Cout.Flush();
    if (result != result2) {
        Cerr << "Results differ: >>>>>" << Endl
            << result << Endl
            << "<<<<<" << Endl
            << result2 << Endl;
    }
    if (failedLines) {
        Cerr << "Failed " << failedLines << " lines of " << lines << Endl;
    }
    Cerr << "Time taken: " << end - start
        << ", second run taken: " << end2 - end
        << ", lemmer cache size: " << lemmerCache.Size()
        << Endl;
}

