package ru.yandex.word2vec.reader;

import java.io.File;
import java.io.PrintWriter;
import java.util.List;

import com.medallia.word2vec.Searcher;
import com.medallia.word2vec.Word2VecModel;
import jline.console.ConsoleReader;

public class W2VReader {
    public static void main(final String... args) throws Exception {
        String usage =
            "Usage: " + W2VReader.class.getName() + " -model <model file>";
        if (args.length == 0 || (args.length & 1) == 1) {
            if (args.length == 0) {
                System.out.println(usage);
                return;
            } else {
                System.err.println(usage);
                System.exit(1);
                return;
            }
        }
        String modelFile = null;
        for (int i = 0; i < args.length; i += 2) {
            String name = args[i];
            String value = args[i + 1];
            switch (name) {
                case "-model":
                    modelFile = value;
                    break;
                default:
                    System.err.println("Unknown parameter <" + name + '>');
                    System.err.println(usage);
                    System.exit(2);
                    return;
            }
        }
        if (modelFile == null) {
            System.err.println("Model is not set");
            System.err.println(usage);
            System.exit(3);
            return;
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setPrompt("word> ");
        PrintWriter out = new PrintWriter(reader.getOutput());
        Word2VecModel model = Word2VecModel.fromBinFile(new File(modelFile));
        while (true) {
            String line = reader.readLine();
            if (line == null) {
                break;
            }
            line = line.trim();
            if (line.isEmpty()) {
                continue;
            }
            try {
                List<Searcher.Match> matches =
                    model.forSearch().getMatches(line, 10);
                for (Searcher.Match match: matches) {
                    out.println(match);
                }
                out.println();
            } catch (Exception e) {
                out.println("Word not found: " + line);
            }
        }
    }
}
