#include "fast_text_vector_calculator.h"

#include <mail/so/libs/fast_text/fasttext.h>

#include <util/generic/algorithm.h>

NWLO::TFastTextVectorCalculator::TFastTextVectorCalculator(THolder<fasttext::FastText>&& model)
    : Model(std::move(model))
    , VectorSize(Model->getDimension())
{
}

void NWLO::TFastTextVectorCalculator::GetWordVector(const char* str, size_t len, float* out) const {
    fasttext::Vector v(VectorSize);
    Model->getWordVector(v, std::string(str, len));
    CopyN(v.data(), VectorSize, out);
}

