#pragma once

#include "vector_calculator.h"

#include <mail/so/libs/fast_text/fasttext.h>

#include <util/generic/ptr.h>

namespace NWLO {
    class TFastTextVectorCalculator: public IVectorCalculator {
    private:
        const THolder<fasttext::FastText> Model;
        const size_t VectorSize;

    public:
        TFastTextVectorCalculator(THolder<fasttext::FastText>&& model);

        size_t GetVectorSize() const override {
            return VectorSize;
        }

        void GetWordVector(const char* str, size_t len, float* out) const override;
    };
}

