#!/usr/bin/python3
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#

import re
from tornado.gen import sleep
from mail.so.spamstop.users.admkarma_app.config import CFG, TVM
from mail.so.spamstop.users.admkarma_app.logger import error, trace
from mail.so.spamstop.users.admkarma_app.utils import requestService, requestServiceByTVM


async def requestBlackBox(params, bb_type='BB', tvm=True, retryCnt=CFG["retry_cnt"]):
    url = params if not isinstance(params, dict) else ('&'.join(map(lambda k, v: "{0}={1}".format(k, v), params.iteritems())) if isinstance(params, dict) else '')
    url, resp, code = TVM[bb_type]['URL'] + url, '', 0
    if tvm:
        resp = (await requestServiceByTVM(url, bb_type, retryCnt=retryCnt))[0]
        trace("BB response for URL '%s': %s" % (url, resp))
    else:
        for i in range(retryCnt):
            try:
                resp, code = await requestService(url)
            except Exception as e:
                await error('BB failed: %s' % str(e))
            if code == 200:
                break
            else:
                await error('BB failed (attempt #%s from %s, status=%s). Response: "%s"' % (i + 1, retryCnt, code, resp), False)
                await sleep(2 * i + 1)
                continue
    return resp


async def getUserInfo(filter_str, bb_type='BB', info_type="brief"):
    add_info_params = ""
    if info_type and info_type != "brief" and info_type != "simple":
        add_info_params = ",accounts.login.uid,subscription.suid.2"
        if info_type == "full":
            add_info_params += ",subscription.suid.669,userinfo.reg_date.uid,userinfo.country.uid&getemails=all&email_attributes=1"
    params = "method=userinfo&%s&userip=127.0.0.1&dbfields=subscription.suid.2%s" % (filter_str, add_info_params)   # "&format=json" - for JSON answer
    info = await requestBlackBox(params, bb_type, retryCnt=CFG["blackbox_retry_cnt"])
    info2 = ''
    m = re.search(r'<uid\b[^<>]*?>(\d+)<\/uid>', info)
    uid, login, suid, karma_status, reg_date, country, sid669 = m.group(1) if m and m.group(1) else '', '', '', '', '', '', ''
    if info_type and info_type != "simple":
        m = re.search(r'<dbfield id="accounts.login.uid">(.*?)<\/dbfield>', info)
        if m and m.group(1):
            login = m.group(1)
        else:
            m = re.search(r'<login>([^<]+)', info)
            if m and m.group(1):
                login = m.group(1)
        if info_type != "brief":
            m = re.search(r'^<dbfield id="subscription.suid.2">(\d+)</dbfield>', info, re.M)
            if m and m.group(1):
                suid = m.group(1)
            if info_type == "full":
                m = re.search(r'^<karma_status>(\d+)', info, re.M)
                if m and m.group(1):
                    karma_status = m.group(1)
                m = re.search(r'^<dbfield id="userinfo.reg_date.uid">([^<>]*?)</dbfield>', info, re.M)
                if m and m.group(1):
                    reg_date = m.group(1)
                m = re.search(r'^<dbfield id="userinfo.country.uid">([^<>]*?)</dbfield>', info, re.M)
                if m and m.group(1):
                    country = m.group(1)
                m = re.search(r'^<dbfield id="subscription.suid.669">([^<>]*?)</dbfield>', info, re.M)
                if m and m.group(1):
                    sid669 = m.group(1)
                m = re.search(r'<emails>(.+?)</emails>', info, re.S)
                if m and m.group(1):
                    info2 = ','.join(re.findall(r'<attribute.*?>([^<>]+?)</attribute>', m.group(1)))
    return {
        "uid":          uid,
        "login":        login,
        "suid":         suid,
        "karma_status": karma_status,
        "reg_date":     reg_date,
        "country":      country,
        "sid669":       sid669,
        "info":         info2
    }
