#!/bin/bash
# -*- Encoding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
### BEGIN INIT INFO
# Provides:          statlog
# Required-Start:    $local_fs $network $remote_fs $syslog
# Required-Stop:     $local_fs $network $remote_fs $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Service for execute of various actions on mail users info
# Description:       AdmKarmaApp - HTTP-server for various actions on mail users info.
### END INIT INFO

# Author: Yaroslav Klimik <klimiky@yandex-team.ru>

# Do NOT "set -e"
#
RETVAL=0
NAME="admkarma-app"
INST_DIR="/opt/$NAME"
PID_FILE="/var/run/admkarma.pid"
BINARY="${INST_DIR}/admkarma_app"
SERVICE_NAME="AdmKarma"
SERVICE_OPTS=""

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.2-14) to ensure that this file is present
# and status_of_proc is working.
. /lib/lsb/init-functions

#
# Helper functions for beautifying output
#
RES_COL=60
MOVE_TO_COL="echo -en \\033[${RES_COL}G"
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"

success() {
    local str=${1:-Done} s=" " l=0
    (( l=6-${#str}, l=l/2 ))
    ${MOVE_TO_COL}
    echo -n "["
    while [ $l -gt 0 ]; do s=" $s"; (( l-- )); done
    ${SETCOLOR_SUCCESS}
    echo -n "${s}$str"
    ${SETCOLOR_NORMAL}
    echo -ne "$s]\r"
    return 0
}

failure() {
    local errstr=${1:-Failed} s=" " l=0
    (( l=6-${#errstr}, l=l/2 ))
    ${MOVE_TO_COL}
    echo -n "["
    while [ $l -gt 0 ]; do s=" $s"; (( l-- )); done
    ${SETCOLOR_FAILURE}
    echo -ne "${s}$errstr"
    ${SETCOLOR_NORMAL}
    echo -ne "$s]\r"
    return 1
}

warning() {
    local warn=${1:-Warning} s=" " l=0
    (( l=6-${#warn}, l=l/2 ))
    ${MOVE_TO_COL}
    echo -n "["
    while [ $l -gt 0 ]; do s=" $s"; (( l-- )); done
    ${SETCOLOR_WARNING}
    echo -ne "${s}$warn"
    ${SETCOLOR_NORMAL}
    echo -ne "$s]\r"
    return 1
}

check_status() {
    local pc wpc pid
    [ -x $BINARY ] || return 5
    if [ -f $PID_FILE ]; then
        pid=$(cat $PID_FILE)
        if [ -n "$pid" ]; then
            kill -0 $pid 2>/dev/null
            [ $? -eq 0 ] && return 0
        fi
    fi
    pc=`ps -ef | grep "$NAME" | grep -v grep | awk '$3 == "1" {print $0}' | wc -l`
    [ "$pc" -gt 1 ] && return 3
    wpc=`ps -ef | grep "$NAME" | grep -v grep | awk '$3 != "1" {print $0}' | wc -l`
    [ "$pc" -lt 1 -a "$wpc" -gt 0 ] && return 4
    [ "$pc" -eq 0 -a "$wpc" -eq 0 ] && return 2
    return 1
}

stop() {
    local ret pid
    check_status; ret=$?
    echo -n "Stopping $SERVICE_NAME service for SO...   "
    if [ "$ret" -eq 2 ]; then
        warning "Already stopped"; echo
        return 0
    fi
    if [ -f "$PID_FILE" ]; then
        pid=$(cat $PID_FILE)
        if [ -n "$pid" ]; then
            # rm -f $PID_FILE
            # kill $pid
            start-stop-daemon --stop --oknodo --pidfile $PID_FILE
        fi
    fi
    if [ -n "$pid" ]; then
        check_status; ret=$?
    fi
    if [ "$ret" -eq 2 ]; then
        success; echo
        return 0
    fi
    if [ -z "$pid" -o "$ret" -ne 2 ]; then
        pid=`ps -ef | grep "$NAME" | grep -v grep | awk '$3 == "1" {print $2}' | tr "\r\n" "  "`
    fi
    for i in `seq 1 10`; do
        kill -TERM $pid 2>/dev/null
        check_status; ret=$?
        if [ "$ret" -eq 2 ]; then
            success; echo
            return 0
        fi
        sleep 1
    done
    pid=`ps -ef | grep "$NAME" | grep -v grep | awk '{print $2}' | tr "\r\n" "  "`
    [ -n "$pid" ] && kill -9 $pid
    warning "Killed"; echo
    return 0
}

start() {
    local ret
    check_status; ret=$?
    if [ "$ret" -gt 0 -a "$ret" -ne 2 ]; then
        echo -ne "It is attempt to start $SERVICE_NAME service for SO...   "
        stop
    else
        echo -n "Starting $SERVICE_NAME service for SO...   "
    fi
    start-stop-daemon --make-pidfile --background --start --pidfile $PID_FILE --exec $BINARY -- $SERVICE_OPTS
    check_status; ret=$?
    if [ "$ret" -eq 0 ]; then
        success
    else
        failure
    fi; echo
    return $RETVAL
}

restart() {
    local ret
    # stop; start
    start-stop-daemon --stop --oknodo --retry 30 --pidfile $PID_FILE
    start-stop-daemon --make-pidfile --background --start --pidfile $PID_FILE --exec $BINARY -- $SERVICE_OPTS
    check_status; ret=$?
    return $ret
}

status() {
    local ret pid
    check_status; ret=$?
    case "$ret" in
      0)
          pid=`cat $PID_FILE`
          echo -e $"${SERVICE_NAME} server for SO (manager's process pid $pid) is \033[1;32mrunning\033[0;39m..."
          return 0
      ;;
      2)
          echo -e $"${SERVICE_NAME} server for SO is \033[1;31mstopped\033[0;39m"
          return 2
      ;;
      3)
          echo -e $"${SERVICE_NAME} server for SO: manager process is still running but worker processes are \033[1;31mdead\033[0;39m"
          return 3
      ;;
      4)
          echo -e $"${SERVICE_NAME} server for SO: manager process is \033[1;31mdead\033[0;39m but worker processes still running"
          return 4
      ;;
      5)
          echo -e $"${SERVICE_NAME} server for SO is \033[1;31mprobably not properly installed\033[0;39m (there are no executable file?)"
          return 5
      ;;
      6)
          echo -e $"${SERVICE_NAME} server for SO is \033[1;31mprobably not properly installed\033[0;39m (there are no config file?)"
          return 6
      ;;
    esac
    echo -e $"${SERVICE_NAME} server for SO: status is \033[1;31mundetermined\033[0;39m"
    return 1
}

case "$1" in
    start|stop|restart|status)
        $1; RETVAL=$?
    ;;
    *)
        echo "Usage: $0 {start|stop|restart|status}"
        exit 2
esac
exit $RETVAL
