#!/usr/bin/env python
# -*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import logging
from sys import exc_info
from traceback import format_exception
from tornado.log import LogFormatter, access_log, app_log, gen_log
from tornado.options import options


def getTraceback() -> str:
    exc_type, exc_value, exc_traceback = exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb


def redefineLogHandler(logger: logging.Logger, file_suffix: str = "") -> None:
    rotate_mode = options.log_rotate_mode
    if rotate_mode == "size":
        channel = logging.handlers.RotatingFileHandler(
            filename=options.log_path + file_suffix + ".log",
            maxBytes=options.log_file_max_size,
            backupCount=options.log_file_num_backups,
            encoding="utf-8",
        )
    elif rotate_mode == "time":
        channel = logging.handlers.TimedRotatingFileHandler(
            filename=options.log_path + file_suffix + ".log",
            when=options.log_rotate_when,
            interval=options.log_rotate_interval,
            backupCount=options.log_file_num_backups,
            encoding="utf-8",
        )
    else:
        raise ValueError('The value of log_rotate_mode option should be "size" or "time", not "%s".' % rotate_mode)
    channel.setFormatter(LogFormatter(color=False))
    logger.addHandler(channel)


def configureLoggers() -> None:
    options.logging = "debug" if options.debug else "info"
    redefineLogHandler(app_log, "-error")
    redefineLogHandler(access_log, "-access")
    redefineLogHandler(gen_log)


def trace(s: str) -> None:
    gen_log.info(s)


async def error(s, isTB=True) -> None:
    if isTB:
        app_log.error("ERROR: {}".format(s + getTraceback()))
    else:
        app_log.warning("WARNING: {}".format(s))
