#!/usr/bin/python3
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#

import re
from json import loads
from html import unescape
from mail.so.spamstop.users.admkarma_app.config import CFG, TVM
from mail.so.spamstop.users.admkarma_app.logger import error, trace
from mail.so.spamstop.users.admkarma_app.utils import isCorp, requestServiceByTVM
from mail.so.spamstop.users.admkarma_app.blackbox import requestBlackBox


def getAnswer(resp):
    s = ""
    if isinstance(resp, dict) and "status" in resp:
        if resp["status"] == "error":
            s = ', '.join(resp["errors"])
        else:
            s = resp["status"]
    else:
        s = resp
    return s


async def logoutUser(uid, params):
    resp, code, url = '', 200, "{0}/2/account/{1}/password_options/?consumer=so".format(TVM['Passport']['URL'], uid)
    try:
        errors = []
        data = {
            "comment":                      params.get("comment", ""),
            "admin_name":                   params.get("admin", ""),
            "global_logout":                params.get("global_logout", 1),
            "is_changing_required":         params.get("is_changing_required", 'yes'),
            "max_change_frequency_in_days": params.get("max_change_frequency_in_days", 4)
        }
        if isCorp(uid) and data["is_changing_required"] == "yes":
            info = await requestBlackBox("method=userinfo&uid=%s&sid=2&userip=127.0.0.1" % uid, retryCnt=CFG["blackbox_retry_cnt"])
            m, domain = re.search(r'<uid\b[^<>]*?\bdomain="([^<>\"]+?)"[^<>]*?>(\d+)<\/uid>', info), ""
            if m and m.group(1):
                domain = "domain=%s" % m.group(1)
            else:
                m = re.search(r'<uid\b[^<>]*?\bdomid="(\d+?)"[^<>]*?', info)
                if m and m.group(1):
                    domain = "domain_id=%s" % m.group(1)
            if domain:
                info2 = await requestBlackBox("method=hosted_domains&%s&aliases=true" % domain, retryCnt=CFG["blackbox_retry_cnt"])
                m = re.search(r'<item\b[^<>]*?\boptions="([^<>\"]*?)"', info2)
                if m and m.group(1):
                    try:
                        data2 = loads(unescape(m.group(1)))
                    except Exception as e:
                        await error('logoutUser failed for PDD uid=%s: %s' % (uid, str(e)))
                    else:
                        if "can_users_change_password" in data2 and data2["can_users_change_password"] == 0:
                            params["is_changing_required"] = "no"
                            errors += ["user_cant_change_password"]
        resp, code = await requestServiceByTVM(url, "Passport", data=data, retDataType='json', retryCnt=CFG["passport_retry_cnt"])
        if code == 200:
            trace("LOGOUT user with UID = %s: %s" % (uid, getAnswer(resp)))
        else:
            trace("LOGOUT user with UID = %s failed! (code=%s, url=%s, data=%s): %s" % (uid, code, url, str(data), resp))
    except Exception as e:
        await error('logoutUser failed for uid=%s: %s' % (uid, str(e)))
        if errors:
            resp = "logoutUser failed: %s" % ", ".join(errors)
    return resp


async def changeUserPasswordOptions(uid, params):
    resp, code, url = '', 200, "{0}/2/account/{1}/password_options/?consumer=so".format(TVM['Passport']['URL'], uid)
    try:
        data = {
            "comment":              params.get("comment", ""),
            "admin_name":           params.get("admin", ""),
            "is_changing_required": params.get("is_changing_required", 'yes')
        }
        if "max_change_frequency_in_days" in params:
            data["max_change_frequency_in_days"] = params["max_change_frequency_in_days"]
        resp, code = await requestServiceByTVM(url, "Passport", data=data, retDataType='json', retryCnt=CFG["passport_retry_cnt"])
        if code == 200:
            trace("CHANGE PASSWORD OPTION for user with UID = %s: %s" % (uid, getAnswer(resp)))
        else:
            trace("CHANGE PASSWORD OPTION for user with UID = %s failed! (code=%s, url=%s, data=%s): %s" % (uid, code, url, str(data), resp))
    except Exception as e:
        await error('changeUserPasswordOptions failed for uid=%s: %s' % (uid, str(e)))
    return resp


async def changeUserOptions(uid, params, options):
    resp, code, url = '', 200, "{0}/2/account/{1}/options/?consumer=so".format(TVM['Passport']['URL'], uid)
    try:
        data = {
            "comment":    params.get("comment", ""),
            "admin_name": params.get("admin", "")
        }
        for option in options:
            data[option] = "yes"
        resp, code = await requestServiceByTVM(url, "Passport", data=data, retDataType='json', retryCnt=CFG["passport_retry_cnt"])
        if code == 200:
            trace("CHANGE OPTION for user with UID = %s: %s" % (uid, getAnswer(resp)))
        else:
            trace("CHANGE OPTION for user with UID = %s failed! (code=%s, url=%s, data=%s): %s" % (uid, code, url, str(data), resp))
    except Exception as e:
        await error('changeUserOptions failed for uid=%s: %s' % (uid, str(e)))
    return resp


async def setKarma(uid, karma, params, strict=False):
    resp, code, url = '', 200, "{0}/1/account/{1}/karma/?consumer=so".format(TVM['Passport']['URL'], uid)
    data = {
        "comment":    params.get("comment", ""),
        "admin_name": params.get("admin", "")
    }
    if karma >= 1000:
        data["prefix"] = karma // 1000
        if strict:
            data["suffix"] = karma % 1000
    else:
        data["suffix"] = karma
        if strict:
            data["prefix"] = 0
    try:
        resp, code = await requestServiceByTVM(url, "Passport", data=data, retDataType='json', retryCnt=CFG["passport_retry_cnt"])
        if code == 200:
            trace("SET_KARMA for user with UID = %s%s: %s" % (uid, " (strict)" if strict else "", getAnswer(resp)))
        else:
            trace("SET_KARMA for user with UID = %s failed! (code=%s, url=%s, data=%s): %s" % (uid, code, url, str(data), resp))
    except Exception as e:
        await error('setKarma failed: %s' % str(e))
    return resp


async def banUser(uid, params):
    resp, code, url = '', 200, "{0}/1/account/{1}/karma/?consumer=so".format(TVM['Passport']['URL'], uid)
    data = {
        "comment":    params.get("comment", ""),
        "admin_name": params.get("admin", ""),
        "is_enabled": 0
    }
    try:
        resp, code = await requestServiceByTVM(url, "Passport", data=data, retDataType='json', retryCnt=CFG["passport_retry_cnt"])
        if code == 200:
            trace("BAN user with UID = %s: %s" % (uid, getAnswer(resp)))
        else:
            trace("BAN user with UID = %s failed! (code=%s, url=%s, data=%s): %s" % (uid, code, url, str(data), resp))
    except Exception as e:
        await error('banUser failed: %s' % str(e))
    return resp
