#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re, time, imaplib
from traceback import format_exception
from email import message_from_string
from email.parser import HeaderParser

CFG = {
    'retry_cnt':            3,
    # Some predefined emails
    'robot':                'Robot Mailspam <robot-mailspam@yandex-team.ru>',
    'robot_user':           'robot-mailspam@yandex-team.ru',
    'robot_passwd':         '',
    'report':               'so-report@yandex-team.ru',
    # SMTP settings
    'smtp_host':            'outbound-relay.yandex.net',
    'smtp_port':            25,
    'smtp_timeout':         5.0,
    # IMAP settings
    'imap_corp_in_host':    'imap.yandex-team.ru',
    'imap_corp_in_port':    993,
    'imap_corp_out_host':   'smtp.yandex-team.ru',
    'imap_corp_out_port':   465,
    'imap_corp_folder':     'so-spam-report',
}
ROBOT = {
    "login":   "robot-markspam",
    "folders": {
        "_so_ham_plus":  "ham_plus",
        "_so_ham_minus": "ham_minus",
        "_so_spam":      "spam"
    }
}
LIST_RESPONSE_RE = re.compile(r'\((?P<flags>.*?)\) "(?P<delimiter>.*)" (?P<name>.*)')

def parseListResponse(line):
    flags, delimiter, mailbox_name = LIST_RESPONSE_RE.match(line).groups()
    mailbox_name = mailbox_name.strip('"')
    if flags.lower().find("noselect") >= 0:
        mailbox_name=""
    return (flags, delimiter, mailbox_name)

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def writelog(msg, isTB=False, fh=None, prefix='', isAddTS=True):
    if not msg: return
    if not fh: fh = sys.stderr
    try:
        tb = "\n"
        if isTB:
            tb += get_traceback()
        s = prefix + msg + tb
        if isAddTS:
            s = time.strftime("[%Y-%m-%d %H:%M:%S]: ") + s
        os.write(fh.fileno(), s)
    except UnicodeEncodeError:
        try:
            os.write(fh.fileno(), str(s.encode('utf-8')))
        except:
            os.write(fh.fileno(), str(s.encode('utf-8', 'ignore')))
    except Exception, e:
        print >>sys.stderr, "Writelog error: %s.%s" % (str(e), get_traceback())
        sys.stderr.flush()

def loadRobotCredentials(log_fh=None):
    HOME_DIR = os.environ["HOME"] if "HOME" in os.environ else "/root"
    filename = '{}/.robot.{}'.format(HOME_DIR, ROBOT["login"])
    if not os.path.exists(filename) and "PWD" in os.environ and os.environ["PWD"]:
        filename = '{}/.robot.{}'.format(os.environ["PWD"], ROBOT["login"])
    if os.path.exists(filename):
        try:
            f = open(filename)
            ROBOT['password'] = f.read().strip()
            f.close()
        except Exception, e:
            writelog("Unable to read secret for robot '%s': %s" % (ROBOT["login"], str(e)), True, log_fh)
    else:
        writelog("Unable to locate secret for robot '%s'" % ROBOT["login"], False, log_fh)

def listIMAPFolders(filterMsgs="ALL", user=CFG['robot_user'], password=CFG['robot_passwd'], log_fh=None):
    status = ""
    if not user or not password:
        s = "Invalid IMAP user's credentials: user=%s, passwd=%s." % (user, password)
        writelog(s, False, log_fh)
        status += ('\n' if status else '') + s
    try:
        imap = imaplib.IMAP4_SSL(CFG['imap_corp_in_host'], CFG['imap_corp_in_port'])
        resp, data = imap.login(user, password)
        if resp == "NO":
            s = "Authenticating for user '%s' IMAP failed: %s." % (user, str(data))
            writelog(s, False, log_fh)
            status += ('\n' if status else '') + s
        else:
            totalMsgs, deletion_list = 0, []
            resp, data = imap.list()
            if resp == 'OK':
                for mbox in data:
                    flags, separator, name = parseListResponse(bytes.decode(mbox))
                    if name == "":
                        continue
                    print ("Checking folder: ", name)
                    imap.select('"{0}"'.format(name), True)
                    resp, msgnums = imap.search(None, filterMsgs)
                    msg_count = len(msgnums[0].split())
                    print('{:<30} : {: d}'.format(name, msg_count))
                    if (msg_count > 0):
                        deletion_list.append(name)
                        totalMsgs = totalMsgs + msg_count
                print('MsgsCnt : {: d}. DeletionList: {}'.format(totalMsgs, str(deletion_list)))
                #return (deletion_list)
            imap.logout()
    except Exception, e:
        s = "IMAP operation failed: %s." % str(e)
        writelog(s, True, log_fh)
        status += ('\n' if status else '') + s
    return status

def sendMsgToIMAPFolder(msg, acttime=None, folder_name=CFG["imap_corp_folder"], user=CFG['robot_user'], password=CFG['robot_passwd'], log_fh=None):
    status = ""
    if not acttime:
        acttime = int(time.time())
    if not user or not password:
        s = "Invalid IMAP user's credentials: user=%s, passwd=%s." % (user, password)
        writelog(s, False, log_fh)
        status += ('\n' if status else '') + s
    try:
        imap = imaplib.IMAP4_SSL(CFG['imap_corp_in_host'], CFG['imap_corp_in_port'])
        loginInfo = imap.login(user, password)
        if loginInfo[0] == "NO":
            s = "Authenticating for user '%s' IMAP failed: %s." % (user, str(loginInfo))
            writelog(s, False, log_fh)
            status += ('\n' if status else '') + s
        else:
            folderInfo = imap.select(folder_name)
            if folderInfo[0] == "NO" and folderInfo[1][0].find("No such folder") > -1:
                createInfo = imap.create(folder_name)
                s = "Creating IMAP folder '%s' result: %s." % (folder_name, str(createInfo))
                writelog(s, False, log_fh)
                if createInfo[0] == "NO":
                    status += ('\n' if status else '') + s
            appendInfo = imap.append(folder_name, '', imaplib.Time2Internaldate(acttime), msg)
            if appendInfo[0] == "NO":
                s = "Appending of message to IMAP folder '%s' failed: %s." % (folder_name, str(appendInfo))
                writelog(s, False, log_fh)
                status += ('\n' if status else '') + s
            imap.logout()
    except Exception, e:
        s = "Senging message to corp IMAP folder '%s' failed: %s." % (folder_name, str(e))
        writelog(s, True, log_fh)
        status += ('\n' if status else '') + s
    return status

def deleteMsgsFromIMAPFolder(stids, folder_name=CFG["imap_corp_folder"], user=CFG['robot_user'], password=CFG['robot_passwd'], log_fh=None):
    status = ""
    try:
        imap = imaplib.IMAP4_SSL(CFG['imap_corp_in_host'], CFG['imap_corp_in_port'])
        imap.login(user, password)
        imap.select(folder_name)
        resp, data = imap.search(None, "ALL")
        uids = data[0].split()
        mailparser = HeaderParser()
        for uid in uids:
            resp, data = imap.fetch(uid, "(BODY[HEADER])")
            msg = mailparser.parsestr(data[0][1])
            if 'X-Yandex-STID' in msg and msg["X-Yandex-STID"] in stids:
                imap.store(uid, '+FLAGS', '(\\Deleted)')
        imap.expunge()
        imap.logout()
    except Exception, e:
        writelog("Deleting messages from corp IMAP folder '%s' failed: %s." % (folder_name, str(e)), True, log_fh)
        status = "Error: '%s'" % str(e)
    return status

if __name__ == "__main__":
    loadRobotCredentials()
    listIMAPFolders("ALL", ROBOT["login"], ROBOT["password"])
