#!/usr/bin/perl
# -*- Encoding: utf-8; Mode: cperl -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
package SO::IniFile;
use base qw(Exporter);

use strict;
use warnings;

BEGIN { push @INC, 'WORKING_DIR/SO'; }
use SO::LogFile;

our @EXPORT = qw(writeIni loadIni);
our @EXPORT_OK = qw(writeIni loadIni @defaultIniFiles $defaultIniSection);
our $VERSION = 1.1;

our @defaultIniFiles = ('WORKING_DIR/so-monlog.ini', './so-monlog.ini');
our $defaultIniSection = 'general';

# Methods of class

sub new {
    my $class = shift();
    my $self  = bless {}, $class;
    $self->{'filePath'} = shift();
    unless ($$self{'filePath'} and -e $$self{'filePath'} and -f $$self{'filePath'}) {
        $self->{'filePath'} = '';
        foreach (@defaultIniFiles) {
            $self->{'filePath'} = $_, last if -e $_ and -f $_;
        }
    }
    $self->{'isOK'} = !!$$self{'filePath'};
    return $self;
}

sub writeIni {
    my ($self, $q, $section) = (shift(), shift() || {}, shift() || $defaultIniSection);
    return unless $self->{'isOK'};
    my ($s, $q_old, $p1, $p2, $p3, $comments, $err, $res) = (0, {}, '', '', '', '', '', '');
    open(FH_INI, '<', $$self{'filePath'}) or $err = "Unable to open file '$$self{filePath}' for reading: $!", $res .= $err."\n", writeLog($err), return;
    my ($k, $v);
    local $/ = "\n";
    local $_;
    while (<FH_INI>) {
        $s = 0 if /^\s*$/;
        $s = /^\s*\[\s*$section\s*\]\s*$/o unless $s;
        unless ($s) {
            if ($p2) { $p3 .= $_ } else { $p1 .= $_ }
            next;
        }
        $comments .= $_, next if /^#/;
        ($k, $v) = ($1, $2), $v =~ s/\s+$//, $$q_old{$k} = $v =~ /^\d+$/ ? $v + 0 : $v if /^(\w+)\s*=\s*([^#]+)\s*(?:\#.*)?$/; $p2 .= $_
    }
    close(FH_INI);
    foreach (keys %$q_old) {
        $$q{$_} = $$q_old{$_} unless exists $$q{$_}
    }
    open(FH_INI, '>', $$self{'filePath'}) or $err = "Unable to open file '$$self{filePath}' for writing: $!", $res .= $err."\n", writeLog($err), return;
    print FH_INI $p1."[$section]\n$comments";
    foreach (keys %$q) { print FH_INI "$_=$$q{$_}\n" }
    print FH_INI $p3;
    close(FH_INI);
    $res
}

sub loadIni {
    my ($self, $q, $section, $s) = (shift(), shift() || {}, shift() || $defaultIniSection, 0);
    return unless $self->{'isOK'};
    my ($qr, $res) = (qr/^\s*\[\s*$section\s*\]\s*$/, '');
    open(FH_INI, '<', $$self{'filePath'}) or $res = "Unable to open file '$$self{filePath}' for reading: $!", writeLog($res), return;
    my ($k, $v);
    local $/ = "\n";
    while (local $_ = <FH_INI>) {
        next if /^#/;
        $s = 0 if /^\s*$/;
        $s = /$qr/ unless $s;
        next unless $s;
        ($k, $v) = ($1, $2), $v =~ s/\s+$//, $$q{$k} = $v =~ /^\d+$/ ? $v + 0 : $v if /^([\w\.-]+)\s*=\s*([^#]+)\s*(?:\#.*)?$/
    }
    close(FH_INI);
    $res
}

1;
