#!/usr/bin/perl
# -*- Encoding: utf-8; Mode: cperl -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
package SO::LogFile;
use base qw(Exporter);

use strict;
use warnings;

our @EXPORT = qw(writeLog);
our @EXPORT_OK = qw(writeLog $defaultLogFile $DEBUG);
our $VERSION = 1.2;
our $DEBUG = 0;
our $defaultLogFile = 'WORKING_DIR/logs/errors.log';

# Local functions

sub writeLog {
    my ($str, $logFile, $prefix, $is_debug) = @_; $logFile ||= $defaultLogFile;
    open(FH_LOG, '>>', $logFile) or warn("Unable to open file '$logFile': $!"), return;
    my ($s, $m, $h, $d, $mon, $y) = localtime();
    my $info = '';
    if ($DEBUG or $is_debug) {
        my ($i, $package, $filename, $line) = 0;
        while(($package, $filename, $line) = caller($i++)) {
            $info .= ($info ? "\t\t" : '').$i.': package '.$package.', file "'.$filename.'", line '.$line."\n";
        }
    }
    $prefix = "[pid=$$".sprintf(" %4d-%02d-%02d %02d:%02d:%02d", $y + 1900, $mon + 1, $d, $h, $m, $s).']: ' unless defined $prefix;
    print FH_LOG $prefix.$info.($str || '')."\n";
    close(FH_LOG);
}

1;
