#!/usr/bin/perl
## -*- Encoding:utf-8; Mode:perl; -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
##---------------------------------------------------------------------------##
##  File:
##	$Id: MHRcVars.pm,v 1.1 2014/02/20 11:08:38 klimiky Exp $
##  Author:
##      Earl Hood       mhonarc@mhonarc.org
##  Description:
##      Defines routine for expanding resource variables.
##---------------------------------------------------------------------------##
##    MHonArc -- Internet mail-to-HTML converter
##    Copyright (C) 1996-2001	Earl Hood, mhonarc@mhonarc.org
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
##    02111-1307, USA
##---------------------------------------------------------------------------##

package SO::Mail::Message;

## Mapping of old resource variables to current versions.
my %old2new = (
    'FIRSTPG'    	=> [ 'PG', 'FIRST' ],
    'LASTPG'    	=> [ 'PG', 'LAST' ],
    'NEXTBUTTON'    	=> [ 'BUTTON', 'NEXT' ],
    'NEXTFROM'    	=> [ 'FROM', 'NEXT' ],
    'NEXTFROMADDR'    	=> [ 'FROMADDR', 'NEXT' ],
    'NEXTFROMNAME'    	=> [ 'FROMNAME', 'NEXT' ],
    'NEXTLINK'    	=> [ 'LINK', 'NEXT' ],
    'NEXTMSG'    	=> [ 'MSG', 'NEXT' ],
    'NEXTMSGNUM'    	=> [ 'MSGNUM', 'NEXT' ],
    'NEXTPG'    	=> [ 'PG', 'NEXT' ],
    'NEXTPGLINK'    	=> [ 'PGLINK', 'NEXT' ],
    'NEXTSUBJECT'	=> [ 'SUBJECT', 'NEXT' ],
    'PREVBUTTON'    	=> [ 'BUTTON', 'PREV' ],
    'PREVFROM'    	=> [ 'FROM', 'PREV' ],
    'PREVFROMADDR'    	=> [ 'FROMADDR', 'PREV' ],
    'PREVFROMNAME'    	=> [ 'FROMNAME', 'PREV' ],
    'PREVLINK'    	=> [ 'LINK', 'PREV' ],
    'PREVMSG'    	=> [ 'MSG', 'PREV' ],
    'PREVMSGNUM'    	=> [ 'MSGNUM', 'PREV' ],
    'PREVPGLINK'    	=> [ 'PGLINK', 'PREV' ],
    'PREVPG'    	=> [ 'PG', 'PREV' ],
    'PREVSUBJECT'	=> [ 'SUBJECT', 'PREV' ],
    'TFIRSTPG'    	=> [ 'PG', 'TFIRST' ],
    'TLASTPG'    	=> [ 'PG', 'TLAST' ],
    'TNEXTBUTTON'    	=> [ 'BUTTON', 'TNEXT' ],
    'TNEXTFROM'    	=> [ 'FROM', 'TNEXT' ],
    'TNEXTFROMADDR'    	=> [ 'FROMADDR', 'TNEXT' ],
    'TNEXTFROMNAME'    	=> [ 'FROMNAME', 'TNEXT' ],
    'TNEXTLINK'    	=> [ 'LINK', 'TNEXT' ],
    'TNEXTMSG'    	=> [ 'MSG', 'TNEXT' ],
    'TNEXTMSGNUM'    	=> [ 'MSGNUM', 'TNEXT' ],
    'TNEXTPGLINK'    	=> [ 'PGLINK', 'TNEXT' ],
    'TNEXTPG'    	=> [ 'PG', 'TNEXT' ],
    'TNEXTSUBJECT'	=> [ 'SUBJECT', 'TNEXT' ],
    'TPREVBUTTON'    	=> [ 'BUTTON', 'TPREV' ],
    'TPREVFROM'    	=> [ 'FROM', 'TPREV' ],
    'TPREVFROMADDR'    	=> [ 'FROMADDR', 'TPREV' ],
    'TPREVFROMNAME'    	=> [ 'FROMNAME', 'TPREV' ],
    'TPREVLINK'    	=> [ 'LINK', 'TPREV' ],
    'TPREVMSG'    	=> [ 'MSG', 'TPREV' ],
    'TPREVMSGNUM'    	=> [ 'MSGNUM', 'TPREV' ],
    'TPREVPGLINK'    	=> [ 'PGLINK', 'TPREV' ],
    'TPREVPG'    	=> [ 'PG', 'TPREV' ],
    'TPREVSUBJECT'	=> [ 'SUBJECT', 'TPREV' ],
);

##---------------------------------------------------------------------------
##	replace_li_var() is used to substitute vars to current
##	values.  This routine relies on some variables being set by the
##	calling routine or as globals.
##
sub replace_li_var {
    my($val, $index) = ($_[0], $_[1]);
    my($var,$len,$canclip,$raw,$isurl,$tmp,$ret) = ('',0,0,0,0,'','');
    my($jstr) = (0);
    my($expand) = (0);
    my($n) = (0);
    my($lref, $key, $pos);
    my($arg, $opt) = ('', '');
    my $isaddr = 0;
    my $mailto = 0;

    ##	Get variable argument string
    if ($val =~ s/\(([^()]*)\)//) {
	$arg = $1;
    }
    ##	Get length specifier (if defined)
    ($var, $len) = split(/:/, $val, 2);
    $len = -1  unless defined $len;

    ##	Check for old resource variables and map to new
    ($var, $arg) = @{$old2new{$var}}  if defined($old2new{$var});

    ##	Check if variable in a URL string
    $isurl = 1  if ($len =~ s/U//g);	
    ##	Check if variable in a JavaScript string
    $jstr  = 1  if ($len =~ s/J//g);	
    ##	Check if variable in a JavaScript string
    $mailto = 1 if ($len =~ s/M//g);	

    ##	Do variable replacement
    REPLACESW: {
	## Invoke callback if defined
	if (defined($CBRcVarExpand) && defined(&$CBRcVarExpand)) {
	    ($tmp, $expand, $canclip) = &$CBRcVarExpand($index, $var, $arg);
	    last REPLACESW  if defined($tmp);
	}

	## -------------------------------------- ##
	## Message information resource variables ##
	## -------------------------------------- ##
    	if ($var eq 'DATE') {		## Message "Date:"
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    $tmp = defined($index) ? $Date{$index} : ''; # $key
	    last REPLACESW;
	}
    	if ($var eq 'DDMMYY' || $var eq 'DDMMYYYY' ||
	    $var eq 'MMDDYY' || $var eq 'MMDDYYYY' ||
	    $var eq 'YYMMDD' || $var eq 'YYYYMMDD') {
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    $tmp = defined($index) ? &time2mmddyy((split(/$X/o, $index))[0], lc $var) : ''; # $key
	    last REPLACESW;
	}
	if ($var eq 'FROM') {		## Message "From:"
	    $canclip = 1; $raw = 1;
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    $tmp = defined($index) ? $From{$index} : '(nil)'; # $key
	    $isaddr = 1;
	    last REPLACESW;
	}
	if ($var eq 'FROMADDR') {	## Message from mail address
	    $canclip = 1; $raw = 1;
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    if (!defined($index)) { # $key
		$tmp = '(nil)';
		last REPLACESW;
	    }
	    my $caddr = $FromAddr{$index}; # $key
	    $tmp = defined($caddr) ? $caddr : extract_email_address($From{$index}); # $key
	    $isaddr = 1;
	    last REPLACESW;
	}
	if ($var eq 'FROMNAME') {	## Message from mail name
	    $canclip = 1; $raw = 1;
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    if (!defined($index)) { # $key
		$tmp = '(nil)';
		last REPLACESW;
	    }
	    my $cname = $FromName{$index}; # $key
	    $tmp = defined($cname) ? $cname : extract_email_name($From{$index}); # $key
	    if ($SpamMode) {
		$tmp =~ s/($AddrExp)/rewrite_raw_address($1)/geo;
	    } else {
		$isaddr = 1;
	    }
	    last REPLACESW;
	}

	my ($cnd1, $cnd2) = (0,0);
    	if ( ($cnd1 = ($var eq 'FROMADDRNAME')) || ($cnd2 = ($var eq 'FROMADDRDOMAIN')) ) {
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    if (!defined($index)) { # $key
		$tmp = '';
		last REPLACESW;
	    }
	    my $caddr = $FromAddr{$index}; # $key
	    my @a;
	    if (defined($caddr)) {
	      @a = split(/@/, $caddr, 2);
	    } else {
	      @a = split(/@/, extract_email_address($From{$index}), 2); # $key
	    }
	    if ($cnd1) {
		$tmp = $a[0];
		last REPLACESW;
	    }
	    $tmp = defined($a[1]) ? $a[1] : "";
	    last REPLACESW;
	}
    	if ($var eq 'ICON') {		## Message icon
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    if (!defined($index)) { # $key
		$tmp = '';
		last REPLACESW;
	    }
	    my($iconurl, $iw, $ih) = SO::Mail::Message::get_icon_url($ContentType{$index}); # $key
	    my $alttext = $iconurl ? $ContentType{$key} : 'unknown';
	    $tmp  = qq|<img src="$iconurl" border="0" alt="[$alttext]"|;
	    $tmp .= ' width="' .  $iw . '"'  if $iw;
	    $tmp .= ' height="' . $ih . '"'  if $ih;
	    $tmp .= '>';
	    last REPLACESW;
	}
    	if ($var eq 'ICONURL') {	## URL to message icon
	    $isurl = 0;
	    #($lref, $key, $pos)    = compute_msg_pos($index, $var, $arg);
	    my($iconurl, $iw, $ih) = SO::Mail::Message::get_icon_url($ContentType{$index}); # $key
	    $tmp = $iconurl  if defined($iconurl);
	    last REPLACESW;
	}
    	if ($var eq 'ICONURLPREFIX') {	## URL prefix to message icon
	    $isurl = 0;
	    $tmp = $IconURLPrefix;
	    last REPLACESW;
	}
#     	if ($var eq 'MSG') {		## Filename of message page
# 	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
# 	    $tmp = defined($index) ? &msgnum_filename($IndexNum{$index}) : ''; # $key
# 	    last REPLACESW;
# 	}
	if ($var eq 'MSGHFIELD') {	## Message header field
	    $canclip = 1; $raw = 1;
	    #($lref, $key, $pos, $opt) = compute_msg_pos($index, $var, $arg);
	    if (!defined($index)) { # $key
		$tmp = '';
		last REPLACESW;
	    }
	    $opt =~ s/\s+//g;  $opt = lc $opt;
	    HFIELD: {
		my $fields = $ExtraHFields{$index}; # $key
		if (defined($fields) && defined($tmp = $fields->{$opt})) {
		    last HFIELD;
		}
		if ($opt eq 'subject') {
		    $tmp = $Subject{$index}; # $key
		    $tmp = $NoSubjectTxt  if $tmp eq '';
		    last HFIELD;
		}
		$tmp = '';
	    }
	    if (!$HFieldsAsIsList{$opt}) {
		$isaddr = 1;
	    }
	    last REPLACESW;
	}
    	if ($var eq 'MSGGMTDATE') {	## Message GMT date
	    #($lref, $key, $pos, $opt) = compute_msg_pos($index, $var, $arg);
	    $tmp = &time2str($opt || $MsgGMTDateFmt, $Time{$index}, 0); # $key
	    last REPLACESW;
	}
    	if ($var eq 'MSGID') {		## Message-ID
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    $tmp = defined($index) ? $MsgId : ''; # $key
	    last REPLACESW;
	}
    	if ($var eq 'MSGLOCALDATE') {	## Message local date
	    #($lref, $key, $pos, $opt) = compute_msg_pos($index, $var, $arg);
	    $tmp = &time2str($opt || $MsgLocalDateFmt, $Time{$index}, 1); # $key
	    last REPLACESW;
	}
    	if ($var eq 'SUBJECT') {	## Message subject
	    $canclip = 1; $raw = 1; $isurl = 0; $isaddr = 1;
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    if (defined($index)) { # $key
		$tmp = $Subject{$index}; # $key
		$tmp = $NoSubjectTxt  if $tmp eq '';
	    } else {
		$tmp = '';
	    }
	    last REPLACESW;
	}
    	if ($var eq 'SUBJECTNA') {	## Message subject (not linked)
	    $canclip = 1; $raw = 1; $isaddr = 1;
	    #($lref, $key, $pos) = compute_msg_pos($index, $var, $arg);
	    if (defined($index)) { # $key
		$tmp = $Subject{$index}; # $key
		$tmp = $NoSubjectTxt  if $tmp eq '';
	    } else {
		$tmp = '';
	    }
	    last REPLACESW;
	}

	## -------------------------------- ##
	## Miscellaneous resource variables ##
	## -------------------------------- ##
    	if ($var eq 'ATTACHMENTURL') {
	    $isurl = 0;
	    $tmp = $AttachmentUrl;
	    last REPLACESW;
	}
    	if ($var eq 'DOCURL') {
	    $isurl = 0;
	    $tmp = $DOCURL;
	    last REPLACESW;
	}
	if ($var eq 'ENV') {
	    $tmp = htmlize($ENV{$arg});
	    last REPLACESW;
	}
    	if ($var eq 'GMTDATE') {
	    $tmp = &time2str($arg || $GMTDateFmt, time, 0);
	    last REPLACESW;
	}
    	if ($var eq 'HTMLEXT') {
	    $tmp = $HtmlExt;
	    last REPLACESW;
	}
# 	if ($var eq 'IDXPREFIX') {
# 	    $tmp = $IDXPREFIX;
# 	    last REPLACESW;
# 	}
    	if ($var eq 'LOCALDATE') {
	    $tmp = &time2str($arg || $LocalDateFmt, time, 1);
	    last REPLACESW;
	}
    	if ($var eq 'MSGPREFIX') {
	    $tmp = $MsgPrefix;
	    last REPLACESW;
	}
    	if ($var eq 'OUTDIR') {
	    $tmp = $OUTDIR;
	    last REPLACESW;
	}
    	if ($var eq 'PROG') {
	    $tmp = $PROG;
	    last REPLACESW;
	}
# 	if ($var eq 'TIDXPREFIX') {
# 	    $tmp = $TIDXPREFIX;
# 	    last REPLACESW;
# 	}
    	if ($var eq 'VERSION') {
	    $tmp = $VERSION;
	    last REPLACESW;
	}
    	if ($var eq '') {
	    $tmp = '$';
	    last REPLACESW;
	}

	## --------------------------- ##
	## User defined variable check ##
	## --------------------------- ##
	if (defined($CustomRcVars{$var})) {
	    $expand = 1;
	    $tmp = $CustomRcVars{$var};
	    last REPLACESW;
	}

	warn qq/Warning: Unrecognized variable: "$val"\n/;
	#return "\$$val\$";
	return "";
    }

    ##	Check if string needs to be expanded again
    if ($expand) {
	$tmp =~ s/$VarExp/&replace_li_var($1,$index)/geo;
    }

    ##	Check if URL text specifier is set
    if ($isurl) {
	$ret = &urlize($tmp);
    } else {
	if ($raw) {
	    $ret = &$MHeadCnvFunc($tmp);
	    if ($isaddr) {
		if (!$mailto) {
		    $ret =~ s/($HAddrExp)/htmlize(rewrite_address($1))/geo;
		} else {
		    $ret =~ s/($HAddrExp)/mailUrl($1, $MsgId, $Subject{$index}, $From{$index})/gexo; # $key
		    $canclip = 0;
		}
	    }
	} else {
	    $ret = $tmp;
	}

	# Check for clipping
	if ($len > 0 && $canclip && (length($ret) > 0)) {
	    $ret = &$TextClipFunc($ret, $len, 1);
	}

	# Check if JavaScript string
	if ($jstr) {
	    $ret =~ s/\\/\\\\/g;	# escape backslashes
	    $ret =~ s/(["'])/\\$1/g;	# escape quotes
	    $ret =~ s/\n/\\n/g;		# escape newlines
	    $ret =~ s/\r/\\r/g;		# escape returns
	}
    }

    ##	Check for subject link
    $ret = qq|<a name="| . &fmt_msgnum($IndexNum{$index}) . qq|" href="| . &msgnum_filename($IndexNum{$index}) . qq|">$ret</a>|
	if $var eq 'SUBJECT' && $arg eq '' && !$mailto;

    $ret;
}

sub mhidxrc_set_vars {

    ##-----------------##
    ## Index resources ##
    ##-----------------##

    $IdxTypeStr = $NOSORT ? 'Message' : $SUBSORT ? 'Subject' : $AUTHSORT ? 'Author' : 'Date';
    ## MAIN index resources
    ## if ($MAIN) {

    ## Label for main index
    unless ($IDXLABEL) {
        $IDXLABEL = $IdxTypeStr . ' Index';
        $IsDefault{'IDXLABEL'} = 1;
    }

    ## Beginning of main index page
    unless ($IDXPGBEG) {
        $IDXPGBEG =<<'EndOfStr';
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>$IDXTITLE$</title>
</head>
<body>
<h1>$IDXTITLE$</h1>
EndOfStr
	$IsDefault{'IDXPGBEG'} = 1;
    }

    ##	End of main index page
    unless ($IDXPGEND) {
	$IDXPGEND = "</body>\n</html>\n";
	$IsDefault{'IDXPGEND'} = 1;
    }

    ##	Beginning of main index list
    unless ($LIBEG) {
	$LIBEG  = '';
	$LIBEG .= "<ul>\n" .
		  '<li><a href="$TIDXFNAME$">$TIDXLABEL$</a></li>' .
		  "\n</ul>\n"  if $THREAD;
	$LIBEG .= '$PGLINK(PREV)$$PGLINK(NEXT)$' . "\n"  if $MULTIIDX;
	$LIBEG .= "<hr>\n<ul>\n";
	$IsDefault{'LIBEG'} = 1;
    }

    ## End of main index list
    unless ($LIEND) {
	$LIEND  = "</ul>\n";
	$IsDefault{'LIEND'} = 1;
    }

    ## Main index entry (start, content, and end)
    unless ($LITMPL) {
	$LITMPL = qq|<li><strong>\$SUBJECT\$</strong>\n| .
		  qq|<ul><li><em>From</em>: |;
	if ($SpamMode) {
	    $LITMPL .= q|$FROMNAME$|;
	} else {
	    $LITMPL .= q|$FROM$|;
	}
	$LITMPL .= qq|</li></ul>\n</li>\n|;
	$IsDefault{'LITMPL'} = 1;
    }

    ## Main list group resources
    unless ($AUTHBEG) {
	$AUTHBEG = ''; $IsDefault{'AUTHBEG'} = 1;
    }
    unless ($AUTHEND) {
	$AUTHEND = ''; $IsDefault{'AUTHEND'} = 1;
    }
    unless ($DAYBEG) {
	$DAYBEG = ''; $IsDefault{'DAYBEG'} = 1;
    }
    unless ($DAYEND) {
	$DAYEND = ''; $IsDefault{'DAYEND'} = 1;
    }
    unless ($SUBJECTBEG) {
	$SUBJECTBEG = ''; $IsDefault{'SUBJECTBEG'} = 1;
    }
    unless ($SUBJECTEND) {
	$SUBJECTEND = ''; $IsDefault{'SUBJECTEND'} = 1;
    }

## }

## THREAD index resources
## if ($THREAD) {

    ##	Label for thread index
    unless ($TIDXLABEL) {
	$TIDXLABEL = 'Thread Index';
	$IsDefault{'TIDXLABEL'} = 1;
    }

    ##	Beginning of thread index page
    unless ($TIDXPGBEG) {
	$TIDXPGBEG =<<'EndOfStr';
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>$TIDXTITLE$</title>
</head>
<body>
<h1>$TIDXTITLE$</h1>
EndOfStr
	$IsDefault{'TIDXPGBEG'} = 1;
    }
    ## End of thread index page
    unless ($TIDXPGEND) {
	$TIDXPGEND = "</body>\n</html>\n";
	$IsDefault{'TIDXPGEND'} = 1;
    }

    ## Head of thread index page (also contains list start markup)
    unless ($THEAD) {
	$THEAD  = '';
	$THEAD .= "<ul>\n" .
		  '<li><a href="$IDXFNAME$">$IDXLABEL$</a></li>' .
		  "\n</ul>\n"  if $MAIN;
	$THEAD .= '$PGLINK(TPREV)$$PGLINK(TNEXT)$' . "\n"  if $MULTIIDX;
	$THEAD .= "<hr>\n<ul>\n";
	$IsDefault{'THEAD'} = 1;
    }
    ## Foot of thread index page (also contains list end markup)
    unless ($TFOOT) {
	$TFOOT  = "</ul>\n";
	$IsDefault{'TFOOT'} = 1;
    }

    ## Template for thread entry with no follow-ups
    unless ($TSINGLETXT) {
	$TSINGLETXT =<<'EndOfStr';
<li><strong>$SUBJECT$</strong>,
<em>$FROMNAME$</em></li>
EndOfStr
	$IsDefault{'TSINGLETXT'} = 1;
    }

    ## Template for thread entry that is the start of a thread
    unless ($TTOPBEG) {
	$TTOPBEG =<<'EndOfStr';
<li><strong>$SUBJECT$</strong>,
<em>$FROMNAME$</em>
EndOfStr
	$IsDefault{'TTOPBEG'} = 1;
    }
    ## Template for end of a thread
    unless ($TTOPEND) {
	$TTOPEND = "</li>\n";
	$IsDefault{'TTOPEND'} = 1;
    }

    ## Template for the start of a sub-thread
    unless ($TSUBLISTBEG) {
	$TSUBLISTBEG  = "<ul>\n";
	$IsDefault{'TSUBLISTBEG'} = 1;
    }
    ## Template for the end of a sub-thread
    unless ($TSUBLISTEND) {
	$TSUBLISTEND  = "</ul>\n";
	$IsDefault{'TSUBLISTEND'} = 1;
    }

    ## Template for the start and content of a regular thread entry
    unless ($TLITXT) {
	$TLITXT =<<'EndOfStr';
<li><strong>$SUBJECT$</strong>,
<em>$FROMNAME$</em>
EndOfStr
	$IsDefault{'TLITXT'} = 1;
    }
    ## Template for end of a regular thread entry
    unless ($TLIEND) {
	$TLIEND = "</li>\n";
	$IsDefault{'TLIEND'} = 1;
    }

    ## Template for the start of subject based section
    unless ($TSUBJECTBEG) {
	$TSUBJECTBEG  = "<li>&lt;Possible follow-ups&gt;</li>\n";
	$IsDefault{'TSUBJECTBEG'} = 1;
    }
    ## Template for the end of subject based section
    unless ($TSUBJECTEND) {
	$TSUBJECTEND  = " ";
	$IsDefault{'TSUBJECTEND'} = 1;
    }

    ## Template for start and content of missing message in thread
    unless ($TLINONE) {
	$TLINONE = "<li><em>Message not available</em>";
	$IsDefault{'TLINONE'} = 1;
    }
    ## Template for end of missing message in thread
    unless ($TLINONEEND) {
	$TLINONEEND = "</li>\n";
	$IsDefault{'TLINONEEND'} = 1;
    }

    ## Template for opening an indent (for cross-page threads)
    unless ($TINDENTBEG) {
	$TINDENTBEG = "<ul>\n";
	$IsDefault{'TINDENTBEG'} = 1;
    }
    ## Template for closing an indent (for cross-page threads)
    unless ($TINDENTEND) {
	$TINDENTEND = "</ul>\n";
	$IsDefault{'TINDENTEND'} = 1;
    }

    ## Template for start of a continued thread (for cross-page threads)
    unless ($TCONTBEG) {
	$TCONTBEG = '<li><strong>$SUBJECTNA$</strong>, ' .
		    "<em>(continued)</em>\n";
	$IsDefault{'TCONTBEG'} = 1;
    }
    ## Template for end of a continued thread (for cross-page threads)
    unless ($TCONTEND) {
	$TCONTEND = "</li>\n";
	$IsDefault{'TCONTEND'} = 1;
    }

    $DoMissingMsgs = $TLINONE =~ /\S/;

## }

    ## Thread Slice Resources
    unless ($TSLICEBEG) {
        $TSLICEBEG = "<blockquote><ul>\n";
        $IsDefault{'TSLICEBEG'} = 1;
    }
    unless ($TSLICEEND) {
        $TSLICEEND = "</ul></blockquote>\n";
        $IsDefault{'TSLICEEND'} = 1;
    }

    if ($TSLICELEVELS < 0) {
        $TSLICELEVELS = $TLEVELS;
        $IsDefault{'TSLICELEVELS'} = 1;
    }

    unless ($TSLICESINGLETXT) {
        $TSLICESINGLETXT = $TSINGLETXT;
        $IsDefault{'TSLICESINGLETXT'} = 1;
    }
    unless ($TSLICETOPBEG) {
        $TSLICETOPBEG = $TTOPBEG;
        $IsDefault{'TSLICETOPBEG'} = 1;
    }
    unless ($TSLICETOPEND) {
        $TSLICETOPEND = $TTOPEND;
        $IsDefault{'TSLICETOPEND'} = 1;
    }
    unless ($TSLICESUBLISTBEG) {
        $TSLICESUBLISTBEG = $TSUBLISTBEG;
        $IsDefault{'TSLICESUBLISTBEG'} = 1;
    }
    unless ($TSLICESUBLISTEND) {
        $TSLICESUBLISTEND = $TSUBLISTEND;
        $IsDefault{'TSLICESUBLISTEND'} = 1;
    }
    unless ($TSLICELITXT) {
        $TSLICELITXT = $TLITXT;
        $IsDefault{'TSLICELITXT'} = 1;
    }
    unless ($TSLICELIEND) {
        $TSLICELIEND = $TLIEND;
        $IsDefault{'TSLICELIEND'} = 1;
    }
    unless ($TSLICELINONE) {
        $TSLICELINONE = $TLINONE;
        $IsDefault{'TSLICELINONE'} = 1;
    }
    unless ($TSLICELINONEEND) {
        $TSLICELINONEEND = $TLINONEEND;
        $IsDefault{'TSLICELINONEEND'} = 1;
    }
    unless ($TSLICESUBJECTBEG) {
        $TSLICESUBJECTBEG = $TSUBJECTBEG;
        $IsDefault{'TSLICESUBJECTBEG'} = 1;
    }
    unless ($TSLICESUBJECTEND) {
        $TSLICESUBJECTEND = $TSUBJECTEND;
        $IsDefault{'TSLICESUBJECTEND'} = 1;
    }
    unless ($TSLICEINDENTBEG) {
        $TSLICEINDENTBEG = $TINDENTBEG;
        $IsDefault{'TSLICEINDENTBEG'} = 1;
    }
    unless ($TSLICEINDENTEND) {
        $TSLICEINDENTEND = $TINDENTEND;
        $IsDefault{'TSLICEINDENTEND'} = 1;
    }
    unless ($TSLICECONTBEG) {
        $TSLICECONTBEG = $TCONTBEG;
        $IsDefault{'TSLICECONTBEG'} = 1;
    }
    unless ($TSLICECONTEND) {
        $TSLICECONTEND = $TCONTEND;
        $IsDefault{'TSLICECONTEND'} = 1;
    }

    unless ($TSLICESINGLETXTCUR) {
        $TSLICESINGLETXTCUR = $TSLICESINGLETXT;
        $IsDefault{'TSLICESINGLETXTCUR'} = 1;
    }
    unless ($TSLICETOPBEGCUR) {
        $TSLICETOPBEGCUR = $TSLICETOPBEG;
        $IsDefault{'TSLICETOPBEGCUR'} = 1;
    }
    unless ($TSLICETOPENDCUR) {
        $TSLICETOPENDCUR = $TSLICETOPEND;
        $IsDefault{'TSLICETOPENDCUR'} = 1;
    }
    unless ($TSLICELITXTCUR) {
        $TSLICELITXTCUR = $TSLICELITXT;
        $IsDefault{'TSLICELITXTCUR'} = 1;
    }
    unless ($TSLICELIENDCUR) {
        $TSLICELIENDCUR = $TSLICELIEND;
        $IsDefault{'TSLICELIENDCUR'} = 1;
    }

    ##-------------------##
    ## Message resources ##
    ##-------------------##

    unless (@DateFields) {
        @DateFields  = ('received', 'date');
        @_DateFields = ( ['received',0], ['date',0] );
        $IsDefault{'DATEFIELDS'} = 1;
    } else {
        local($_);
        my $f;
        foreach (@DateFields) {
            s/\s//g;  tr/A-Z/a-z/;
            $f = $_;
            if ($f =~ s/\[(\d+)\]//) {
                push(@_DateFields, [ $f, $1 ]);
            } else {
                push(@_DateFields, [ $f, 0 ]);
            }
        }
    }
    unless (@FromFields) {
        @FromFields = ('from', 'mail-reply-to', 'reply-to', 'return-path',
                    'apparently-from', 'sender', 'resent-sender');
        $IsDefault{'FROMFIELDS'} = 1;
    }

    ## Beginning of message page
    unless ($MSGPGBEG) {
        $MSGPGBEG =<<'EndOfStr';
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>$SUBJECTNA$</title>
EndOfStr

        $MSGPGBEG .= qq|<link rev="made" href="mailto:\$FROMADDR\$">\n| unless $SpamMode;
        $MSGPGBEG .= "</head>\n<body>\n";
        $IsDefault{'MSGPGBEG'} = 1;
    }

    ## End of message page
    unless ($MSGPGEND) {
        $MSGPGEND = "</body>\n</html>\n";
        $IsDefault{'MSGPGEND'} = 1;
    }

    ## Subject header
    unless ($SUBJECTHEADER) {
        $SUBJECTHEADER = '<h1>$SUBJECTNA$</h1>' . "\n<hr>\n";
        $IsDefault{'SUBJECTHEADER'} = 1;
    }

    ## Separator between message data head and message data body
    unless ($HEADBODYSEP) {
        $HEADBODYSEP = "<hr>\n";
        $IsDefault{'HEADBODYSEP'} = 1;
    }

    ## Separator between end of message data and rest of page
    unless ($MSGBODYEND) {
        $MSGBODYEND = "<hr>\n";
        $IsDefault{'MSGBODYEND'} = 1;
    }

    ##---------------------------------##
    ## Mail header formating resources ##
    ##---------------------------------##

    $FIELDSBEG = "<ul>\n",	$IsDefault{'FIELDSBEG'} = 1	unless $FIELDSBEG;
    $FIELDSEND = "</ul>\n",	$IsDefault{'FIELDSEND'} = 1	unless $FIELDSEND;
    $LABELBEG = '<li>',	$IsDefault{'LABELBEG'} = 1  	unless $LABELBEG;
    $LABELEND = ':',	$IsDefault{'LABELEND'} = 1	unless $LABELEND;
    $FLDBEG  = ' ', 	$IsDefault{'FLDBEG'} = 1	unless $FLDBEG;
    $FLDEND  = '</li>',	$IsDefault{'FLDEND'} = 1    	unless $FLDEND;

    ##-----------------------------------##
    ##  Next/prev message link resources ##
    ##-----------------------------------##

    ## Next/prev buttons
    $NEXTBUTTON = '[<a href="$MSG(NEXT)$">'.$IdxTypeStr.' Next</a>]', $IsDefault{'NEXTBUTTON'} = 1 unless $NEXTBUTTON;
    $PREVBUTTON = '[<a href="$MSG(PREV)$">'.$IdxTypeStr.' Prev</a>]', $IsDefault{'PREVBUTTON'} = 1 unless $PREVBUTTON;
    $NEXTBUTTONIA = "[$IdxTypeStr Next]", $IsDefault{'NEXTBUTTONIA'} = 1 unless $NEXTBUTTONIA;
    $PREVBUTTONIA = "[$IdxTypeStr Prev]", $IsDefault{'PREVBUTTONIA'} = 1 unless $PREVBUTTONIA;

    ## Next message link
    unless ($NEXTLINK) {
        $NEXTLINK =<<EndOfStr;
<li>Next by $IdxTypeStr:
<strong><a href="\$MSG(NEXT)\$">\$SUBJECT(NEXT)\$</a></strong>
</li>
EndOfStr
        $IsDefault{'NEXTLINK'} = 1;
    }

    ## Inactive next message link
    $NEXTLINKIA = '', $IsDefault{'NEXTLINKIA'} = 1	unless $NEXTLINKIA;

    ## Previous message link
    unless ($PREVLINK) {
        $PREVLINK =<<EndOfStr;
<li>Prev by $IdxTypeStr:
<strong><a href="\$MSG(PREV)\$">\$SUBJECT(PREV)\$</a></strong>
</li>
EndOfStr
        $IsDefault{'PREVLINK'} = 1;
    }

    ## Inactive previous message link
    $PREVLINKIA = '', $IsDefault{'PREVLINKIA'} = 1  unless $PREVLINKIA;

    ## Thread next/previous buttons
    $TNEXTBUTTON = '[<a href="$MSG(TNEXT)$">Thread Next</a>]',
        $IsDefault{'TNEXTBUTTON'} = 1	unless $TNEXTBUTTON;
    $TPREVBUTTON = '[<a href="$MSG(TPREV)$">Thread Prev</a>]',
        $IsDefault{'TPREVBUTTON'} = 1	unless $TPREVBUTTON;
    $TNEXTBUTTONIA = '[Thread Next]',
        $IsDefault{'TNEXTBUTTONIA'} = 1	unless $TNEXTBUTTONIA;
    $TPREVBUTTONIA = '[Thread Prev]',
        $IsDefault{'TPREVBUTTONIA'} = 1	unless $TPREVBUTTONIA;

    $TNEXTINBUTTON = '[<a href="$MSG(TNEXTIN)$">Next in Thread</a>]',
        $IsDefault{'TNEXTINBUTTON'} = 1	unless $TNEXTINBUTTON;
    $TNEXTINBUTTONIA = '[Next in Thread]',
        $IsDefault{'TNEXTINBUTTONIA'} = 1	unless $TNEXTINBUTTONIA;
    $TPREVINBUTTON = '[<a href="$MSG(TPREVIN)$">Prev in Thread</a>]',
        $IsDefault{'TPREVINBUTTON'} = 1	unless $TPREVINBUTTON;
    $TPREVINBUTTONIA = '[Prev in Thread]',
        $IsDefault{'TPREVINBUTTONIA'} = 1	unless $TPREVINBUTTONIA;

    $TNEXTTOPBUTTON = '[<a href="$MSG(TNEXTTOP)$">Next Thread</a>]',
        $IsDefault{'TNEXTTOPBUTTON'} = 1	unless $TNEXTTOPBUTTON;
    $TNEXTTOPBUTTONIA = '[Next Thread]',
        $IsDefault{'TNEXTTOPBUTTONIA'} = 1	unless $TNEXTTOPBUTTONIA;
    $TPREVTOPBUTTON = '[<a href="$MSG(TPREVTOP)$">Prev Thread</a>]',
        $IsDefault{'TPREVTOPBUTTON'} = 1	unless $TPREVTOPBUTTON;
    $TPREVTOPBUTTONIA = '[Prev Thread]',
        $IsDefault{'TPREVTOPBUTTONIA'} = 1	unless $TPREVTOPBUTTONIA;

    $TTOPBUTTON = '[<a href="$MSG(TTOP)$">First in Thread</a>]',
        $IsDefault{'TTOPBUTTON'} = 1	unless $TTOPBUTTON;
    $TTOPBUTTONIA = '[First in Thread]',
        $IsDefault{'TTOPBUTTONIA'} = 1	unless $TTOPBUTTONIA;
    $TENDBUTTON = '[<a href="$MSG(TEND)$">Last in Thread</a>]',
        $IsDefault{'TENDBUTTON'} = 1	unless $TENDBUTTON;
    $TENDBUTTONIA = '[Last in Thread]',
        $IsDefault{'TENDBUTTONIA'} = 1	unless $TENDBUTTONIA;

    ## Next message by thread link
    unless ($TNEXTLINK) {
        $TNEXTLINK =<<'EndOfStr';
<li>Next by thread:
<strong><a href="$MSG(TNEXT)$">$SUBJECT(TNEXT)$</a></strong>
</li>
EndOfStr
        $IsDefault{'TNEXTLINK'} = 1;
    }
    ## Inactive next message in thread link
    $TNEXTLINKIA = '', $IsDefault{'TNEXTLINKIA'} = 1  unless $TNEXTLINKIA;

    ## Previous message by thread link
    unless ($TPREVLINK) {
        $TPREVLINK =<<'EndOfStr';
<li>Previous by thread:
<strong><a href="$MSG(TPREV)$">$SUBJECT(TPREV)$</a></strong>
</li>
EndOfStr
        $IsDefault{'TPREVLINK'} = 1;
    }
    ## Inactive previous message in thread link
    $TPREVLINKIA = '', $IsDefault{'TPREVLINKIA'} = 1  unless $TPREVLINKIA;

    ## Next message within thread link
    unless ($TNEXTINLINK) {
        $TNEXTINLINK =<<'EndOfStr';
<li>Next in thread:
<strong><a href="$MSG(TNEXTIN)$">$SUBJECT(TNEXTIN)$</a></strong>
</li>
EndOfStr
        $IsDefault{'TNEXTINLINK'} = 1;
    }
    ## Inactive next message within thread link
    $TNEXTINLINKIA = '', $IsDefault{'TNEXTINLINKIA'} = 1  unless $TNEXTINLINKIA;

    ## Previous message within thread link
    unless ($TPREVINLINK) {
        $TPREVINLINK =<<'EndOfStr';
<li>Previous in thread:
<strong><a href="$MSG(TPREVIN)$">$SUBJECT(TPREVIN)$</a></strong>
</li>
EndOfStr
        $IsDefault{'TPREVINLINK'} = 1;
    }
    ## Inactive previous message within thread link
    $TPREVINLINKIA = '', $IsDefault{'TPREVINLINKIA'} = 1  unless $TPREVINLINKIA;

    ## Next thread
    unless ($TNEXTTOPLINK) {
        $TNEXTTOPLINK =<<'EndOfStr';
<li>Next thread:
<strong><a href="$MSG(TNEXTTOP)$">$SUBJECT(TNEXTTOP)$</a></strong>
</li>
EndOfStr
        $IsDefault{'TNEXTTOPLINK'} = 1;
    }
    ## Inactive next thread
    $TNEXTTOPLINKIA = '', $IsDefault{'TNEXTTOPLINKIA'} = 1  unless $TNEXTTOPLINKIA;

    ## Previous thread
    unless ($TPREVTOPLINK) {
        $TPREVTOPLINK =<<'EndOfStr';
<li>Previous thread:
<strong><a href="$MSG(TPREVTOP)$">$SUBJECT(TPREVTOP)$</a></strong>
</li>
EndOfStr
        $IsDefault{'TPREVTOPLINK'} = 1;
    }
    ## Inactive prev thread
    $TPREVTOPLINKIA = '', $IsDefault{'TPREVTOPLINKIA'} = 1  unless $TPREVTOPLINKIA;

    ## First in thread
    unless ($TTOPLINK) {
        $TTOPLINK =<<'EndOfStr';
<li>First in thread:
<strong><a href="$MSG(TTOP)$">$SUBJECT(TTOP)$</a></strong>
</li>
EndOfStr
        $IsDefault{'TTOPLINK'} = 1;
    }
    ## Inactive first in thread
    $TTOPLINKIA = '', $IsDefault{'TTOPLINKIA'} = 1  unless $TTOPLINKIA;

    ## Last in thread
    unless ($TENDLINK) {
        $TENDLINK =<<'EndOfStr';
<li>Last in thread:
<strong><a href="$MSG(TEND)$">$SUBJECT(TEND)$</a></strong>
</li>
EndOfStr
        $IsDefault{'TENDLINK'} = 1;
    }
    ## Inactive last in thread
    $TENDLINKIA = '', $IsDefault{'TENDLINKIA'} = 1  unless $TENDLINKIA;

    ## Top links in message
    if (!$TOPLINKS) {
        $TOPLINKS  = "<hr>\n";
        $TOPLINKS .= '$BUTTON(PREV)$$BUTTON(NEXT)$'
            if $MAIN;
        $TOPLINKS .= '$BUTTON(TPREV)$$BUTTON(TNEXT)$'
            if $THREAD;
        $TOPLINKS .= '[<a href="$IDXFNAME$#$MSGNUM$">$IDXLABEL$</a>]'
            if $MAIN;
        $TOPLINKS .= '[<a href="$TIDXFNAME$#$MSGNUM$">$TIDXLABEL$</a>]'
            if $THREAD;
        $IsDefault{'TOPLINKS'} = 1;
    }

    ## Bottom links in message
    if (!$BOTLINKS) {
        $BOTLINKS =  "<ul>\n";
        $BOTLINKS .= '$LINK(PREV)$$LINK(NEXT)$'  if $MAIN;
        $BOTLINKS .= '$LINK(TPREV)$$LINK(TNEXT)$'  if $THREAD;
        if ($MAIN || $THREAD) {
            $BOTLINKS .= "<li>Index(es):\n<ul>\n";
            $BOTLINKS .= '<li><a href="$IDXFNAME$#$MSGNUM$">' .
                        "<strong>$IdxTypeStr</strong></a></li>\n"  if $MAIN;
            $BOTLINKS .= '<li><a href="$TIDXFNAME$#$MSGNUM$">' .
                        "<strong>Thread</strong></a></li>\n"  if $THREAD;
        }
        $BOTLINKS .= "</ul>\n</li>\n</ul>\n";
        $IsDefault{'BOTLINKS'} = 1;
    }

    ## Follow-up and References resources
    unless ($FOLUPBEGIN) {
        $FOLUPBEGIN =<<'EndOfVar';
<ul><li><strong>Follow-Ups</strong>:
<ul>
EndOfVar
        $IsDefault{'FOLUPBEGIN'} = 1;
    }
    unless ($FOLUPLITXT) {
        if ($SpamMode) {
            $FOLUPLITXT =<<'EndOfVar';
<li><strong>$SUBJECT$</strong>
<ul><li><em>From:</em> $FROMNAME$</li></ul></li>
EndOfVar
        } else {
            $FOLUPLITXT =<<'EndOfVar';
<li><strong>$SUBJECT$</strong>
<ul><li><em>From:</em> $FROM$</li></ul></li>
EndOfVar
        }
        $IsDefault{'FOLUPLITXT'} = 1;
    }
    unless ($FOLUPEND) {
        $FOLUPEND =<<'EndOfVar';
</ul></li></ul>
EndOfVar
        $IsDefault{'FOLUPEND'} = 1;
    }

    unless ($REFSBEGIN) {
        $REFSBEGIN =<<'EndOfVar';
<ul><li><strong>References</strong>:
<ul>
EndOfVar
        $IsDefault{'REFSBEGIN'} = 1;
    }
    unless ($REFSLITXT) {
        if ($SpamMode) {
        $REFSLITXT =<<'EndOfVar';
<li><strong>$SUBJECT$</strong>
<ul><li><em>From:</em> $FROMNAME$</li></ul></li>
EndOfVar
        } else {
            $REFSLITXT =<<'EndOfVar';
<li><strong>$SUBJECT$</strong>
<ul><li><em>From:</em> $FROM$</li></ul></li>
EndOfVar
        }
        $IsDefault{'REFSLITXT'} = 1;
    }
    unless ($REFSEND) {
        $REFSEND =<<'EndOfVar';
</ul></li></ul>
EndOfVar
        $IsDefault{'REFSEND'} = 1;
    }

    ##--------------------------------------------##
    ## Next/previous main/thread index page links ##
    ##--------------------------------------------##

    $FIRSTPGLINK = '[<a href="$PG(FIRST)$">First Page</a>]',
        $IsDefault{'FIRSTPGLINK'} = 1	unless $FIRSTPGLINK;
    $LASTPGLINK  = '[<a href="$PG(LAST)$">Last Page</a>]',
        $IsDefault{'LASTPGLINK'} = 1	unless $LASTPGLINK;
    $NEXTPGLINK  = '[<a href="$PG(NEXT)$">Next Page</a>]',
        $IsDefault{'NEXTPGLINK'} = 1	unless $NEXTPGLINK;
    $PREVPGLINK  = '[<a href="$PG(PREV)$">Prev Page</a>]',
        $IsDefault{'PREVPGLINK'} = 1	unless $PREVPGLINK;

    $TFIRSTPGLINK = '[<a href="$PG(TFIRST)$">First Page</a>]',
        $IsDefault{'TFIRSTPGLINK'} = 1	unless $TFIRSTPGLINK;
    $TLASTPGLINK  = '[<a href="$PG(TLAST)$">Last Page</a>]',
        $IsDefault{'TLASTPGLINK'} = 1	unless $TLASTPGLINK;
    $TNEXTPGLINK  = '[<a href="$PG(TNEXT)$">Next Page</a>]',
        $IsDefault{'TNEXTPGLINK'} = 1	unless $TNEXTPGLINK;
    $TPREVPGLINK  = '[<a href="$PG(TPREV)$">Prev Page</a>]',
        $IsDefault{'TPREVPGLINK'} = 1	unless $TPREVPGLINK;

    $NEXTPGLINKIA  = '[Next Page]',
        $IsDefault{'NEXTPGLINKIA'} = 1	unless $NEXTPGLINKIA;
    $PREVPGLINKIA  = '[Prev Page]',
        $IsDefault{'PREVPGLINKIA'} = 1	unless $PREVPGLINKIA;
    $TNEXTPGLINKIA = '[Next Page]',
        $IsDefault{'TNEXTPGLINKIA'} = 1	unless $TNEXTPGLINKIA;
    $TPREVPGLINKIA = '[Prev Page]',
        $IsDefault{'TPREVPGLINKIA'} = 1	unless $TPREVPGLINKIA;

    ##---------------##
    ## Miscellaneous ##
    ##---------------##

    $MSGIDLINK = '<a $A_HREF$>$MSGID$</a>',
        $IsDefault{'MSGIDLINK'} = 1	unless $MSGIDLINK;

    $NOTE	    = '$NOTETEXT$',
        $IsDefault{'NOTE'} = 1		unless $NOTE;
    $NOTEIA	    = '',
        $IsDefault{'NOTEIA'} = 1		unless $NOTEIA;
    $NOTEICON   = '',
        $IsDefault{'NOTEICON'} = 1		unless $NOTEICON;
    $NOTEICONIA = '',
        $IsDefault{'NOTEICONIA'} = 1	unless $NOTEICONIA;

    ##	Set unknown icon
    $Icons{'unknown'} = $Icons{'text/plain'}  unless $Icons{'unknown'};

    ##
    if ($AddressModify eq "") {
        $AddressModify =
            q{s|@(.+)$|'@'.('x' x length($1))|ge}
            if $SpamMode;
        $IsDefault{'AddressModify'} = 1;
    }

    if ($MAILTOURL eq "") {
        if ($SpamMode) {
            $MAILTOURL = 'mailto:$TOADDRNAME$@DOMAIN.HIDDEN';
        } else {
            $MAILTOURL = 'mailto:$TO$';
        }
        $IsDefault{'MAILTOURL'} = 1;
    }

    if ($NewsUrl eq "") {
        $NewsUrl = 'news:$NEWSGROUP$';
        $IsDefault{'NEWSURL'} = 1;
    }

    if (!defined($AddrModifyBodies)) {
        $AddrModifyBodies  = 1  if $SpamMode;
    }

}

my $_sub_eval_cnt = 0;

##---------------------------------------------------------------------------
##	create_routines is used to dynamically create routines that
##	would benefit from being create at run-time.  Routines
##	that have to check against several regular expressions
##	are candidates.
##
##	NOTE: Subroutine references would be cleaner, but code
##	      pre-dates Perl 5 where references were not supported.
##
sub create_routines {
    my($sub) = '';

    ##-----------------------------------------------------------------------
    ## exclude_field: Used to determine if field should be excluded from
    ## message header
    ##
    $sub  =<<'EndOfRoutine';
    sub exclude_field {
	my($f) = shift;
	my $ret = 0;
	EXC_FIELD_SW: {
EndOfRoutine

    # Create switch block for checking field against regular
    # expressions (a large || statement could also work).
    my $pat;
    foreach $pat (keys %HFieldsExc) {
	$sub .= join('',
		     'if ($f =~ /^',
		     $pat,
		     '/i) { $ret = 1;  last EXC_FIELD_SW; }',
		     "\n");
    }

    $sub .=<<'EndOfRoutine';
	};
	$ret;
    }
EndOfRoutine

    $sub .= "# $_sub_eval_cnt\n";  ++$_sub_eval_cnt;
    eval $sub;
    die("ERROR: Unable to create exclude_field routine:\n$@\n") if $@;

    ##-----------------------------------------------------------------------
    ## subject_strip: Used to apply user-defined s/// operations on
    ## message subjects as they are read;
    ##
    $sub  =<<EndOfRoutine;
    sub subject_strip {
	local(\$_) = shift;
	$SubStripCode;
	\$_;
    }
EndOfRoutine

    $sub .= "# $_sub_eval_cnt\n";  ++$_sub_eval_cnt;
    eval $sub;
    die("ERROR: Unable to create subject_strip routine:\n$@\n") if $@;

    ##-----------------------------------------------------------------------
    ##	Routine to determine last message number in use.
    ##  If $LastMsgNum set, we return it after a sanity check
    ##  is done.  If check fails, scan directory to determine last number.
    ##
    $sub =<<'EndOfRoutine';
    sub get_last_msg_num {
	opendir(DIR, $OUTDIR) || die("ERROR: Unable to open $OUTDIR\n");
	my($max) = -1;
        if ($LastMsgNum >= 0) {
           return $LastMsgNum if (
                 -s $OUTDIR . $DIRSEP . msgnum_filename($LastMsgNum)) &&
                 ((! -f $OUTDIR . $DIRSEP . msgnum_filename($LastMsgNum + 1))
           );
        }

	my $msgrex = '^'.
		     "\Q$MsgPrefix".
		     '(\d+)\.'.
		     "\Q$HtmlExt".
		     '$';
	chop $msgrex  if ($HtmlExt =~ /html$/i);

	foreach (readdir(DIR)) {
	    if (/$msgrex/io) { $max = int($1)  if $1 > $max; }
	}
	closedir(DIR);
        $LastMsgNum = $max;
	$max;
    }
EndOfRoutine

    $sub .= "# $_sub_eval_cnt\n";  ++$_sub_eval_cnt;
    eval $sub;
    die("ERROR: Unable to create get_last_msg_num routine:\n$@\n") if $@;

    ##-----------------------------------------------------------------------
    ##	Routine to get base subject text from index
    ##
    $sub =<<'EndOfRoutine';
    sub get_base_subject {
	my($ret) = ($Subject{$_[0]});
	1 while $ret =~ s/$SubReplyRxp//io;
	if ($ret eq "") {
	    return $NoSubjectTxt;
	}
	$ret;
    }
EndOfRoutine

    $sub .= "# $_sub_eval_cnt\n";  ++$_sub_eval_cnt;
    eval $sub;
    die("ERROR: Unable to create get_base_subject routine:\n$@\n") if $@;

    ##-----------------------------------------------------------------------
    ##	Routine to rewrite mail addresses in message header
    ##
    $sub =<<EndOfRoutine;
    sub rewrite_address {
	#package SO::Mail::Message::Pkg_rewrite_address;
	local \$_ = SO::Mail::Message::dehtmlize(shift);
	$AddressModify;
	\$_;
    }
EndOfRoutine

    $sub .= "# $_sub_eval_cnt\n";  ++$_sub_eval_cnt;
    eval $sub;
    die("ERROR: Unable to create rewrite_address routine:\n$@\n") if $@;

    ##-----------------------------------------------------------------------
    ##	Routine to rewrite raw mail addresses
    ##
    $sub =<<EndOfRoutine;
sub rewrite_raw_address {
    #package SO::Mail::Message::Pkg_rewrite_raw_address;
    local \$_ = shift;
    $AddressModify;
    \$_;
}
EndOfRoutine
    $sub .= "# $_sub_eval_cnt\n";  ++$_sub_eval_cnt;
    eval $sub;
    die("ERROR: Unable to create rewrite_raw_address routine:\n$@\n")
	if $@;

    ##-----------------------------------------------------------------------
    ## message_exclude: User-defined code to check if a message should
    ## be added or not.
    ##
    $sub  =<<EndOfRoutine;
    sub message_exclude {
	#package SO::Mail::Message::Pkg_message_exclude;
	local(\$_) = shift;
	$MsgExcFilter;
    }
EndOfRoutine

    $sub .= "# $_sub_eval_cnt\n";  ++$_sub_eval_cnt;
    eval $sub;
    die("ERROR: Unable to create subject_strip routine:\n$@\n") if $@;

}
##---------------------------------------------------------------------------##
1;
