#!/usr/bin/perl
## -*- Encoding:utf-8; Mode:perl; -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
package SO::Mail::Message;
#use strict;
#use warnings;
use Errno qw(EAGAIN EINTR);
#use Data::Dumper;
use File::Temp qw(tempfile mkstemps);

###############################################################################

sub getEnvVar {
    my $varname = shift;
    return '' unless $varname;
    my $var = `echo \$$varname`; chomp $var;
    $var
}
###############################################################################

# sub write2log {
#     my $mess = shift;
#     open(FH_LOG, ">>", '/home/klimiky/log1.log') or die "Unable to open file 'log1.log'";
#     print FH_LOG $mess;
#     close(FH_LOG);
# }
###############################################################################

sub initialize {
    our $TempFileName = '';
    our $TempFile = '';
    our $Message = '';
    our $QUIET          = 1;
    our $DEBUG          = 0;
    our $CODE           = 0;
    our $ERROR          = '';
    our @OrgARGV        = ();
    our $ArchiveOpen    = 0;
    our $_msgid_cnt     = 0;
    ## Initialize variables
    require 'MHInit.pm'; mhinit_vars();
    ## Require some more libaries
    require 'MHUtils.pm';
    require 'MHTime.pm';
    require 'MHFile.pm';
    require 'MHRcFile.pm';
    require 'ReadMail.pm';
    mhinit_readmail_vars();
    ## Read default resource file
    DEFRCFILE: {
        if ($DefRcFile) {
            last DEFRCFILE if read_resource_file($DefRcFile);
        }
        my $home_dir = $CURDIR;
        if (defined $home_dir) {
            # check if in home directory
            last DEFRCFILE if read_resource_file(join($DIRSEP, $home_dir, $DefRcName), 1);
        }
        local $_;
        foreach (@INC) {
            next if ($_ eq $home_dir);
            last DEFRCFILE if read_resource_file(join($DIRSEP, $_, $DefRcName), 1);
        }
    }
    ## Set locale
    eval {
        require POSIX;
        POSIX::setlocale(&POSIX::LC_ALL, $Lang || '');
    };
    warn qq/Warning: Setting locale appears to not be supported: $@\n/ if $@ && $Lang;
    # If text encoding has been specified, change $MHeadCnvFunc.
    $MHeadCnvFunc = \&htmlize_enc_head if defined(ReadMail::load_textencoder());
    ## Set alternative prefs
    ReadMail::MAILset_alternative_prefs(@MIMEAltPrefs);
    $IsDefault{'MIMEALTPREFS'} = !scalar(@MIMEAltPrefs);
    ##  Set umask
    eval { umask oct($UMASK); } if $UNIX;
    ## Clean up list-based resources
    @ExtraHFields = remove_dups(\@ExtraHFields);
    @FieldOrder   = remove_dups(\@FieldOrder);

    ## Set date names
    &set_date_names(\@weekdays, \@Weekdays, \@months, \@Months);

    ## Set %Zone with user-specified timezones
    while (($zone, $offset) = each(%ZoneUD)) {
        $Zone{$zone} = $offset;
    }
    require 'MHRcVars.pm'; mhidxrc_set_vars(); create_routines();
    ## Load text clipping function
    $IsDefault{'TEXTCLIPFUNC'} = 0;
    1;
}
###############################################################################
BEGIN {
    our $HOME = getEnvVar('PWD');
    our $CURDIR = $HOME . '/SO/Mail';

    eval "use lib ('$CURDIR', 'WORKING_DIR/SO/Mail')";

    ## Check what system we are executing under
    require 'OSInit.pm';  &OSinit();

    ## Check if running setuid/setgid
    $TaintMode = 0;
    if ($UNIX && (( $< != $> ) || ( $( != $) ))) {
        ## We do not support setuid since there are too many
        ## security problems to handle, and if we did, mhonarc
        ## would probably not be very useful.
        die "ERROR: setuid/setgid execution not supported!\n";

        #$TaintMode = 1;
        #$ENV{'PATH'}  = '/bin:/usr/bin';
        #$ENV{'SHELL'} = '/bin/sh'  if exists $ENV{'SHELL'};
        #delete @ENV{qw(IFS CDPATH ENV BASH_ENV)};
    }
    initialize();
}
###############################################################################

# sub printMessage {
#     my $msg = shift;
#     my ($file_content, $is_get_row) = ('', 0);
#     my ($fh_tmp1, $tmp_filename1) = mkstemps('/var/www/quarantine/spamooborona/so-quarantine-msgXXXXXX', '.eml');
#     print $fh_tmp1 $msg;
#     close($fh_tmp1);
#     my ($tmp_fh, $tmp_filename2) = mkstemps('/var/www/quarantine/spamooborona/so-quarantine-msgXXXXXX', '.htm');
#     close($tmp_fh);
#     chmod 0666, $tmp_filename1, $tmp_filename2;
#     my $info = `/var/www/quarantine/cgi-bin/MHonArc/mhonarc -single -lang ru_RU.UTF-8 $tmp_filename1 > $tmp_filename2`;
#     #write2log($info."\n") if $info;
#     open(FH_TMP, "<", $tmp_filename2) or die "Error while opening file '$tmp_filename2': $!\n";
#     while (<FH_TMP>) {
#         #if ($_ =~ /^<body>/) { $is_get_row = 1; next }
#         #if ($_ =~ /^<\/body>/) { $is_get_row = 0; next }
#         print $_ if $is_get_row;
#     }
#     close(FH_TMP);
#     $TempFileName = substr($tmp_filename2, rindex($tmp_filename2, '/') + 1);
#     unlink $tmp_filename1;
# }
###############################################################################

sub closeTempFile {
    if ($TempFile) {
        unlink $TempFile; $TempFile = '';
    }
}

###############################################################################

sub convertMessage2HTML {
    ($MsgRawText, $BaseUrl, $IsRemoveExternUrls) = @_;
    $BaseUrl .= '?' unless $BaseUrl =~ /\?/;
    my ($index, $fields, $msg_body) = read_message_header($MsgRawText);
    $MsgBody = read_message_body($msg_body, $index, $fields);
    convert_message_to_html($index, 1, 0);
}
###############################################################################

sub convert_message_to_html {
    my ($index, $force, $nocustom) = @_;
    my ($tmp2, $template);
    my $msg = '';

    ## Output HTML header
    if (!$nocustom) {
        $template = ($MSGPGSSMARKUP ne '') ? $MSGPGSSMARKUP : $SSMARKUP;
        if ($template ne '') {
            $template =~ s/$VarExp/&replace_li_var($1,$index)/geo;
            $msg .= $template;
        }

        # Output comments -- more informative, but can be used for
        #                    error recovering.
        if ($PrintXComments) {
            $msg .= '<!--X-Subject: ' . commentize($Subject{$index}) . " -->\n" . '<!--X-From-R13: ' . commentize(mrot13($From{$index})), " -->\n" .
                '<!--X-Date: ' . commentize($Date{$index}) . " -->\n" . '<!--X-Message-Id: ' . commentize($MsgId) . " -->\n" .
                '<!--X-Content-Type: ' . commentize($ContentType{$index}) . " -->\n";
        }
        $msg .= "<!--X-Head-End-->\n";
        # Add in user defined markup
        #($template = $MSGPGBEG) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
        #print $msghandle $template;
    }
    $msg .= "<!--X-Body-Begin-->\n";

    ## Output header
    $msg .= "<!--X-User-Header-->\n";
    if (!$nocustom) {
        ($template = $MSGHEAD) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
        $msg .= $template;
    }
    $msg .= "<!--X-User-Header-End-->\n";

    ## Output message data
    $msg .= "<!--X-MsgBody-->\n";
    $msg .= "<!--X-Subject-Header-Begin-->\n";
    ($template = $SUBJECTHEADER) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
    $msg .= $template;
    $msg .= "<!--X-Subject-Header-End-->\n";

    #$MsgHead =~ s/($HAddrExp)/&link_refmsgid($1)/geo;
    #$MsgBody =~ s/($HAddrExp)/&link_refmsgid($1)/geo;

    $msg .= "<!--X-Head-of-Message-->\n";
    $msg .= $MsgHead;
    $msg .= "<!--X-Head-of-Message-End-->\n";
    $msg .= "<!--X-Head-Body-Sep-Begin-->\n";
    ($template = $HEADBODYSEP) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
    $msg .= $template;
    $msg .= "<!--X-Head-Body-Sep-End-->\n";
    $msg .= "<!--X-Body-of-Message-->\n";
    $msg .= $MsgBody."\n";
    $msg .= "<!--X-Body-of-Message-End-->\n";
    $msg .= "<!--X-MsgBody-End-->\n";

    ## Output any followup messages
    $msg .= "<!--X-Follow-Ups-->\n";
    ($template = $MSGBODYEND) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
    $msg .= $template;
    if (!$nocustom && $DoFolRefs && defined($Follow{$index})) {
        if (scalar(@{$Follow{$index}})) {
            ($template = $FOLUPBEGIN) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
            $msg .= $template;
            foreach (@{$Follow{$index}}) {
                ($template = $FOLUPLITXT) =~ s/$VarExp/&replace_li_var($1,$_)/geo;
                $msg .= $template;
            }
            ($template = $FOLUPEND) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
            $msg .= $template;
        }
    }
    $msg .= "<!--X-Follow-Ups-End-->\n";

    ## Output any references
    $msg .= "<!--X-References-->\n";
    if (!$nocustom && $DoFolRefs && defined($Refs{$index})) {
        $tmp2 = 0;      # flag for when first ref printed
        if (scalar(@{$Refs{$index}})) {
            my($ref_msgid, $ref_index, $ref_num);
            foreach $ref_msgid (@{$Refs{$index}}) {
                next  unless defined($ref_index = $MsgId{$ref_msgid});
                next  unless defined($ref_num = $IndexNum{$ref_index});
                if (!$tmp2) {
                    ($template = $REFSBEGIN) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
                    $msg .= $template;
                    $tmp2 = 1;
                }
                ($template = $REFSLITXT) =~ s/$VarExp/&replace_li_var($1,$ref_index)/geo;
                $msg .= $template;
            }

            if ($tmp2) {
                ($template = $REFSEND) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
                $msg .= $template;
            }
        }
    }
    $msg .= "<!--X-References-End-->\n";

    ## Output footer
    $msg .= "<!--X-User-Footer-->\n";
    if (!$nocustom) {
        ($template = $MSGFOOT) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
        $msg .= $template;
    }
    $msg .= "<!--X-User-Footer-End-->\n";

    #if (!$nocustom) {
        #($template = $MSGPGEND) =~ s/$VarExp/&replace_li_var($1,$index)/geo;
        #print $msghandle $template;
    #}
    $msg
}
###############################################################################

sub read_message_header {
    my $msg = shift;
    my ($date, $tmp, $i, $field, $value);
    my ($from, $sub, $ctype);
    local($_);

    my $index  = undef;
    my $msgnum = undef;
    my @refs   = ();
    my @array  = ();
    my ($fields, $header, $msg_body, $fieldNames) = _read_file_header($msg);
    ##------------##
    ## Get Msg-ID ##
    ##------------##
    $fields->{'message-id'}[0] =~ s/<([^>]*)>/&lt;$1&gt;/i if defined($fields->{'message-id'}) and $fields->{'message-id'}[0];
    $fields->{'msg-id'}[0] =~ s/<([^>]*)>/&lt;$1&gt;/i if defined($fields->{'msg-id'}) and $fields->{'msg-id'}[0];
    $MsgId = $fields->{'message-id'}[0] || $fields->{'msg-id'}[0] || $fields->{'content-id'}[0];
    if (defined($MsgId)) {
        if ($MsgId =~ /<([^>]*)>/) {
            $MsgId = $1;
        } else {
            $MsgId =~ s/^\s+//;
            $MsgId =~ s/\s+$//;
        }
    } else {
        # create bogus ID if none exists
        eval {
            # create message-id using md5 digest of header;
            # can potentially skip over already archived messages w/o id
            require Digest::MD5;
            $MsgId = join('', Digest::MD5::md5_hex($header), '@NO-ID-FOUND.yandex.ru');
        };
        if ($@) {
            # unable to require, so create arbitary message-id
            $MsgId = join('', $$,'.',time,'.',$_msgid_cnt++, '@NO-ID-FOUND.yandex.ru');
        }
    }
    #write2log("Fields: ".Dumper($fields).".\n");
    #write2log("DateFields: ".Dumper(\@_DateFields).".\n");
    ##----------##
    ## Get date ##
    ##----------##
    $date = '';
    foreach (@_DateFields) {
        ($field, $i) = @{$_}[0,1];
        next unless defined($fields->{$field}) && defined($value = $fields->{$field}[$i]);

        ## Treat received field specially
        if ($field eq 'received') {
            @array = split(/;/, $value);
#           if ((scalar(@array) <= 1) || (scalar(@array) > 2)) {
#               warn qq/\nWarning: Received header field looks improper:\n/,
#                      qq/         Received: $value\n/,
#                      qq/         Message-Id: <$MsgId>\n/;
#           }
            $date = pop @array;
        ## Any other field should just be a date
        } else {
            $date = $value;
        }
        $date =~ s/^\s+//;  $date =~ s/\s+$//;

        ## See if time_t can be determined.
        if (($date =~ /\w/) && (@array = parse_date($date))) {
            $index = get_time_from_date(@array[1..$#array]);
            last;
        }
    }
    if (!$index) {
        warn qq/\nWarning: read_message_header: Could not parse date for message\n/,
               qq/         Message-Id: <$MsgId>\n/,
               qq/         Date: $date\n/;
        # Use current time
        $index = time;
        # Set date string to local date if not defined
        $date  = &time2str('', $index, 1)  unless $date =~ /\S/;
    }

    ##-------------##
    ## Get Subject ##
    ##-------------##
    if (defined($fields->{'subject'})) {
        ($sub = $fields->{'subject'}[0]) =~ s/\s+$//;
        if ($SubStripCode) {
            $fields->{'x-mha-org-subject'} = $sub;
            $sub = subject_strip($sub);
        }
        $fields->{'subject'} = [ $sub ];    # Make sure only one subject
    } else {
        $sub = '';
    }

    ##----------##
    ## Get From ##
    ##----------##
    $from = '';
    foreach (@FromFields) {
        next  unless defined $fields->{$_};
        $from = $fields->{$_}[0];
        last;
    }
    $from = 'Unknown'  unless $from;

    ##----------------##
    ## Get References ##
    ##----------------##
    if (defined($fields->{'references'})) {
        $tmp = $fields->{'references'}[0];
        while ($tmp =~ s/<([^<>]+)>//) {
            push(@refs, $1);
        }
    }
    if (defined($fields->{'in-reply-to'})) {
        my $irtoid;
        foreach (@{$fields->{'in-reply-to'}}) {
            $tmp = $_;
            $irtoid = "";
            while ($tmp =~ s/<([^<>]+)>//) { $irtoid = $1 };
            push(@refs, $irtoid)  if $irtoid;
        }
    }
    @refs = remove_dups(\@refs);        # Remove duplicate msg-ids

    ##------------------##
    ## Get Content-Type ##
    ##------------------##
    if (defined($fields->{'content-type'})) {
        ($ctype = $fields->{'content-type'}[0]) =~ m%^\s*([\w\-\./]+)%;
        $ctype = lc ($1 || 'text/plain');
    } else {
        $ctype = 'text/plain';
    }

    ## Insure uniqueness of index
    my $t = $index;
    $index .= $X . sprintf('%d',(defined($msgnum)?$msgnum:($LastMsgNum+1)));

    ## Set fields.  Note how values are NOT arrays.
    $fields->{'x-mha-index'} = $index;
    $fields->{'x-mha-message-id'} = $MsgId;
    $fields->{'x-mha-from'} = $from;
    $fields->{'x-mha-subject'} = $sub;
    $fields->{'x-mha-content-type'} = $ctype;

    ## Invoke callback if defined
    if (defined($CBMessageHeadRead) && defined(&$CBMessageHeadRead)) {
        return undef  unless &$CBMessageHeadRead($fields, $header);
    }

    $Time{$index} = $t;
    $From{$index} = $from;
    $FromName{$index} = extract_email_name($from)  if $DoFromName;
    $FromAddr{$index} = extract_email_address($from)  if $DoFromAddr;
    $Date{$index} = $date;
    $Subject{$index} = $sub;
    our $MsgHead = htmlize_header($fields, $fieldNames);
    $ContentType{$index} = $ctype;
    if ($MsgId) {
        $MsgId{$MsgId} = $index;
        $NewMsgId{$MsgId} = $index;     # Track new message-ids
    }
    if (defined($msgnum)) {
        $IndexNum{$index} = $msgnum;
        ++$NumOfMsgs; # Counteract decrement by delmsg
    } else {
        $IndexNum{$index} = getNewMsgNum();
    }

    $Refs{$index} = [ @refs ]  if (@refs);

    ## Grab any extra fields to store
    foreach $field (@ExtraHFields) {
        next  unless $fields->{$field};
        if (!defined($tmp = $ExtraHFields{$index})) {
            $tmp = $ExtraHFields{$index} = { };
        }
        if ($HFieldsAddr{$field}) {
            $tmp->{$field} = join(', ', @{$fields->{$field}});
        } else {
            $tmp->{$field} = join(' ', @{$fields->{$field}});
        }
    }

    ($index, $fields, $msg_body);
}
###############################################################################

sub _read_file_header {
    my $msg = shift;

    my ($label, $header, $msg_body, $is_header_over) = ('', '', '', 0);
    my $fields = {};
    my $fieldNames = {};
    my ($value, $tmp);
    foreach $tmp (split /\n/, $msg) {
        $is_header_over = 1 if $tmp =~ /^[\r]?$/;
        if ($is_header_over) { $msg_body .= $tmp."\n"; next }
        $header .= $tmp;
        ## Delete eol characters
        $tmp =~ s/[\r\n]//g;
        ## Check for continuation of a field
        if ($tmp =~ /^\s/) {
            $fields->{$label}[-1] .= $tmp if $label;
            next
        }
        ## Separate head from field text
        if ($tmp =~ /^([^:\s]+):\s*([\s\S]*)$/) {
            $fieldNames->{lc($1)} = $1;
            ($label, $value) = (lc($1), $2);
            if (defined($fields->{$label})) {
                push(@{$fields->{$label}}, $value);
            } else {
                $fields->{$label} = [ $value ];
            }
        }
    }
    ReadMail::decode_1522_fields($fields);
    ($fields, $header, $msg_body, $fieldNames);
}
###############################################################################

sub read_message_body {
    my ($msg_body, $index, $fields) = @_;
    my ($ret) = ('', '');
    my (@files);
    local($_);
    #write2log("Message_Body: '$msg_body'.\n");
    ## Define "globals" for use by filters
    $MHAmsgnum = &fmt_msgnum($IndexNum{$index});

    ## Filter data
    ($ret, @files) = ReadMail::MAILread_body($fields, \$msg_body);

    $ret = ''     unless defined $ret;
    @files = ( )  unless @files;
    #$Message{$index} = $ret;
    if (!defined($ret) || $ret eq '') {
        warn qq/\nWarning: read_message_body: Empty body data generated:\n/,
             qq/         Message-Id: $MsgId\n/,
             qq/         Message Subject: /, $fields->{'x-mha-subject'}, qq/\n/,
             qq/         Content-Type: /, ($fields->{'content-type'}[0] || 'text/plain'), qq/\n/;
        $ret = '';
    }

    if (@files) {
        $Derived{$index} = [ @files ];
    }
    $ret;
}
###############################################################################

1;
