#!/usr/bin/perl
## -*- Encoding:utf-8; Mode:perl; -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#

package SO::Mail::Message::Char::JP;

sub jp_2022_to_euc {
    # implementation of this function plagerized from Encode::JP::JIS7.
    my $data_in = shift;
    my $data_r  = ref($data_in) ? $data_in : \$data_in;

    my ($esc_0212, $esc_asc, $esc_kana, $chunk);
    $$data_r =~ s{(?:(\e\$\(D)|			  # JIS 0212
		     (?:\e\$\@|\e\$B|\e&\@\e\$B)| # JIS 0208
		     (\e\([BJ])|		  # ISO ASC
		     (\e\(I))			  # JIS KANA
		     ([^\e]*)}
    {
	($esc_0212, $esc_asc, $esc_kana, $chunk) =
	    ($1, $2, $3, $4);
	if (!$esc_asc) {
	    $chunk =~ tr/\x21-\x7e/\xa1-\xfe/;
	    if ($esc_kana) {
		$chunk =~ s/([\xa1-\xdf])/\x8e$1/og;
	    } elsif ($esc_0212) {
		$chunk =~ s/([\xa1-\xfe][\xa1-\xfe])/\x8f$1/og;
	    }
	}
	$chunk;
    }gex;
}

1;
