#!/usr/bin/perl
## -*- Encoding:utf-8; Mode:perl; -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#

package SO::Mail::Message::Encode;

use strict;

BEGIN {
    # If the Encode module is available, we use it, otherwise, we try to use Unicode::MapUTF8.
    eval {
	require Encode;
    };
    if (!$@) {
	*from_to  = \&_encode_from_to;
    } else {
	require Unicode::MapUTF8;
	*from_to  = \&_unimap_from_to;
    }
}

sub _encode_from_to {
    my $text_r   = shift;
    my $from_enc = lc shift;
    my $to_enc   = lc shift;

    return ''  if $$text_r eq '';

    # Strip utf8 string flag if set
    if (Encode::is_utf8($$text_r)) {
	$$text_r = Encode::encode('utf8', $$text_r);
    }
    my $is_error = 0;
    eval {
	if (!defined(Encode::from_to($$text_r, $from_enc, $to_enc))) {
	    warn qq/Warning: SO::Mail::Message::Encode: Unable to convert /,
			  qq/"$from_enc" to "$to_enc"\n/;
	    $is_error = 1;
	}
    };
    if ($@) {
	warn qq/Warning: $@\n/;
	$is_error = 1;
    }
    $is_error ? undef : $to_enc;
}


sub _unimap_from_to {
    my $text_r   = shift;
    my $from_enc = lc shift;
    my $to_enc   = lc shift;

    if (!Unicode::MapUTF8::utf8_supported_charset($from_enc)) {
	warn qq/Warning: SO::Mail::Message::Encode "$from_enc" not supported\n/;
	return undef;
    }
    if (!Unicode::MapUTF8::utf8_supported_charset($to_enc)) {
	warn qq/Warning: SO::Mail::Message::Encode "$to_enc" not supported\n/;
	return undef;
    }
    $$text_r = Unicode::MapUTF8::to_utf8({-string => $$text_r, -charset => $from_enc});
    $$text_r = Unicode::MapUTF8::from_utf8({-string => $$text_r, -charset => $to_enc});
    $to_enc;
}

1;
__END__
