#!/usr/bin/perl
## -*- Encoding:utf-8; Mode:perl; -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#

package SO::Mail::Message::UTF8;

use strict;
use SO::Mail::Message::CharMaps;

BEGIN {
    eval {
	require SO::Mail::Message::UTF8::Encode;
    };
    if (!$@) {
	# Encode module available
	*entify    = \&_entify;
	*clip      = \&SO::Mail::Message::UTF8::Encode::clip;
	*to_utf8   = \&SO::Mail::Message::UTF8::Encode::to_utf8;
	*str2sgml  = \&SO::Mail::Message::UTF8::Encode::str2sgml;
    } else {
	eval {
	    require SO::Mail::Message::UTF8::MapUTF8;
	};
	if (!$@) {
	    # Unicode::MapUTF8 module available
	    *entify    = \&_entify;
	    *clip      = \&SO::Mail::Message::UTF8::MapUTF8::clip;
	    *to_utf8   = \&SO::Mail::Message::UTF8::MapUTF8::to_utf8;
	    *str2sgml  = \&SO::Mail::Message::UTF8::MapUTF8::str2sgml;
	} else {
	    # Fallback to homegrown implementation
	    require SO::Mail::Message::UTF8::MhaEncode;
	    *entify    = \&_entify;
	    *clip      = \&SO::Mail::Message::UTF8::MhaEncode::clip;
	    *to_utf8   = \&SO::Mail::Message::UTF8::MhaEncode::to_utf8;
	    *str2sgml  = \&SO::Mail::Message::UTF8::MhaEncode::str2sgml;
	}
    }
}

##---------------------------------------------------------------------------##

sub _entify {
    my $text	= shift;
    my $text_r  = ref($text) ? $text : \$text;
    $$text_r =~ s/([$HTMLSpecials])/$HTMLSpecials{$1}/go;
    $$text_r;
}

##---------------------------------------------------------------------------##
1;
__END__
