<!-- ================================================================== -->
<!--  kate: space-indent on; indent-width 4; replace-tabs on;

      Description:
	SO::Mail::Message resource file to encode message text data 
	into Unicode UTF-8.

      Notes:
	* This is a more general version of utf-8.mrc.	Where
	  utf-8.mrc basis its conversion via CHARSETCONVERTERS,
	  this does it via TEXTENCODE.

	  The advantage of TEXTENCODE, is that message text data,
	  including headers, are converted to UTF-8 when read.	This
	  provides a performance advantage over the CHARSETCONVERTERS
	  method, and TEXTENCODE affects all text entities in a
	  message bodies.  The CHARSETCONVERTERS method depends on
	  individual text-based MIMEFILTERS to explicitly support
	  CHARSETCONVERTERS.  TEXTENCODE is transparent to MIMEFILTERS.

  -->
<!-- ================================================================== -->

<!--<TextEncode>
utf-8; SO::Mail::Message::UTF8::to_utf8; Message/UTF8.pm
</TextEncode>-->

<-- With data translated to UTF-8, it simplifies CHARSETCONVERTERS -->
<CharsetConverters override>
<!--default; SO::Mail::Message::htmlize-->
plain;              SO::Mail::Message::htmlize;
us-ascii;           SO::Mail::Message::htmlize;
iso-8859-1;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-2;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-3;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-4;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-5;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-6;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-7;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-8;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-9;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-10;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-11;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-13;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-14;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-15;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-8859-16;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-2022-jp;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
iso-2022-kr;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
euc-jp;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
utf-8;              SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp866;              SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp936;              SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp949;              SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp950;              SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp1250;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp1251;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp1252;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp1253;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp1254;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp1255;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp1256;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp1257;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
cp1258;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
koi-0;              SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
koi-7;              SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
koi8-a;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
koi8-b;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
koi8-e;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
koi8-f;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
koi8-r;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
koi8-u;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
gost-19768-87;      SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
viscii;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
big5-eten;          SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
big5-hkscs;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
gb2312;             SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
macarabic;          SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
maccentraleurroman; SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
maccroatian;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
maccyrillic;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
macgreek;           SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
machebrew;          SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
macicelandic;       SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
macromanian;        SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
macroman;           SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
macthai;            SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
macturkish;         SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
hp-roman8;          SO::Mail::Message::CharEnt::str2sgml;     Message/CharEnt.pm
default;            -ignore-
</CharsetConverters>

<-- Need to also register UTF-8-aware text clipping function -->
<!--<TextClipFunc>
SO::Mail::Message::UTF8::clip; Message/UTF8.pm
</TextClipFunc>-->

<MsgPgBegin>
<div style="background-color: #008000;border: 1px solid"><h4>$SUBJECTNA$</h4></div>
</MsgPgBegin>

<SubjectHeader>
<div style="background-color: #8DBF8D;border: 1px solid; vertical-align: text-top;text-align: center;"><h4>$SUBJECTNA$</h4></div>
</SubjectHeader>

<FieldsBeg>
<table style="background-color: #C0FFFF;border: 1px solid" width=100%>
<tbody>
</FieldsBeg>
<LabelBeg>
<tr>
<td align="right" valign="top" style="white-space: nowrap;"><b>
</LabelBeg>
<LabelEnd>
:</b></td>
</LabelEnd>
<FldBeg>
<td align="left">
</FldBeg>
<FldEnd>
</td>
</tr>
</FldEnd>
<FieldsEnd>
</tbody>
</table>
<hr>
</FieldsEnd>

<HeadBodySep>

</HeadBodySep>

<!--    Specify icons for media-types
  -->
<Icons>
*/*;[20x22]/images/icons/file_generic.gif
application/*;[20x22]/images/icons/file_generic.gif
application/msword;[32x32]/images/icons/file_doc.png
application/x-msword;[32x32]/images/icons/file_doc.png
application/vnd.openxmlformats-officedocument.wordprocessingml.document;[32x32]/images/icons/file_docx.png
application/rtf;[32x32]/images/icons/file_rtf.png
application/xls;[32x32]/images/icons/file_xls.png
application/x-xls;[32x32]/images/icons/file_xls.png
application/x-excel;[32x32]/images/icons/file_xls.png
application/msexcel;[32x32]/images/icons/file_xls.png
application/x-msexcel;[32x32]/images/icons/file_xls.png
application/x-ms-excel;[32x32]/images/icons/file_xls.png
application/x-dos_ms_excel;[32x32]/images/icons/file_xls.png
application/vnd.ms-excel;[32x32]/images/icons/file_xls.png
application/vnd.openxmlformats-offedocument.spreadsheetml.sheet;[32x32]/images/icons/file_xlsx.png
application/vnd.ms-powerpoint;[32x32]/images/icons/file_ppt.png
application/vnd.openxmlformats-officedocument.presentationml.presentation;[32x32]/images/icons/file_pptx.png
application/vnd.oasis.opendocument.text;[32x32]/images/icons/file_odt.png
application/vnd.oasis.opendocument.text-template;[32x32]/images/icons/file_ott.png
application/vnd.oasis.opendocument.text.spreadsheet;[32x32]/images/icons/file_ods.png
application/vnd.oasis.opendocument.text.spreadsheet-template;[32x32]/images/icons/file_ots.png
application/vnd.oasis.opendocument.text.presentation;[32x32]/images/icons/file_odp.png
application/vnd.oasis.opendocument.text.presentation-template;[32x32]/images/icons/file_otp.png
application/vnd.oasis.opendocument.text.graphics;[32x32]/images/icons/file_odg.png
application/vnd.oasis.opendocument.text.graphics-template;[32x32]/images/icons/file_otg.png
application/vnd.oasis.opendocument.text.chart;[32x32]/images/icons/file_odc.png
application/vnd.oasis.opendocument.text.chart-template;[32x32]/images/icons/file_otc.png
application/vnd.oasis.opendocument.text.image;[32x32]/images/icons/file_odi.png
application/vnd.oasis.opendocument.text.image-template;[32x32]/images/icons/file_oti.png
application/vnd.oasis.opendocument.text.formula;[32x32]/images/icons/file_odf.png
application/vnd.oasis.opendocument.text.formula-template;[32x32]/images/icons/file_otf.png
application/vnd.oasis.opendocument.text.text-master;[32x32]/images/icons/file_odm.png
application/vnd.oasis.opendocument.text.text-web;[32x32]/images/icons/file_oth.png
application/x-shockwave-flash;[32x32]/images/icons/file_adobe_flash.png
application/octet-stream;[20x22]/images/icons/file_binary.gif
application/pdf;[32x32]/images/icons/file_pdf.png
application/postscript;[32x32]/images/icons/file_ps.png
application/x-csh;[20x22]/images/icons/file_script.gif
application/x-dvi;[20x22]/images/icons/file_dvi.gif
application/x-gtar;[20x22]/images/icons/file_tar.gif
application/x-gzip;[20x22]/images/icons/file_compressed.gif
application/x-ksh;[20x22]/images/icons/file_script.gif
application/x-latex;[20x22]/images/icons/file_tex.gif
application/x-patch;[20x22]/images/icons/file_patch.gif
application/x-rar;[32x32]/images/icons/file_rar.png
application/x-rar-compressed;[32x32]/images/icons/file_rar.png
application/x-script;[20x22]/images/icons/file_script.gif
application/x-sh;[20x22]/images/icons/file_script.gif
application/x-tar;[20x22]/images/icons/file_tar.gif
application/x-tex;[20x22]/images/icons/file_tex.gif
application/x-zip-compressed;[32x32]/images/icons/file_zip.png
application/zip;[32x32]/images/icons/file_zip.png
application/x-javascript;[20x22]/images/icons/file_script.gif
application/x-bittorrent;[32x32]/images/icons/file_torrent.png
application/x-pkcs12;[32x32]/images/icons/file_pkcs.png
application/x-pkcs7-certificates;[32x32]/images/icons/file_pkcs.png
application/x-pkcs7-certreqresp;[32x32]/images/icons/file_pkcs.png
application/x-pkcs7-mime;[32x32]/images/icons/file_pkcs.png
application/x-pkcs7-signature;[32x32]/images/icons/file_pkcs.png
audio/x-aiff;[32x32]/images/icons/file_aiff.png
audio/aiff;[32x32]/images/icons/file_aiff.png
audio/mpeg;[32x32]/images/icons/file_mp3.png
audio/mp4;[32x32]/images/icons/file_mp3.png
audio/x-ms-wma;[32x32]/images/icons/file_wma.png
audio/x-wav;[32x32]/images/icons/file_wav.png
audio/vnd.wave;[32x32]/images/icons/file_wav.png
audio/ogg;[32x32]/images/icons/file_ogg.png
audio/ac3;[32x32]/images/icons/file_ac3.png
audio/aac;[32x32]/images/icons/file_aac.png
audio/*;[20x22]/images/icons/file_sound.gif
chemical/*;[20x22]/images/icons/file_sphere.gif
image/gif;[32x32]/images/icons/file_gif.png
image/jpeg;[32x32]/images/icons/file_jpg.png
image/pjpeg;[32x32]/images/icons/file_jpg.png
image/jpe;[32x32]/images/icons/file_jpg.png
image/jpg;[32x32]/images/icons/file_jpg.png
image/tiff;[32x32]/images/icons/file_tiff.png
image/png;[32x32]/images/icons/file_png.png
image/psd;[32x32]/images/icons/file_psd.png
image/bmp;[32x32]/images/icons/file_bmp.png
image/svg+xml;[32x32]/images/icons/file_svg.png
image/vnd.microsoft.icon;[32x32]/images/icons/file_ico.png
image/*;[20x22]/images/icons/file_image.gif
message/external-body;[20x22]/images/icons/file_link.gif
multipart/*;[20x22]/images/icons/layout.gif
text/*;[20x22]/images/icons/file_text.gif
video/mpeg;[32x32]/images/icons/file_mpg.png
video/x-msvideo;[32x32]/images/icons/file_avi.png
video/quicktime;[32x32]/images/icons/file_mov.png
video/mp4;[32x32]/images/icons/file_mp4.png
video/x-ms-wmv;[32x32]/images/icons/file_wmv.png
video/x-flv;[32x32]/images/icons/file_flv.png
video/x-matroska;[32x32]/images/icons/file_mkv.png
video/*;[32x32]/images/icons/file_movie.png
</Icons>

<MIMEArgs override>
<!-- Override MIMEArgs settings to specify external filter to use icons as part of the link to attachments. -->
m2h_external::filter; useicon inline
m2h_text_html::filter; external_urls_warning
</MIMEArgs>