#!/usr/bin/perl -w
# -*- Encoding: utf-8; Mode: cperl -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
use strict;
use CGI;
use CGI::Carp 'fatalsToBrowser';
use POSIX qw(strftime);
use Time::Local qw(timelocal);
use Net::HTTP;
use IDNA::Punycode qw(decode_punycode);
use SO::RedisDatabase;
use SO::MongoCollection;
use SO::IniFile qw(loadIni);
use SO::LogFile;

my ($iniFilePath, $uri) = ('WORKING_DIR/bounces/so-bounces-web.ini', $ENV{'REQUEST_URI'}); $uri =~ s|[^/]+$||;
my %ini = (
    'errorsLogFile'  => 'WORKING_DIR/logs/so-bounces-web.log',
    'db_cluster'     => 'so_db',
    'db_name'        => 'bounces',
    'db_hosts'       => 'db1h.so.yandex.net db1m.so.yandex.net db1j.so.yandex.net',
    'db_user'        => 'bounces',
    'db_passwd'      => 'bounces'
);
my $redis = SO::RedisDatabase->new($iniFilePath);
$redis->isValidConnection() || die "There are problems with Radis DB servers on hosts: ".($$redis{'hosts'} || $$redis{'host'});
$redis->role() eq 'slave' or writeLog("Redis DB on host $$redis{'host'} is not a slave");

my ($iniFile, $url) = (SO::IniFile->new($iniFilePath), 'http'.($ENV{'HTTPS'} ? 's' : '').'://'.$ENV{'HTTP_HOST'});
$iniFile->loadIni(\%ini);
$SO::LogFile::defaultLogFile = $ini{'errorsLogFile'};
$SO::MongoDatabase::defaultIniFile = $iniFilePath;

my ($q, $k, $show) = CGI->new();
my %db = (
    'bounces'          => SO::MongoCollection->new('bounces', 'bounces'),
    'senders'          => SO::MongoCollection->new('bounces_senders', 'bounces'),
    'recipients'       => SO::MongoCollection->new('bounces_recipients', 'bounces'),
    'senderDomains'    => SO::MongoCollection->new('senders_domains', 'bounces'),
    'recipientDomains' => SO::MongoCollection->new('recipients_domains', 'bounces')
);
my @dates = (
    [strftime("%Y%m%d", localtime(time)), 'сегодня'],
    [strftime("%Y%m%d", localtime(time - 86400)), 'вчера'],
    [strftime("%Y%m%d", localtime(time - 172800)), 'позавчера']
);
my %params = (
    'senders' => ['Отправители', 'отправителей', 'отправителям'],
    'recipients' => ['Получатели', 'получателей', 'получателям']
);
my %bounce_type = (
    'unknown' => 1,
    'spam'    => 2,
    'nwsmtp'  => 3
);
my @RoleRecipients = ('info@', 'pr@');
my @RoleRecipientsRE = ();
my @OurDomains = qw(ru ua by kz su ukr.net bigmir.net miracle-world.net pisem.net udm.net ukrtel.net tula.net gala.net skif.net ukrpost.net uch.net krost.net penza.net webtv.net nvkz.net yandex.net president-hotel.net romb.net himmash.net workle.net comint.net tula.net farlep.net chus18.net sivash.net cris.net paco.net kaluga.net lanck.net makeevka.net loigmir.net uptel.net glazov.net feosky.net probelov.net radion.net mlvz.net kuzbass.net lokos.net saturn.net yandex.net ukrpack.net tupoleva.net
    mineralov.net mksat.net originalam.net avtoset.net tentorium.net kyivstar.net donapex.net avtoimperia.net kostroma.net lanck.net iqtour.net gldn.net ruscomp.net uaprom.net kuzbass.net telros.net dnepr.net shadrinsk.net ostrov.net ua.fm avto-expert.pro rus-china.travel darom.org change.org udobno.biz softkey.biz magelan.pro unistyle.info restra.org orgsintez.info lostfilm.tv serov.info sozvezdie.biz labirint.travel ecorussia.info business-investor.info designproject.biz inksystem.biz vin-code.org
    bserv.org aksioma.info netlux.org oplata.info defo.biz truerussia.org masshtab.bz magnitka.info nnov.org kommersant.fm origitea.info svetoresurs.org rustrans.org lazurit.info fastmail.fm tonar.info rupr.org mashtab.org vyborg.org vodocanal.org moscvett.org msu.edu vostoktrans.org finam.fm w3.org akadem.org);
my @OurDomainsRE = ();
my $host = $q->param('host') || '';
my $sortby = $q->param('sortby') || 'total:total';
my ($period, $page_count) = ($q->param('period') || 1, $q->param('page_count') || $ini{'defaultPageCnt'} || 100);
my ($keys_re, $keys_re_excl, $isregexp, $isnotregexp) = ($q->param('keys_re') || '', $q->param('keys_re_excl') || '', $q->param('isregexp') || '', $q->param('isnotregexp') || '');
my ($days_period, $days) = ($q->param('days_period') || '', 0);
my ($dom_type, $stats_type) = ($q->param('dom_type') || 'recipients', $q->param('stats_type') || 'senders');
my ($bd1_start, $bd1_end) = ($q->param('bd11') || '', $q->param('bd12') || '');
my ($bd2_start, $bd2_end) = ($q->param('bd21') || '', $q->param('bd22') || '');
my @fields = (['total', 'всего']);
my ($key, $dom_prefx) = ($dom_type eq 'recipients' ? 'senders' : 'recipients', $dom_type eq 'recipients' ? 'recdomains' : 'sendomains');
if ($period > 1 && $period < 6 || $period == 99 && $days_period + 0 > 0) {
    push(@fields, ['period', 'период']);
    $days = $period == 2 ? 6 : $period == 3 ? 30 : $period == 4 ? 90 : $period == 5 ? 180 : ($q->param('days_period') - 1)
} elsif ($sortby =~ /period/) { $sortby = 'total:total' }
$k = quotemeta($_), push(@RoleRecipientsRE, qr/\b$k\b/i) foreach (@RoleRecipients);
$k = quotemeta($_), push(@OurDomainsRE, qr/\b$k$/i) foreach (@OurDomains);
$show->{'show_'.$$_[0]} = scalar(keys %{$q->Vars}) ? $q->param('show_day'.$$_[0]) : 'on' foreach (@dates);
$show->{'show_'.$_} = scalar(keys %{$q->Vars}) ? $q->param('show_'.$_) : 'on' foreach (keys %bounce_type);

print $q->header(-type => 'text/html', -charset => 'utf-8');
print $q->start_html(-title => 'Bounces top', -lang => 'ru-RU', -script => [{-type => 'text/javascript', -src => '/js/jquery/jquery.js'},
    {-type => 'text/javascript', -src => '/js/jquery/jquery-ui.js'}, {-type => 'text/javascript', -src => '/js/jquery/ui/minified/i18n/jquery.ui.datepicker-ru.min.js'},
    {-type => 'text/javascript', -code=> <<EOS}],
    function onLoadForm() {
        ChangeSortOrder();
        document.getElementById('wait_message').hidden = true;
        var period = document.getElementById('period');
        var custom_period = document.getElementById('custom_period');
        if (custom_period)
            custom_period.style.display = (period && period.value == 99) ? 'inline' : 'none';
        var sortorder = document.getElementById('sortby');
        if (sortorder && period && period.value < 2 && sortorder.value.indexOf('period') > -1) {
            sortorder.value = 'total:total'; ChangeSortOrder();
        }
        loadDatePickers();
    }
    function ChangeSortOrder(object) {
        if(object) document.getElementById('sortby').value = object.id;
        var sortorder = document.getElementById('sortby');
        var table1 = document.getElementById('table1');
        if (sortorder && table1) {
            var heads = table1.getElementsByTagName('a');
            for (var i = 0; i < heads.length; i++) {
                if (heads[i].className == 'headsort')
                    heads[i].style.color = sortorder.value == heads[i].id ? 'blue' : 'black';
            }
        }
        if(object) document.getElementById('searchform').submit();
    }
    function ChangePeriod() {
        var period = document.getElementById('period');
        var custom_period = document.getElementById('custom_period');
        if (custom_period)
            custom_period.style.display = (period && period.value == 99) ? 'inline' : 'none';
        if (period && period.value != 99)
            searchform.submit();
    }
    function onInputHostsRE(r) {
        var isregexp = document.getElementById('isregexp');
        if (isregexp) {
            isregexp.value = r ? (r.toString().match(/[^A-Z0-9_]/) ? '(задано регулярное выражение для имени домена)' : '') :
                                '(пожалуйста, задайте непустое имя домена или регулярное выражение)';
            isregexp.innerHTML = isregexp.value;
        }
    }
    function onChangePageCount(obj) {
        if(obj)
            searchform.page_count.value = obj.value;
        searchform.submit();
    }
    function loadDatePickers() {
        \$.datepicker.setDefaults({showOn: "both", buttonImageOnly: true, buttonImage: "/images/Calendar_16.png", buttonText: "Календарь", numberOfMonths: 3,
            showButtonPanel: true, minDate: new Date(2013, 12, 31), maxDate: new Date()});
        \$("#bd1_start").datepicker({}); \$("#bd1_start").val(document.getElementById('bd11').value);
        \$("#bd1_end").datepicker({});   \$("#bd1_end").val(document.getElementById('bd12').value);
        \$("#bd2_start").datepicker({}); \$("#bd2_start").val(document.getElementById('bd21').value);
        \$("#bd2_end").datepicker({});   \$("#bd2_end").val(document.getElementById('bd22').value);
    }
    function VerifyParams() {
        var bd1_start_obj = \$("#bd1_start");
        var bd1_end_obj = \$("#bd1_end");
        var bd2_start_obj = \$("#bd2_start");
        var bd2_end_obj = \$("#bd2_end");
        document.getElementById('bd11').value = bd1_start_obj.val();
        document.getElementById('bd12').value = bd1_end_obj.val();
        document.getElementById('bd21').value = bd2_start_obj.val();
        document.getElementById('bd22').value = bd2_end_obj.val();
        var bd1_start = \$("#bd1_start").datepicker('getDate');
        var bd1_end = \$("#bd1_end").datepicker('getDate');
        var bd2_start = \$("#bd2_start").datepicker('getDate');
        var bd2_end = \$("#bd2_end").datepicker('getDate');
        if (bd1_start && bd1_end && bd1_start > bd1_end) {
            alert('Нижняя граница начала регистрации баунсов не может быть позднее его верхней границы!');
            \$("#bd1_end").datepicker('setDate', null);   document.getElementById('bd12').value = '';
            return false;
        }
        if (bd2_start && bd2_end && bd2_start > bd2_end) {
            alert('Нижняя граница конца регистрации баунсов не может быть позднее его верхней границы!');
            \$("#bd2_end").datepicker('setDate', null);   document.getElementById('bd22').value = '';
            return false;
        }
        return true;
    }
EOS
    -style => [{-verbatim => <<EOS}, {-src => '/js/jquery/themes/base/minified/jquery-ui.min.css'}], -onLoad => 'onLoadForm();', -head => '<link rel="shortcut icon" href="/images/favicon.ico" />');
        .headsort {
            cursor: pointer;
        }
        fieldset {
            border: 2px #aaaaaa solid;
            border-radius: 10px;
        }
EOS
print $q->start_form(-method => 'GET', -id => 'searchform', -onSubmit => 'return VerifyParams()');
print $q->hidden(-name => 'dom_type', -id => 'dom_type', -default => $dom_type);
print $q->hidden(-name => 'stats_type', -id => 'stats_type', -default => $stats_type);
print $q->hidden(-name => 'sortby', -id => 'sortby', -default => $sortby);
print $q->hidden(-name => 'host', -id => 'host', -default => $host) if $host;
print $q->hidden(-name => 'bd11', -id => 'bd11', -default => $bd1_start);
print $q->hidden(-name => 'bd12', -id => 'bd12', -default => $bd1_end);
print $q->hidden(-name => 'bd21', -id => 'bd21', -default => $bd2_start);
print $q->hidden(-name => 'bd22', -id => 'bd22', -default => $bd2_end);
print '<table width=100%><tr><td style="width: 20em;vertical-align: top;"><a href="'.$url.'/internal/"><img width=90 height=90 src="/images/sign_so.gif"><img src="/images/logo.gif"></a></td>';
print '<td rowspan=2>&nbsp;<h3 style="white-space: nowrap;">&nbsp;Статистика баунсов ';
if ($host) {
    print 'для '.(is_foreign($host) ? 'зарубежного ' : '').'домена '.$params{$dom_type}->[1].'&nbsp;&nbsp;';
    print '<a href="http://whois.net/whois/'.CGI::escapeHTML($host).'" target="_blank">'.($host =~ /xn--/ ? convFromPunycode($host).' ('.$host.')' : $host).'</a>';
} else { print 'по доменам '.$params{$dom_type}->[1] }
print '</h3>', $q->br, '<table cellpadding="2" border="0" id="tablepars" style="width: 50em;"><tr><td>';
print '<b>Параметры статистики:</b>&nbsp;</td><td>';
print '&nbsp;Статистика за&nbsp;'.$q->popup_menu(-name => 'period', -id => 'period', -values => ['1', '2', '3', '4', '5', '99'], -default => '1',
    -labels => {'1' => 'всё время', '2' => 'последнюю неделю', '3' => 'последний месяц', '4' => 'последние 3 месяца', '5' => 'последние 6 месяцев', '99' => 'период'}, -onChange => 'ChangePeriod()');
print '<div id="custom_period" style="display: none"> последних '.$q->textfield(-name => 'days_period', -id => 'days_period', -value => $days_period, -size => 5, -maxlength => 5);
print ' дней</div></td></tr><tr><td></td><td>&nbsp;Фильтр для имени:&nbsp;';
print $q->textfield(-name => 'keys_re', -id => 'keys_re', -rows => 1, -cols => 80, -value => $keys_re), "<span id='isregexp'>$isregexp</span>", '</td></tr>';
print '<tr><td></td><td>&nbsp;Исключающий фильтр для имени:&nbsp;';
print $q->textfield(-name => 'keys_re_excl', -id => 'keys_re_excl', -rows => 1, -cols => 80, -value => $keys_re_excl), "<span id='isnotregexp'>$isnotregexp</span>", '</td></tr>';
if ($host and $stats_type eq 'senders') {
    print '<tr style="vertical-align: middle;"><td align="right">Дата первого баунса:</td><td><label style="margin:2px;">от </label>',
        $q->textfield(-name => 'bd1_start', -id => 'bd1_start', -value => $bd1_start, -style => 'margin:2px;width:100px');
    print '<label style="margin:2px;">&nbsp;&nbsp;&nbsp;до&nbsp;</label>',
        $q->textfield(-name => 'bd1_end', -id => 'bd1_end', -value => $bd1_end, -style => 'margin:2px;width:100px'), '</td></tr>';
    print '<tr style="vertical-align: middle;"><td align="right">Дата последнего баунса:</td><td><label style="margin:2px;">от </label>',
        $q->textfield(-name => 'bd2_start', -id => 'bd2_start', -value => $bd2_start, -style => 'margin:2px;width:100px');
    print '<label style="margin:2px;">&nbsp;&nbsp;&nbsp;до&nbsp;</label>',
        $q->textfield(-name => 'bd2_end', -id => 'bd2_end', -value => $bd2_end, -style => 'margin:2px;width:100px'), '</td></tr>';
}
print '<tr><td></td><td>', $q->submit(-name => 'do', -value => 'Применить', -id => 'searchbutton'), '</td></tr></table></td>';
print '<tr><td><br /><fieldset><legend style="white-space: nowrap;"><b>Перейти к стастистике баунсов</b></legend><ul>';
print '<li>&nbsp;<a href="'.$url.$uri.'bouncetop.pl'.(($host and $dom_type eq 'senders') ? '?keys_re=@'.$host : '?').join('', map {'&show_day'.$$_[0].'='.$show->{'show_'.$$_[0]}} @dates).
    join('', map {'&show_'.$_.'='.$show->{'show_'.$_}} keys %bounce_type).'" style="white-space: nowrap;">по отправителям</a>&nbsp;</li>', $q->br;
print '<li>&nbsp;<a href="'.$url.$uri.'rcptop.pl?dom_type='.$dom_type.join('', map {'&show_day'.$$_[0].'='.$show->{'show_'.$$_[0]}} @dates).
    join('', map {'&show_'.$_.'='.$show->{'show_'.$_}} keys %bounce_type).'" style="white-space: nowrap;">по доменам '.$params{$dom_type}->[1].'</a>&nbsp;</li>', $q->br if $host;
print '<li>&nbsp;<a href="'.$url.$uri.'rcptop.pl?dom_type='.$key.join('', map {'&show_day'.$$_[0].'='.$show->{'show_'.$$_[0]}} @dates).
    join('', map {'&show_'.$_.'='.$show->{'show_'.$_}} keys %bounce_type).'" style="white-space: nowrap;">по доменам '.$params{$key}->[1].'</a>&nbsp;</li>';
print '</ul></fieldset></td></tr></table></tr></table>';
print '<div id="wait_message" align="center" style="margin: 2em;"> Подождите, идут вычисления... </div>';
if ($host) {
    print '<table cellpadding="4"><tr><td></td>';
    print '<td align="center"><b>'.$$_[1].'</b></td>' foreach (@fields, @dates);
    print '<td align="center"><b>'.$_.'</b></td>' foreach (keys %bounce_type);
    print '<td align="center"><b>зарубежные</b></td>' if $dom_type eq 'senders';
    print '</tr><tr><td>Количество неуникальных получателей баунсов:</td>';
    print '<td align="center">'.(($$_[0] eq 'period') ? get_total4period($host, $dom_prefx.':total:') : ($redis->zscore($dom_prefx.':total:'.$$_[0], $host) + 0)).'</td>' foreach (@fields);
    print '<td align="center">'.($redis->zscore($dom_prefx.':total:'.$$_[0], $host) + 0).'</td>' foreach (@dates);
    print '<td align="center">'.get_total4key($dom_prefx.':'.$_.':'.$host).'</td>' foreach (keys %bounce_type);
    print '<td align="center">'.($redis->zscore('sendomains:total:foreign', $host) + 0).'</td>' if $dom_type eq 'senders';
    print '</tr><tr><td>Количество уникальных получателей баунсов:</td>';
    print '<td align="center">'.(($$_[0] eq 'period') ? get_uniq4period($dom_prefx.':', ':'.$host) : ($redis->zscore($dom_prefx.':uniq:'.$$_[0], $host) + 0)).'</td>' foreach (@fields);
    print '<td align="center">'.($redis->zscore($dom_prefx.':uniq:'.$$_[0], $host) + 0).'</td>' foreach (@dates);
    print '<td align="center">'.($redis->zscore($dom_prefx.':uniq:'.$_, $host) + 0).'</td>' foreach (keys %bounce_type);
    print '<td align="center">'.($redis->zscore('sendomains:uniq:foreign', $host) + 0).'</td>' if $dom_type eq 'senders';
    print '</tr><tr><td>Количество неуникальных ролевых получателей баунсов:</td>';
    print '<td align="center">'.get_role_recipients($$_[0], 0).'</td>' foreach (@fields, @dates);
    print '<td align="center">'.get_role_recipients($_, 0).'</td>' foreach (keys %bounce_type);
    print '<td align="center">'.get_role_recipients('foreign', 0).'</td>' if $dom_type eq 'senders';
    print '</tr><tr><td>Количество уникальных ролевых получателей баунсов:</td>';
    print '<td align="center">'.get_role_recipients($$_[0], 1).'</td>' foreach (@fields, @dates);
    print '<td align="center">'.get_role_recipients($_, 1).'</td>' foreach (keys %bounce_type);
    print '<td align="center">'.get_role_recipients('foreign', 1).'</td>' if $dom_type eq 'senders';
    print '</tr></table><br /><table cellpadding="4"><tr><td>Дата первого баунса:</td><td>', get_begindate4host(), '</td></tr>';
    print '<tr><td>Дата последнего баунса:</td><td>', get_enddate4host(), '</td></tr>';
    print '<tr><td>Дата регистрации домена:</td><td>'.get_regdate_for_domain($host, 1).'</td></tr>' unless $dom_type eq 'recipients';
    print '</table>', $q->br, '<i>Статистика по:&nbsp;&nbsp;'.text_url('senders').'&nbsp;&nbsp;&nbsp;&nbsp;'.text_url('recipients').'</i>:', $q->br;
}
print '<i>&nbsp;&nbsp;Показать первые &nbsp;'.$q->popup_menu(-name => 'page_count', -id => 'page_count', -values => ['50', '100', '200', '500', '1000', '3000', '5000', '10000'],
    -default => $ini{'defaultPageCnt'}, -onChange => 'onChangePageCount(this);'), '&nbsp; записей'.($stats_type eq 'recipients' ? '' : ' из '.
    $redis->zcard($dom_prefx.':total:'.($host ? $host.':' : '').'total')).'. Показывать колонки:</i>';
print $q->checkbox(-name => 'show_day'.$$_[0], -checked => 1, -value => 'on', -label => $$_[1], -onChange => 'searchform.submit();') foreach (@dates);
print $q->checkbox(-name => 'show_'.$_, -checked => 1, -value => 'on', -label => $_, -onChange => 'searchform.submit();') foreach (keys %bounce_type);
print $q->br x 2;

my %table = ();
my @f = ();
print $q->end_form, '<table cellspacing="0" cellpadding="2" border="1" id="table1"><thead>';
print '<tr><th rowspan=2>'.($host ? $params{$stats_type}->[0] : 'Домен').'</th>';
$k = 'uniq:total:senders', print('<th rowspan=2><a class="headsort" id="'.$k.'" onClick="ChangeSortOrder(this);">'.$params{senders}->[0].'</a></th>'), push(@f, $k) unless $host;
unless ($host and $stats_type eq 'recipients') {
    my ($n, $n2) = (scalar(@fields) + scalar(@dates) + ($dom_type eq 'senders' ? 1 : 0), scalar(keys %bounce_type) - ($period > 1 ? 1 : 0));
    foreach (@dates) { $n-- unless $show->{'show_'.$$_[0]} }
    foreach (keys %bounce_type) { $n2-- unless $show->{'show_'.$_} }
    print '<th colspan='.($n + $n2).'>Уникальные'.($n + $n2 < 3 ? '<br />' : ' ').'получатели</th><th colspan='.$n.'>Не уникальные'.($n < 3 ? '<br />' : ' ').'получатели</th>';
    print ($host ? '<th colspan=2>Дата баунса</th>' : '');
    print '<th rowspan=2><a class="headsort" id="regdate" onClick="ChangeSortOrder(this);">Дата<br />регистрации</a></th>' if $host and $dom_type eq 'recipients' or $dom_type eq 'senders';
    print '</tr><tr>';
    foreach (@fields) {
        next if $$_[0] =~ /\bperiod\b/;
        $k = 'uniq:'.$$_[0];
        print '<th><a class="headsort" id="'.$k.'" onClick="ChangeSortOrder(this);">'.$$_[1].'</a></th>';
        push(@f, $k)
    }
    foreach (@dates) {
        next unless $show->{'show_'.$$_[0]};
        $k = 'uniq:'.$$_[0];
        print '<th><a class="headsort" id="'.$k.'" onClick="ChangeSortOrder(this);">'.$$_[1].'</a></th>';
        push(@f, $k)
    }
    foreach (keys %bounce_type) {
        next unless $show->{'show_'.$_};
        $k = ($stats_type eq 'senders' ? 'uniq:' : '').$_;
        print('<th><a class="headsort" id="'.$k.'" onClick="ChangeSortOrder(this);">'.$_.'</a></th>');
        push @f, $k
    }
    $k = 'uniq:foreign', print('<th><a class="headsort" id="'.$k.'" onClick="ChangeSortOrder(this);">зарубежные</a></th>'), push(@f, $k) if $dom_type eq 'senders'
}
$k = 'total:'.$$_[0], print('<th><a class="headsort" id="'.$k.'" onClick="ChangeSortOrder(this);">'.$$_[1].'</a></th>'), push(@f, $k) foreach (@fields);
foreach (@dates) {
    next unless $show->{'show_'.$$_[0]};
    $k = 'total:'.$$_[0];
    print '<th><a class="headsort" id="'.$k.'" onClick="ChangeSortOrder(this);">'.$$_[1].'</a></th>';
    push @f, $k
}
if ($host and $stats_type eq 'recipients') {
    foreach (keys %bounce_type) {
        next unless $show->{'show_'.$_};
        $k = 'total:'.$_;
        print('<th><a class="headsort" id="'.$k.'" onClick="ChangeSortOrder(this);">'.$_.'</a></th>');
        push @f, $k
    }
} else {
    $k = 'total:foreign', print('<th><a class="headsort" id="'.$k.'" onClick="ChangeSortOrder(this);">зарубежные</a></th>'), push(@f, $k) if $dom_type eq 'senders';
    if ($host) {
        print '<th><a class="headsort" id="begindate" onClick="ChangeSortOrder(this);">первого</a></th>';  push(@f, 'begindate');
        print '<th><a class="headsort" id="enddate" onClick="ChangeSortOrder(this);">последнего</a></th>'; push(@f, 'enddate')
    }
    push(@f, 'regdate') if $host or $dom_type ne 'recipients' and $stats_type ne 'recipients'
}
print '</tr></thead><tbody>';

my %sortcol = %{get_sortedcol_hash($sortby)};
foreach $key (keys %sortcol) {
    $table{$key}{$_} = $_ eq $sortby ? $sortcol{$key} : get_cell_value($key, $_) foreach (@f);
}
foreach $key (sort { $sortby =~ /date/ ? $table{$b}{$sortby} cmp $table{$a}{$sortby} : $table{$b}{$sortby} <=> $table{$a}{$sortby} } keys %table) {
    $k = $key =~ /^(.*@)([^@]*xn--.*)$/ ? $1.convFromPunycode($2) : $key =~ /xn--/ ? convFromPunycode($key) : $key;
    print '<tr><td style="white-space: nowrap;">'.($host ? ($stats_type eq 'senders' ? '<a href="'.$url.$uri.'bouncetop.pl?sender='.
        CGI::escapeHTML($key).join('', map {'&show_day'.$$_[0].'='.$show->{'show_'.$$_[0]}} @dates).join('', map {'&show_'.$_.'='.$show->{'show_'.$_}} keys %bounce_type).'" target="_blank">'.
        CGI::escapeHTML($k).'</a>' : $k) :
        '<a href="?dom_type='.$dom_type.'&host='.CGI::escapeHTML($key).join('', map {'&show_day'.$$_[0].'='.$show->{'show_'.$$_[0]}} @dates).
        join('', map {'&show_'.$_.'='.$show->{'show_'.$_}} keys %bounce_type).'" target="_blank">'.CGI::escapeHTML($k).'</a>').'</td>';
    print join('', map { '<td align="center">'.($_ or '-').'</td>' } @{$table{$key}}{@f});
    if (!$host) {
        print '<td style="border-width: 0 !important;"><a href="http://whois.net/whois/'.CGI::escapeHTML($key).'" target="_blank">whois</a></td>'
    } elsif ($stats_type eq 'senders') {
        my $suid = get_suid_by_login($key);
        if ($suid) {
            print '<td style="border-width: 0 !important;"><a href="'.$url.'/web_fgbd.pl?id=mfrm%3A'.$suid.'&do=do&filter=&ham=ON&dlv=ON&spam=ON&malic=ON&calendar=&.cgifields=spam&.cgifields=malic&.cgifields=dlv&.cgifields=ham" target="_blank">getbyid</a></td>';
            #print '<td style="border-width: 0 !important;">'.($k =~ /@(\S+)/ ? '<a href="http://whois.net/whois/'.CGI::escapeHTML($1).'" target="_blank">whois</a>' : '').'</td>';
            print '<td style="border-width: 0 !important;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>';
            print '<td style="border-width: 0 !important;">&nbsp;&nbsp;&nbsp;</td>';
        } else {
            print '<td colspan=5 style="border-width: 0 !important;">(<i>suid не определён</i>)</td>';
        }
    }
    print '</tr>'
}
print '</tbody></table>', $q->br, $q->end_html;

sub text_url {
    my $param = shift;
    $stats_type eq $param ? $params{$stats_type}->[2] : '<a href="?host='.$host.'&dom_type='.$dom_type.'&stats_type='.$param.
        join('', map {'&show_day'.$$_[0].'='.$q->param('show_day'.$$_[0])} @dates).join('', map {'&show_'.$_.'='.$q->param('show_'.$_)} keys %bounce_type).'">'.$params{$param}->[2].'</a>';
}

sub is_foreign {
    my ($domain, $r) = (shift, 1);
    foreach (@OurDomains) {
        $r = 0, last if $domain =~ /$_/i;
    }
    $r
}

sub get_uniq_members_count($$) {
    my ($type, $key) = @_;
    my $s = ($type eq 'sender') ? 'total:' : '';
    ($key eq 'period') ? get_uniq4period($s) : $redis->zcard($s.$key)
}

sub get_uniq4period {
    my ($prefx, $sufx) = @_;
    my $total = 0;
    return $total unless $days > 0;
    my $i = $days - 1; $prefx ||= ''; $sufx ||= '';
    my %all = ();
    while ($i >= 0) {
        my %a = @{$redis->zrange($prefx.strftime("%Y%m%d", localtime(time - 86400 * $i)).$sufx, 0, -1, 'WITHSCORES')};
        $all{$_} += $a{$_} + 0 foreach (keys %a); $i--
    }
    scalar keys %all
}

sub get_total4period {
    my ($key, $prefx, $sufx) = @_;
    my $total = 0;
    return $total unless $days > 0;
    my $i = $days - 1; $prefx ||= ''; $sufx ||= '';
    while ($i >= 0) {
        $total += $redis->zscore($prefx.strftime("%Y%m%d", localtime(time - 86400 * $i)).$sufx, $key) + 0; $i--
    }
    $total
}

sub get_total4key {
    my ($key, $total) = (shift, 0);
    my %h = @{$redis->zrange($key, 0, -1, 'WITHSCORES')};
    $total += $_ foreach(values %h);
    $total
}

sub get_role_recipients {
    my ($key, $is_uniq) = @_;
    my %h = @{$redis->zrange($dom_prefx.':'.($key =~ /^(\d+)/ ? $1 : $key.':').$host, 0, -1, 'WITHSCORES')};
    my $n = 0;
    if ($key =~ /^((?:uniq|total)\:)period$/) {
        return $n unless $days > 0;
        my $i = $days - 1;
        $n += get_role_recipients($1.strftime("%Y%m%d", localtime(time - 86400 * $i)), $is_uniq), $i-- while ($i >= 0)
    } else {
        foreach my $r (keys %h) {
            foreach (@RoleRecipientsRE) {
                $n += $is_uniq ? 1 : $h{$r}, last if $r =~ /$_/i
            }
        }
    }
    $n
}

sub get_begindate4host {
    my @senders = @{$redis->zrange($dom_prefx.':total:'.$host.':total', 0, -1)};
    my ($min_timestamp, $t) = (time, time);
    foreach (@senders) {
        $t = $redis->zscore('begindate', $_); $min_timestamp = $t if $min_timestamp > $t;
        last if $min_timestamp == 0
    }
    strftime("%Y.%m.%d %H:%M:%S", localtime($min_timestamp))
}
sub get_enddate4host {
    my @senders = @{$redis->zrange($dom_prefx.':total:'.$host.':total', 0, -1)};
    my ($max_timestamp, $t, $d) = (0, 0, strftime("%Y.%m.%d", localtime(time)));
    foreach (@senders) {
        $t = $redis->zscore('enddate', $_); $max_timestamp = $t if $max_timestamp < $t;
        last if strftime("%Y.%m.%d", localtime($max_timestamp)) eq $d
    }
    strftime("%Y.%m.%d %H:%M:%S", localtime($max_timestamp))
}

sub get_keys($) {
    my $key = shift;
    my %k = ();
    if ($keys_re or $keys_re_excl or ($bd1_start or $bd1_end or $bd2_start or $bd2_end) and $host and $stats_type eq 'senders') {
        my ($start, $stop) = (0, $page_count);
        my $t11 = ($bd1_start =~ /(\d\d)\.(\d\d).(\d{4})/io and $host and $stats_type eq 'senders') ? timelocal(0, 0, 0, $1, $2 - 1, $3 - 1900) : 0;
        my $t12 = ($bd1_end =~ /(\d\d)\.(\d\d).(\d{4})/io and $host and $stats_type eq 'senders') ? timelocal(59, 59, 23, $1, $2 - 1, $3 - 1900) : 0;
        my $t21 = ($bd2_start =~ /(\d\d)\.(\d\d).(\d{4})/io and $host and $stats_type eq 'senders') ? timelocal(0, 0, 0, $1, $2 - 1, $3 - 1900) : 0;
        my $t22 = ($bd2_end =~ /(\d\d)\.(\d\d).(\d{4})/io and $host and $stats_type eq 'senders') ? timelocal(59, 59, 23, $1, $2 - 1, $3 - 1900) : 0;
        my %k2;
        while (scalar keys %k < $page_count) {
            %k2 = @{$redis->zrevrange($key, $start, $stop, 'WITHSCORES')};
            last unless scalar keys %k2;
            foreach (keys %k2) {
                next if $keys_re and $_ !~ /$keys_re/i;
                next if $keys_re_excl and /$keys_re_excl/i;
                next if $t11 && $redis->zscore('begindate', $_) < $t11 || $t12 && $redis->zscore('begindate', $_) > $t12
                    || $t21 && $redis->zscore('enddate', $_) < $t21 || $t22 && $redis->zscore('enddate', $_) > $t22;
                $k{$_} = $key =~ /date/ ? strftime("%Y.%m.%d", localtime($k2{$_} || 0)) : $k2{$_}
            }
            $start = $stop + 1; $stop += $page_count
        }
    } else {
        %k = @{$redis->zrevrange($key, 0, $page_count, 'WITHSCORES')};
        if ($key =~ /date/io) {
            $k{$_} = strftime("%Y.%m.%d", localtime($k{$_} || 0)) foreach (keys %k)
        }
    }
    return \%k;
}

sub get_sortedcol_hash($) {
    my $col = shift;
    my %h = ();
    if ($col =~ /^((?:uniq|total)\:)period$/) {
        return \%h unless $days > 0;
        my %all = ();
        my $i = $days;
        while ($i >= 0) {
            my %a = %{get_keys(get_key($1.strftime("%Y%m%d", localtime(time - 86400 * $i))))};
            $all{$_} += $a{$_} + 0 foreach (keys %a); $i--;
        }
        my @arr = sort { $all{$b} <=> $all{$a} } keys %all;
        splice @arr, $page_count;
        $h{$_} = $all{$_} foreach (@arr)
    } elsif ($col eq 'regdate') {
        my ($filter, @data); @data = (); $filter = {};
        if ($host) {
            my $domain_id;
            if ($dom_type eq 'senders') {
                $domain_id = $db{'senderDomains'}->findOne({'domain' => $host}, '_id');
                $$filter{'domain_id'} = $domain_id;
            } else {
                $domain_id = $db{'recipientDomains'}->findOne({'domain' => $host}, '_id');
                my @r = @{$db{'recipients'}->get({'domain_id' => $domain_id}, '_id')};
                my @s = @{$db{'bounces'}->get({'recipient_id' => {'$in' => \@r}}, 'sender_id', 1)};
                $$filter{'_id'} = {'$in' => \@s};
            }
            $$filter{'sender'} = {'$regex' => qr/$keys_re/} if $keys_re;
            $$filter{'sender'}{'$not'} = {'$regex' => qr/$keys_re_excl/} if $keys_re_excl;
            @data = @{$db{'senders'}->get($filter)};
        } else {
            $$filter{'domain'} = {'$regex' => qr/$keys_re/} if $keys_re;
            $$filter{'domain'}{'$not'} = {'$regex' => qr/$keys_re_excl/} if $keys_re_excl;
            @data = @{$db{'senderDomains'}->get($filter)};
        }
        splice @data, $page_count;
        foreach (@data) {
            $$_{'regdate'} = sprintf("%04d.%02d.%02d", $1, $2, $3) if $$_{'regdate'} =~ /^(\d+)-(\d\d)-(\d\d)/;
            if ($host) { $h{$$_{'sender'}} = $$_{'regdate'} }
            else { $h{$$_{'domain'}} = $$_{'regdate'} }
        }
    } elsif ($col =~ /date/) {
        %h = %{get_keys($col)}
    } else { %h = %{get_keys(get_key($col))} } # $col =~ /(\d+)/ ? $1 :
    \%h
}

sub get_cell_value($$) {
    my ($key, $col) = @_;
    my $v = 0;
    if ($col =~ /^((?:uniq|total)\:)period$/) {
        return $v unless $days > 0;
        my $i = $days;
        while($i >= 0) {
            $v += $redis->zscore(get_key($1.strftime("%Y%m%d", localtime(time - 86400 * $i))), $key) + 0; $i--
        }
    } elsif ($col eq 'regdate') {
        $v = $host ? get_regdate_by_email($key) : get_regdate_for_domain($key)
    } elsif ($col =~ /date/) {
        $v = strftime("%Y.%m.%d", localtime($redis->zscore($col, $key) || 0))
    } else { $v = $redis->zscore(get_key($col), $key) } # $col =~ /(\d+)/ ? $1 :
    $v
}

sub get_key($) {
    my ($iu, $key) = ($_[0] =~ /^(uniq|total)\:(.*)$/);
    $dom_prefx.(($host and $stats_type ne 'senders') ? ':'.$key.($host ? ':'.$host : '') : ':'.($host ? ($iu.':'.($iu eq 'uniq' ? $key.':'.$host : $host.':'.$key)) : $iu.':'.$key))
}

sub get_suid_by_login($) {
    my $query = '/blackbox?method=userinfo&login='.shift().'&sid=smtp&userip=127.0.0.1&dbfields=subscription.suid.-';
    my ($code, $buf);
    my $sh = Net::HTTP->new('Host' => 'blackbox-mail.yandex.net', 'HTTPVersion' => '1.0', 'KeepAlive' => 0);
    if ($sh) {
        $sh->write_request('GET' => $query);
        ($code, undef, undef) = eval { $sh->read_response_headers() };
        if ($@) { writeLog("blackbox error: $@") }
        elsif ($code == 200) {
            $sh->read_entity_body($buf, 8192);
        }
    } else { writeLog("blackbox error: $@") }
    my ($suid) = ($buf =~ /<dbfield id="subscription.suid.-">(\d+)<\/dbfield>/);
    return $suid;
}

sub get_regdate_for_domain {
    my ($domain, $is_full) = @_;
    return unless $domain;
    my ($code, $buf, $regdate);
    $regdate = $db{'senderDomains'}->findOne({'domain' => $domain}, 'regdate');
    $regdate =~ s/\s+\S+\s*$// if $regdate and !$is_full;
    unless ($regdate) {
        my $sh = Net::HTTP->new('Host' => 'blackbox-mail.yandex.net', 'HTTPVersion' => '1.0', 'KeepAlive' => 0);
        if ($sh) {
            $sh->write_request('GET' => '/blackbox?method=hosted_domains&domain='.$domain);
            ($code, undef, undef) = eval { $sh->read_response_headers() };
            if ($@) { writeLog("blackbox error: $@") }
            elsif ($code == 200) {
                $sh->read_entity_body($buf, 2048);
            }
        } else { writeLog("blackbox error: $@") }
        if ($buf =~ /<item\s+.*?\bborn_date="(\d{4})\-(\d\d)\-(\d\d)\s+(.+)"\s*\/?>/) {
            $regdate = $1.'.'.$2.'.'.$3.($is_full ? ' '.$4 : '');
            $db{'senderDomains'}->update({'domain' => $domain}, {'$set' => {'regdate' => $1.'-'.$2.'-'.$3.' '.$4}});
        }
    }
    return $regdate;
}

sub get_regdate_by_email {
    my ($login, $is_full) = @_;
    return unless $login;
    my ($code, $buf, $s, $regdate, $suid);
    $buf = $db{'senderDomains'}->findOne({'sender' => $login});
    ($suid, $regdate) = ($buf->{'suid'}, $buf->{'regdate'});
    $regdate =~ s/\s+\S+\s*$// if $regdate and !$is_full;
    unless ($suid and $regdate) {
        my $sh = Net::HTTP->new('Host' => 'blackbox-mail.yandex.net', 'HTTPVersion' => '1.0', 'KeepAlive' => 0);
        if ($sh) {
            $sh->write_request('GET' => '/blackbox?method=userinfo&login='.$login.'&sid=smtp&userip=127.0.0.1&dbfields=subscription.suid.-&emails=getall');
            ($code, undef, undef) = eval { $sh->read_response_headers() };
            if ($@) { writeLog("blackbox error: $@") }
            elsif ($code == 200) {
                $sh->read_entity_body($buf, 8192);
            }
        } else { writeLog("blackbox error: $@") }
        ($s) = $buf =~ /<dbfield id="subscription.suid.-">(\d+)<\/dbfield>/;
        $suid = $s if $s; $s = $regdate;
        if ($buf =~ /<address\s+.*?\bborn-date="(\d{4})\-(\d\d)\-(\d\d)\s+(.+)"\s*>/) {
            $s = $1.'-'.$2.'-'.$3.' '.$4;
            $regdate = $1.'.'.$2.'.'.$3.($is_full ? ' '.$4 : '');
        }
        $db{'senders'}->update({'sender' => $login}, {'$set' => {'suid' => $suid, 'regdate' => $s}});
    }
    return $suid ? (wantarray() ? ($regdate, $suid) : ($regdate || '')) : '';
}

sub convFromPunycode {
    my $str = '';
    $str .= ($str ? '.' : '').(/^xn--/ ? decode_punycode($_) : $_) foreach (split /\./, shift());
    $str
}
