#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, cgitb
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/web')
from jinja2 import Environment, FileSystemLoader
from log_utils import writelog
from common import CFG, RE, getUUID
from rules_common import CheckingRepoContext, verifyAFRules


reload(sys)
sys.setdefaultencoding('utf-8')


RULES = CFG["af_rules"]


def changeRow(row):
    r = RE["bash_trace"].sub(r'', row)
    if r and RE["rules_results"].match(r):
        r = "<b>{0}</b>".format(r)
    return r


if __name__ == "__main__":
    print "Content-type: text/html\r\n\r\n"
    form = cgi.FieldStorage()
    text = ''
    host = "%s://%s/" % ('http' + ('s' if 'HTTPS' in os.environ else ''), os.environ['SERVER_NAME'])
    with CheckingRepoContext(RULES['check_lock_path']) as RulesLock:
        # verification of rules in 'antifraud' folder
        text, faultRulesCnt = verifyAFRules(getUUID(), "", RULES["folder_name"])
        text = RE["exception"].sub(r'\n<p style="color: #FF0000;"><b>\1</b></p>', text)
        text = '<br />'.join(filter(lambda x: x, map(lambda r: changeRow(r), text.split('\n'))))
    try:
        env = Environment(loader=FileSystemLoader("WORKING_DIR/web/internal"))
        template = env.get_template("check_af_rules.html.template")
        print template.render(text=text, host=host).encode("utf-8")
    except Exception, e:
        writelog("Exception while rendering check rules page: %s" % str(e), True)
