#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi, cgitb
cgitb.enable()
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/web')
from jinja2 import Environment, FileSystemLoader
from log_utils import writelog
from common import CFG, RE, getUUID
from rules_common import RULES_TYPES, RULES_DIRS, CheckingRepoContext, verifyRules


reload(sys)
sys.setdefaultencoding('utf-8')


def changeRow(row):
    r = RE["rules_folder"].sub(r' {}/'.format(CFG["so_rules"]["folder_name"]), row)
    #r = RE["rules_timestamp"].sub(r'', r)
    r = RE["rules_timestamp2"].sub(r'', r)
    if RE["rules_results"].match(r):
        r = "<b>{0}</b>".format(r)
    return r


if __name__ == "__main__":
    print "Content-type: text/html\r\n\r\n"
    form = cgi.FieldStorage()
    route, text = form.getfirst("route", "In"), ''
    host = "%s://%s/" % ('http' + ('s' if 'HTTPS' in os.environ else ''), os.environ['SERVER_NAME'])
    ROUTES = map(lambda rt: (rt[0], rt[1]), RULES_TYPES)
    with CheckingRepoContext(CFG["so_rules"]['check_lock_path']) as RulesLock:
        text, fault_rules_cnt = verifyRules(getUUID(), route)
        text = '<br />'.join(map(lambda r: changeRow(r), text.split('\n')))
    try:
        env = Environment(loader=FileSystemLoader("WORKING_DIR/web/internal"))
        template = env.get_template("check_rules.html.template")
        print template.render(text=text, route=route, routes=ROUTES, host=host).encode("utf-8")
    except Exception, e:
        writelog("Exception while rendering check rules page: %s" % str(e), True)
