#!/usr/bin/python2
# -*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re, time, json, urllib2, requests, pymongo, psycopg2, redis
import ticket_parser2 as tp2
from socket import _GLOBAL_DEFAULT_TIMEOUT
from ticket_parser2.api.v1 import ServiceContext
from traceback import format_exception
from random import randrange
from urllib import urlopen, urlencode
from smtplib import SMTP
from log_utils import writelog


CFG = {
    # General settings
    'logfile':              '/logs/so-web.log',
    'nginx_folder':         'WORKING_DIR',
    'retry_cnt':            3,
    # Sologger settings
    'sologger': {
        "host":             "logger.so.yandex-team.ru",
        "uri":              "/search?",
        "index_uri":        "/unprefixed-parallel/search?",
        "saving_days": {
            "in":           12,
            "out":          21,
            "corp":         30
        }
    },
    # Rules & rules' readers settings
    "so_rules": {
        'folder_name':      'so_rules_checked',
        "folder":           'WORKING_DIR/so_rules_checked/',
        'reader_path':      'WORKING_DIR/Reader',
        'ini_folder':       'WORKING_DIR'
    },
    "af_rules": {
        "folder_name":      'af_rules_checked',
        "folder":           'WORKING_DIR/af_rules_checked/',
        "reader_path":      'WORKING_DIR/web/hooks/antifraud_rules_reader.sh',
        "submodules":  {
            "auth":          u"Авторизации",
            "autoru":        u"Авто.ру",
            "bank":          u"Банк",
            "beru":          u"Беру",
            "bnpl":          u"BNPL",
            "browser":       u"Браузер",
            "cloud":         u"Облако",
            "connect":       u"Коннект",
            "direct":        u"Директ",
            "disk":          u"Диск",
            "dostavka":      u"Логистика",
            "drive":         u"Драйв",
            "edadeal":       u"Едадил",
            "eda_lavka":     u"Еда&Лавка",
            "games":         u"Игры",
            "help_nko":      u"Помощь",
            "invest":        u"Инвестиции",
            "market":        u"Маркет",
            "market_bnpl":   u"Маркет.Рассрочки",
            "media":         u"Медиа",
            "maps_payments": u"Карты/657.Купоны",
            "obyavleniya":   u"Объявления",
            "oplata":        u"Оплата",
            "passport":      u"Паспорт",
            "praktikum":     u"Практикум",
            "realty":        u"Недвижимость",
            "samokat":       u"Самокат",
            "sprav":         u"Справка",
            "station":       u"Станция",
            "surveys":       u"Взгляд",
            "taxi":          u"Такси",
            "telephony":     u"Телефония",
            "telemedicine":  u"Телемедицина",
            "test":          u"Тест",
            "toloka":        u"Толока",
            "translate":     u"Переводчик",
            "travel":        u"Путешествия",
            "uslugi":        u"Услуги",
            "yandex_pay":    u"Pay",
            "yandex_plus":   u"Плюс",
            "zapravki":      u"Заправки",
            "zen":           u"Дзен"
        }
    },
    'rules_check_tmp_dir': 'WORKING_DIR/temp/check_rules',
    # GitHub settings
    'github_host':         'github.yandex-team.ru',
    # Some predefined emails
    'robot': {
        "name":            'Robot Mailspam <robot-mailspam@yandex-team.ru>',
        "login":           'robot-mailspam',
        "user":            'robot-mailspam@yandex-team.ru',
        "password":        ''
    },
    'report':              'so-report@yandex-team.ru',
    # SMTP settings
    'smtp': {
        'host':            'outbound-relay.yandex.net',
        'port':            25,
        'timeout':         5.0
    },
    # IMAP settings
    'imap_corp': {
        'in_host':         'imap.yandex-team.ru',
        'in_port':         993,
        'out_host':        'smtp.yandex-team.ru',
        'out_port':        465,
        'folder':          'so-spam-report'
    }
}
CFG["so_rules"]["check_lock_path"] = "{}/check_rules.lock".format(CFG["rules_check_tmp_dir"])
CFG["af_rules"]["check_lock_path"] = "{}/check_af_rules.lock".format(CFG["rules_check_tmp_dir"])
LOCK = {
    'update_metric': 1,
    'git_checkout':  2,
    'complaints_db': 3
}
LOGINS = {
    '95.108.173.214': 'andy',
    '95.108.172.49':  'kerrik',
    '95.108.174.245': 'klimiky',
    '95.108.174.70':  'sgeorge',
    '95.108.173.38':  'luckybug',
    '2a02:6b8:0:408:41a1:2e6:7d53:ec19':  'andy',
    '2a02:6b8:0:107:e218:77ff:fe06:2cfc': 'klimiky',
    '2a02:6b8:0:408:51bd:8959:f7fa:94f8': 'sgeorge',
    '2a02:6b8:0:408:d12f:7fc3:dc70:f227': 'kerrik',
    '2a02:6b8:0:408:ebe6:b59:2f43:77':    'luckybug'
}
RE = {
    "domain":           re.compile(r"(?:(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?|xn\-\-[a-z0-9-]+)\.)+(?:xn\-\-[a-z0-9-]+|[a-z]+)", re.I),
    "ip":               re.compile(r"[\d:\.a-f]+", re.I),
    "yandex_domain":    re.compile(r"(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\.)*\b(?:yandex|ya|narod|yandex-team)\.(?:[a-z]{2,4}|yandex)", re.I),
    "yandex_net":       re.compile(r".*\.yandex\.net\b", re.I),
    "url":              re.compile(r"https?:\/\/[^\s\"\'\*]+[^\s\"\'\*\.\:\+]"),
    "rules_folder":     re.compile(r" (\/\S+?\/)rules\/"),
    "rules_timestamp":  re.compile(r"\s*[A-Za-z]{3}\s+\d+\s+\d\d:\d\d:\d\d(?:\.\d+)\s+\-\s+\[\d+\]\s+"),
    "rules_timestamp2": re.compile(r"\s*\d{4}-\d\d-\d\dT\d\d:\d\d:\d\d(?:\.\d+)\+\d+\[\d+\]\s+"),
    "rules_results":    re.compile(r"(.*?(?:All|Err|Rules cs:).*?)"),
    "rule_weight":      re.compile(r"^([A-Z0-9_]+)(?:\s+.*)?\s+([\-0-9\.]+)\s*$"),
    "bash_trace":       re.compile(r'^\++?\s+.*$', re.M),
    "exception":        re.compile(r'\n((?:Exception |Caused by:)[^\n]+\n(?:[\t ]+[^\n]+\n)+)', re.S)
}
RE['email'] = re.compile(r"[\w\+\-\.]+\@{0}".format(RE['domain'].pattern), re.I)
RE['safe_email'] = re.compile("[^\"@<>,\s]+@{0}".format(RE['domain'].pattern), re.I)
RE['yandex_email'] = re.compile(r"[\w\+\-\.]+\@{0}".format(RE['yandex_domain'].pattern), re.I)
TVM_SO_WEB_CLIENT_ID = 2001437
TVM_BLACKBOX_CLIENT_ID = 222
TVM_BLACKBOX_CORP_CLIENT_ID = 223
BLACKBOX_URL = 'https://blackbox-mail.yandex.net/blackbox'
BLACKBOX_CORP_URL = 'https://blackbox.yandex-team.ru/blackbox'
TVM = {
    "API": {
        "host":           "tvm-api.yandex.net",
        "url":            "https://{0}/2/",
        "URL":            "https://tvm-api.yandex.net/2/"
    },
    "MulcaGate": {
        "host":           "storage.mail.yandex.net",
        "url":            "https://{0}:4443/gate/get/",
        "URL":            "https://storage.mail.yandex.net:4443/gate/get/",
        "client_id":      2001437,
        "prod_client_id": 2000273,
        "timeout":        3.0,
        "retry_cnt":      3
    },
    "BB": {
        "host":           "blackbox-mail.yandex.net",
        "url":            "https://{0}/blackbox?",
        "URL":            "https://blackbox-mail.yandex.net/blackbox?",
        "client_id":      2001437,
        "prod_client_id": 222,
        "timeout":        3.0
    },
    "BBcorp": {
        "host":           "blackbox.yandex-team.ru",
        "url":            "https://{0}/blackbox?",
        "URL":            "https://blackbox.yandex-team.ru/blackbox?",
        "client_id":      2001437,
        "prod_client_id": 223,
        "timeout":        3.0
    }
}


def default(s, defaultval):
    return s if s else defaultval


def getUUID(sep='-'):
    if not sep: sep = '-'
    chars, s = ['a', 'b', 'c', 'd', 'e', 'f', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'], []
    for i in range(32):
        s.append(chars[int(randrange(16))])
    s.insert(8,  sep)
    s.insert(13, sep)
    s.insert(18, sep)
    s.insert(23, sep)
    return ''.join(s)


def to_utf8(data, default=''):
    try:
        return data.encode("utf-8", "ignore")
    except UnicodeDecodeError:
        try:
            return "".join(map(lambda c: unichr(ord(c)), data))
        except:
            return default


def doRequest(url, prompt, log_fh=None):
    try:
        for i in range(CFG['retry_cnt']):
            f = urlopen(url)
            if f.getcode() == 200:
                return f.read()
            elif f.getcode() == 529:
                time.sleep(i * 2)
                continue
            else:
                writelog('{0} response HTTP code: {1}, body: {2}'.format(prompt, f.getcode(), f.info()), fh=log_fh)
                break
    except Exception, e:
        writelog('%s HTTP request failed: %s.' % (prompt, str(e)), True, fh=log_fh)
    return ""


def requestService(url, headers={}, data=None, timeout=_GLOBAL_DEFAULT_TIMEOUT, retry_cnt=CFG['retry_cnt'], log_fh=None):
    code = -1
    for i in range(retry_cnt):
        try:
            r = f = None
            r = urllib2.Request(url=url, data=data, headers=headers)
            f = urllib2.urlopen(r, timeout=timeout)
            if f:
                return f.read(), f.getcode()
            else:
                writelog('requestService request #%d response is empty!' % (i + 1), fh=log_fh)
                continue
        except Exception, e:
            serr = info = method = ''
            if hasattr(e, 'code'):
                code = e.code
                serr = ' (code=%s)' % code
            info = 'Info: {0}. '.format(f.info()) if f else ''
            method = "{0} ".format(r.get_method()) if r else ''
            writelog("requestService HTTP %srequest (attempt #%d) failed%s: '%s'. URL: %s.%s" % (method, i + 1, serr, str(e), url, info), True, fh=log_fh)
            continue
    return "", code


def getNannyInstances(service, default_hosts=[]):
    try:
        for i in range(CFG['retry_cnt']):
            r = doRequest("https://nanny.yandex-team.ru/v2/services/%s/current_state/instances/" % service, "Get instances for Nanny service '%s'" % service)
            if r:
                info = json.loads(r.strip())
                return map(lambda item: item['container_hostname'], info['result'])
            else: continue
    except Exception, e:
        writelog("getNannyInstances exception: %s" % str(e), True)
    return default_hosts


def getHosts4Group(conductor_group, default_hosts=[], log_fh=None):
    if conductor_group:
        for i in range(CFG['retry_cnt']):
            r = doRequest("https://c.yandex-team.ru/api-cached/groups2hosts/%s" % conductor_group, "Get DB cluster hosts for group %s" % conductor_group, log_fh)
            if r:
                hosts = map(str.strip, r.splitlines())
                return hosts if len(hosts) > 0 else default_hosts
            else:
                continue
    return default_hosts


def getLogin(ip='', default=''):
    if not ip:
        ip = os.environ['REMOTE_ADDR']
    return LOGINS[ip] if ip in LOGINS else default


def isCorp(uid):
    return str(uid).startswith("112000") and len(str(uid)) == 16


def getRobotCredentials(cfg, log_fh=None):
    if 'user' not in cfg:
        return
    i = cfg['user'].find('@')
    file_name = '.robot.{}'.format(cfg['user'][:i] if i > -1 else cfg['user'])
    dirs = ['WORKING_DIR']
    if "HOME" in os.environ:
        dirs.append(os.environ["HOME"])
    if "PWD" in os.environ:
        dirs.append(os.environ["PWD"])
    dirs.append("/root")
    for folder in dirs:
        file_path = '{}/{}'.format(folder, file_name)
        if os.path.exists(file_path):
            break
    if os.path.exists(file_path):
        try:
            f = open(file_path)
            cfg['password'] = f.read().strip()
            f.close()
        except Exception, e:
            writelog("getRobotCredentials exception: Unable to read secret for robot '%s': %s" % (cfg["user"], str(e)), True, log_fh)
    else:
        writelog("getRobotCredentials: Unable to locate secret for robot '%s'" % cfg["user"], False, log_fh)


def getTVM2keys(log_fh=None):
    tvm_keys = ''
    try:
        tvm_keys = requests.get('{0}keys?lib_version={1}'.format(TVM['API']['URL'], tp2.__version__)).content
    except Exception, e:
        writelog("Get TVM keys error: %s" % str(e), True, log_fh)
    return tvm_keys


def getTVMCredentials(cfg, log_fh=None):
    f, CURDIR = None, 'WORKING_DIR'
    for service in filter(lambda k: k != 'API', cfg.keys()):
        svc, curdir = service.lower(), CURDIR
        try:
            if not os.path.exists('{0}/.{1}.client_secret'.format(curdir, svc)) and not os.path.exists('{0}/.tvm2.token'.format(curdir)):
                curdir = os.path.dirname(os.path.abspath(__file__))
                if not os.path.exists('{0}/.{1}.client_secret'.format(curdir, svc)) and not os.path.exists('{0}/.tvm2.token'.format(curdir)):
                    curdir = '/root'
            filePath = ''
            if os.path.exists('{0}/.{1}.client_secret'.format(curdir, svc)):
                filePath = '{0}/.{1}.client_secret'.format(curdir, svc)
            elif os.path.exists('{0}/.tvm2.token'.format(curdir)):
                filePath = '{0}/.tvm2.token'.format(curdir)
            if filePath:
                f = open(filePath)
                cfg[service]['client_secret'] = f.read().strip()
                f.close()
            else:
                writelog("getTVMCredentials: file with TVM secret does not exists!", False, log_fh)
        except Exception, e:
            writelog("getTVMCredentials exception: %s." % str(e), True, log_fh)


def getTVM2svcContext(service, log_fh=None):
    getTVMCredentials(TVM, log_fh)
    tvm_keys = getTVM2keys(log_fh)
    return ServiceContext(TVM[service]["client_id"], TVM[service]['client_secret'], tvm_keys)


def getTVM2ticket(service, log_fh=None):
    resp = {}
    try:
        ts = int(time.time())
        service_context = getTVM2svcContext(service, log_fh)
        content, code = requestService('{0}ticket/'.format(TVM['API']['URL']), data=urlencode({
            'grant_type': 'client_credentials',
            'src':        TVM[service]["client_id"],
            'dst':        TVM[service]["prod_client_id"],
            'ts':         ts,
            'sign':       service_context.sign(ts, TVM[service]["prod_client_id"])
        }), log_fh=log_fh)
        if code != 200:
            writelog("getTVM2ticket HTTPS error for service '%s' (status=%s): %s" % (service, code, content), fh=log_fh)
        try:
            if content:
                resp = json.loads(content)
            else:
                writelog("getTVM2ticket error answer for service '%s' (code=%s): %s" % (service, code, content), fh=log_fh)
        except Exception, e:
            writelog("getTVM2ticket decoding of JSON from TVM ticket query's answer failed for service '%s': %s" % (service, str(e)), True, log_fh)
    except Exception, e:
        writelog("getTVM2ticket HTTPS request failed for service '%s': %s." % (service, str(e)), True, log_fh)
    return resp[str(TVM[service]["prod_client_id"])]['ticket'] if str(TVM[service]["prod_client_id"]) in resp and resp[str(TVM[service]["prod_client_id"])] else None


def requestServiceByTVM(url, service, headers={}, data=None, log_fh=None):
    resp, code = '', 200
    ticket = getTVM2ticket(service, log_fh)
    if ticket:
        n = TVM[service].get("retry_cnt", 1)
        if not headers:
            headers = {}
        headers['X-Ya-Service-Ticket'] = ticket
        for i in range(n):
            try:
                resp, code = requestService(url, headers=headers, data=data, timeout=TVM[service].get("timeout", _GLOBAL_DEFAULT_TIMEOUT), retry_cnt=1, log_fh=log_fh)
                break
            except Exception, e:
                writelog('requestServiceByTVM for "%s" failed: %s. TicketAnswer: %s' % (url, str(e), str(ticket)), True, log_fh)
            if code != 200:
                writelog('requestServiceByTVM for "%s" failed (attempt #%s from %s, status=%s). Response: "%s"' % (url, i + 1, n, code, resp), fh=log_fh)
                continue
    return resp, code


def requestMulcaGate(stid, log_fh=None):
    url = "%s?raw=&service=so" % stid
    return requestServiceByTVM(TVM['MulcaGate']['URL'] + url, 'MulcaGate', log_fh=log_fh)


def requestBlackBox(params, bb_type='BB', log_fh=None):
    url = params if isinstance(params, basestring) else ('&'.join(map(lambda it: "{0}={1}".format(*it), params.items())) if isinstance(params, dict) else '')
    return requestServiceByTVM(TVM[bb_type]['URL'] + url, bb_type, log_fh=log_fh)


def getUserInfo(uid="", suid="", login="", bbType="BB", log_fh=None):
    s, bb_type = "", bbType
    if uid:
        s = "uid=%s" % str(uid)
    elif suid:
        s = "suid=%s&sid=2" % str(suid)
    elif login:
        s = "login=%s" % login
    else:
        return uid, suid, login
    if not bb_type and (isCorp(uid) or isCorp(suid)):
        bb_type = "BBcorp"
    try:
        content, code = requestBlackBox("method=userinfo&%s&userip=127.0.0.1&dbfields=subscription.suid.2" % s, bb_type, log_fh)
        if content and code == 200:
            content = content.strip()
            m = re.search(r'^<uid.*?>(\d+)</uid>', content, re.M)
            if m:
                uid = m.group(1)
            m = re.search(r'^<dbfield id="subscription.suid.2">(\d+)</dbfield>', content, re.M)
            if m:
                suid = m.group(1)
            m = re.search(r'<login>([^<]+)', content, re.M)
            if m:
                login = m.group(1)
        else:
            writelog("getUserInfo obtained empty result for uid = %s, suid = %s, login = %s" % (uid, suid, login), False, log_fh)
    except Exception, e:
        writelog("getUserInfo exception: %s" % str(e), True, log_fh)
    return uid, suid, login


def isUserFromStaff(uid, log_fh=None):
    if isCorp(uid):
        return 1
    is_staff = code = 0
    resp = ''
    for i in range(CFG['retry_cnt']):
        resp, code = requestBlackBox({
            'method':   'userinfo',
            'uid':      uid,
            'sid':      2,
            'userip':   '127.0.0.1',
            'dbfields': 'subscription.suid.669'
        }, "BB", log_fh=log_fh)
        if code == 200:
            m = re.search(r'^<dbfield id="subscription.suid.669">([^<>]*?)</dbfield>', resp, re.M)
            is_staff = int(m.group(1)) if m and m.group(1) else 0
            break
    if code and code != 200:
        writelog("isUserFromStaff failed for uid=%s (code=%s): '%s'." % (uid, code, resp), False, log_fh)
    return is_staff


def getFlagsFromRules(rules, source, headers, mx, route, isSeoAbuse, log_fh=None):
    flags = []
    try:
        if "HIDDEN_DLVR" in rules:
            flags.append("HD")
        if "DL_FBR" in rules:
            flags.append("DL")
        if "FREE_MAIL_COND" in rules:
            flags.append("FM")
        if "DSN_NO_SENT_BY_YAMAIL" in rules or "CL_BOUNCE" in rules:
            flags.append("BN")
        if mx == "yaback":
            flags.append("YB")
        elif mx == "outback":
            flags.append("OB")
        elif "BY_YANDEX_HTTP" in rules or route == "out" and ('x-mailer' in headers and re.match(r'Yamail ', headers.get('x-mailer', "")) and not mx.startswith("smtp")):
            flags.append("YW")
        elif "BY_YANDEX_SMTP" in rules or route == "out":
            flags.append("YS")
        elif "ALLTRUSTEDIP" in rules and source != "fblin":
            flags.append("ZY")
        if "TR_GEO_RCP" in rules:
            flags.append("ZT")
        if "USR_UA" in rules:
            flags.append("ZU")
        if "USR_BY" in rules:
            flags.append("ZB")
        if "__CSO_FROM_FORWARD" in rules:
            flags.append("DF")
        if "YANDEX_MAILER" in rules or "YANDEX_SMTP" in rules:
            flags.append("DC")
        if "__POP3_AUTH" in rules:
            flags.append("P3")
        if "SH_27_1111" in rules:
            flags.append("1K")
        if "__IS_FORWARD" in rules:
            flags.append("FW")
        if "PAY_SENDER" in rules:
            flags.append("PS")
        if "YA_DEVNULL_RP" in rules:
            flags.append("DN")
        if "SHIN_FAIL" in rules:
            flags.append("SF")
        if "SHIN2_FAIL" in rules:
            flags.append("S2")
        if "PDD" in rules:
            flags.append("PD")
            if "PDD_MAILBOX_5K" in rules:
                flags.append("PO")
        if "BY_YANDEX_HTTP_SPAM" in rules:
            flags.append("YC")
        if "TR_GEO_USER" in rules:
            flags.append("OT")
        if "REC_IPV6" in rules:
            flags.append("V6")
        if "__IMAP_AUTH" in rules:
            flags.append("IM")
        if "__BORN_DATE_0_30" in rules:
            flags.append("FR")
        if "NEWS_NO_UNSIB_LIST" in rules:
            flags.append("NU")
        if "__SPF_PASS" in rules:
            flags.append("SP")
        if "SPF_FAIL" in rules:
            flags.append("SN")
        if "__YA_DKIM_PASS" in rules:
            flags.append("DP")
        if "DOMN_ROLL" in rules:
            flags.append("DR")
        if "YA_POP3" in rules:
            flags.append("YP")
        if "YA_IMAP" in rules:
            flags.append("YM")
        if "RDSL_FR" in rules:
            flags.append("DS")
        if "U_PF" in rules:
            flags.append("UF")
        if "PERSONAL_CORRECT" in rules or "x-yandex-personal-spam" in headers:
            flags.append("PF")
        if "SP_LIST_YTEAM" in rules:
            flags.append("LY")
        if "ABUK_PERC_1_50" in rules or "ABUK_PERC_50_90" in rules or "ABUK_PERC_90_MAX" in rules:
            flags.append("AB")
        if "FAKE_RESOLV" in rules or "FAKE_RESOLV_V6" in rules or "FRNR" in rules:
            flags.append("FA")
        if "ACT_US" in rules:
            flags.append("AU")
        if "CLNDR_CMPL" in rules:
            flags.append("CA")
        if "MAILISH" in rules:
            flags.append("MA")
        if "RPTN_MAN" in rules:
            flags.append("RP")
        if route == "out":
            if "MALIC_ML" in rules:
                flags.append("ML")
            if "PDD_LOCAL" in rules:
                flags.append("PL")
            if "YA_CAPTCHA" in rules:
                flags.append("CY")
            if "YA_CAPTCHA_BAD" in rules:
                flags.append("CN")
        if "SEO_ABUSE" in rules or isSeoAbuse:
            flags.append("SA")
        for i in range(10):
            if "LOGTYPE_A{}".format(i) in rules:
                flags.append("A{}".format(i))
            if "FLAG_{}".format(i) in rules:
                flags.append("F{}".format(i))
    except Exception, e:
        writelog("getFlagsFromRules exception: %s" % str(e), True, log_fh)
    return flags


def getFlagsFromParams(params, headers, forward, isGreyComplainaint, log_fh=None):
    flags = []
    try:
        if isGreyComplainaint is not None and not isGreyComplainaint:
            flags.append("PC")
        if params.get("move", ""):
            flags.append("MV")
        spamHeader = headers.get("x-yandex-spam", headers.get("x-spam-flag", "0"))
        if spamHeader == "0":
            flags.append("SK")
        if isCorp(params.get("uid", "")) or str(params.get("uid", "")) == "999999999999999":
            flags.append("YT")
        if params["type"] == "antifoo" and (spamHeader == "1" or spamHeader == "2" or spamHeader == "NO" and "YT" in flags):
            flags.append("WH")
        if params["type"] == "foo" and (spamHeader == "4" or spamHeader == "YES" and "YT" in flags):
            flags.append("WS")
        if forward:
            flags.append("YF")
        if params.get("was", False):
            flags.append("XX")
        if params["source"].startswith("imap"):
            flags.append("IC")
        if params["source"].startswith("mobile"):
            flags.append("MC")
        if params["source"].startswith("furita"):
            flags.append("FC")
        if params["source"].startswith("fbl"):
            flags.append("FB")
            if 'ZY' in flags:
                del flags[flags.index('ZY')]
        if params["source"].startswith("fastsrv"):
            flags.append("FS")
    except Exception, e:
        writelog("getFlagsFromParams exception: %s" % str(e), True, log_fh)
    return flags


def writeComplYTlog(params, msgtime, actdatastr, footype, ip, queueid, msgdatastr, so_res, fromaddr, rcpt, route='', folder='', spf_dkim=0, skipped='', topic="mail-so-compl-log", metrics=True, fh=None):
    if footype == 'delete':
        logtype = 'deletes'
    elif skipped:
        logtype = 'complaints_skipped'
    else:
        logtype = 'complaints'
    if metrics:
        metric_inc('%s_ytlog_total' % logtype)
    s = u"unixtime=%d\tactdate=%s\ttype=%s\tuid=%s\tsuid=%s\tkarma=%s\tip=%s\tsender_ip=%s\tstid=%s\tqueueid=%s\tmsgdate=%s\tsource=%s\tso_res=%s\tfrom=%s\trcpt=%s\tseen=%s\tfolder=%s\tgeo=%s\tflags=%s\tspf_dkim=%s\tskipped=%s\tclient=%s\tmid=%s\troute=%s\tshow_tabs=%s" % \
        (msgtime, actdatastr, to_unicode(footype), str(default(params.get("uid", "-"), "-")), str(default(params.get("suid", "-"), "-")),
         str(default(params.get('karma', '-'), '-')), default(params.get('ip', '-'), '-'), ip, default(params.get("stid", "-"), "-"), queueid,
        msgdatastr, params.get("source", ""), so_res, stringify(fromaddr.replace('\t', ' ').strip()), str(rcpt), default(params.get('seen', '-'), '-'), to_unicode(folder), params.get("geo", ""), params.get("flags", ""), spf_dkim, to_unicode(skipped), str(default(params.get("client", "-"), "-")), str(default(params.get("mid", "-"), "-")), route, str(default(params.get("show_tabs", "-"), "-")))
    s = s.replace('\n', ' ').replace('\r', '')
    writelog(s, False, fh, u'tskv\ttskv_format={}\t'.format(topic), False)
    if metrics:
        metric_inc('%s_ytlog_ok' % logtype)
