#!/usr/bin/perl
# -*- Encoding: utf-8; Mode: cperl -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
use strict;
use warnings;
use JSON;
use CGI;
use CGI::Carp qw(carpout fatalsToBrowser set_message);
use SO::MongoCollection;

my ($q, $iniFilePath) = (CGI->new, 'WORKING_DIR/complaints/so-complaints-graph.ini');
my %db = (
    'db_name'        => 'fbl',
    'db_hosts'       => 'db1j.so.yandex.net db1h.so.yandex.net db1m.so.yandex.net',
    'db_port'        => 27017,
    'errorsLogFile'  => 'WORKING_DIR/logs/db-fbl-errors.log'
);
$SO::LogFile::defaultLogFile = $db{'errorsLogFile'};
$SO::MongoDatabase::defaultIniFile = $iniFilePath;
$SO::MongoDatabase::defaultIniFileSection = 'fbl';
my $dbCollection = SO::MongoCollection->new('dates_info', 'fbl');
my ($cmplAction, $cmplType, $cmplDate) = ($q->param('action') || 'update', $q->param('type') || '', $q->param('date') || '');
$| = 1;
print $q->header(-type => 'application/json', -charset => 'utf-8');

if ($cmplAction ne '' and $cmplType ne '' and $cmplDate ne '') {
    --$cmplType;
    if ($cmplAction eq 'create' or $cmplAction eq 'update') {
        $dbCollection->upsert({'dt' => $cmplDate, 'type' => $cmplType}, {'$set' => {
            'event_type'   => $q->param('event_type') || 0,
            'txt'          => $q->param('event_text') || '',
            'info'         => $q->param('info') || '',
            'bg_color'     => $q->param('bg_color') || 'DADADA',
            'fg_color'     => $q->param('fg_color') || '000000',
            'border_color' => $q->param('border_color') || '888888'
        }});
    } elsif ($cmplAction eq 'remove') {
        $dbCollection->remove({'dt' => $cmplDate, 'type' => $cmplType})
    }
}

print encode_json({
    errordata => $dbCollection->{'lastError'}
}) if $dbCollection->{'lastError'};
