#!/usr/bin/perl
# -*- Encoding: utf-8; Mode: cperl -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
use strict;
use warnings;
use JSON;
use CGI;
use CGI::Carp qw(carpout fatalsToBrowser set_message);
use SO::MongoCollection;

my ($q, $iniFilePath) = (CGI->new, 'WORKING_DIR/complaints/so-complaints-graph.ini');
my ($datesPeriod, $endDate) = ($q->param('period') || 90, `date +'%Y-%m-%d'`); chomp $endDate;
my %dbFbl = (
    'db_name'        => 'fbl',
    'db_hosts'       => 'db1j.so.yandex.net db1h.so.yandex.net db1m.so.yandex.net',
    'db_port'        => 27017,
    'errorsLogFile'  => 'WORKING_DIR/logs/db-fbl-errors.log'
);
my %dbCmpl = (
    'db_name'        => 'cmpl',
    'db_hosts'       => 'db1j.so.yandex.net db1h.so.yandex.net db1m.so.yandex.net',
    'db_port'        => 27017,
    'errorsLogFile'  => 'WORKING_DIR/logs/db-cmpl-errors.log'
);
$SO::LogFile::defaultLogFile = $dbFbl{'errorsLogFile'};
$SO::MongoDatabase::defaultIniFile = $iniFilePath;
$SO::MongoDatabase::defaultIniFileSection = 'fbl';
my %dbCollection = (
    'logs'            => SO::MongoCollection->new('logs', 'fbl'),
    'different_suids' => SO::MongoCollection->new('different_suids', 'fbl'),
    'dates_info'      => SO::MongoCollection->new('dates_info', 'fbl')
);
$| = 1;
print $q->header(-type => 'application/json', -charset => 'utf-8');

my $datesFilter = {'$lte' => $endDate};
$$datesFilter{'$gte'} = `date --date='$datesPeriod days ago' +'%Y-%m-%d'`, chomp $$datesFilter{'$gte'} if $datesPeriod + 0 > 0;
my ($fbldata, $spamdata, $hamdata, $d) = ([], [], []);
my %datainfo = ('spam' => [], 'ham' => [], 'fbl' => []);
my (%fbl_total, %fbl_suids, $i); %fbl_total = (); %fbl_suids = ();
my @types = (qw(spam ham fbl));

$fbl_total{$$_{'_id'}} = $$_{'cnt'}
    foreach (@{$dbCollection{'logs'}->aggregateFull([
        {'$match' => {'spam_date' => $datesFilter}},
        {'$group' => {'_id' => '$spam_date', 'cnt' => {'$sum' => 1}}}
    ])});
$fbl_suids{$$_{'_id'}} = $$_{'cnt'}
    foreach (@{$dbCollection{'different_suids'}->aggregateFull([
        {'$match' => {'dt' => $datesFilter}},
        {'$group' => {'_id' => '$dt', 'cnt' => {'$sum' => 1}}}
    ])});
for ($i = 0; $i < @types; $i++) {
    push(@{$datainfo{$types[$i]}}, {
        'date'         => $$_{'dt'},
        'event_type'   => $$_{'event_type'},
        'event_text'   => $$_{'txt'},
        'info'         => $$_{'info'},
        'bg_color'     => $$_{'bg_color'},
        'fg_color'     => $$_{'fg_color'},
        'border_color' => $$_{'border_color'}
    }) foreach (sort {$$a{'dt'} cmp $$b{'dt'}} @{$dbCollection{'dates_info'}->get({'dt' => $datesFilter, 'type' => $i})});
}

$SO::LogFile::defaultLogFile = $dbCmpl{'errorsLogFile'};
$SO::MongoCollection::mongoDatabase = undef;
$SO::MongoDatabase::defaultIniFileSection = 'cmpl';
$dbCollection{'abuses_stat'} = SO::MongoCollection->new('abuses_stat', 'cmpl');

push(@$spamdata, {'date' => $$_{'_id'}, 'cnt' => $$_{'foo'}, 'suids_cnt' => $$_{'foo_uniq'}})
    foreach (sort {$$a{'_id'} cmp $$b{'_id'}} @{$dbCollection{'abuses_stat'}->get({'_id' => $datesFilter})});
push(@$hamdata, {'date' => $$_{'_id'}, 'cnt' => $$_{'antifoo'}, 'suids_cnt' => $$_{'antifoo_uniq'}})
    foreach (sort {$$a{'_id'} cmp $$b{'_id'}} @{$dbCollection{'abuses_stat'}->get({'_id' => $datesFilter})});

if (scalar keys %fbl_total > 0 && scalar keys %fbl_suids > 0) {
    push @$fbldata, {
        'date'      => $$_{'date'},
        'cnt'       => $fbl_total{$$_{'date'}} || 0,
        'suids_cnt' => $fbl_suids{$$_{'date'}} || 0
    } foreach (@$spamdata);
}

print encode_json({
    'spamdata'     => $spamdata,
    'hamdata'      => $hamdata,
    'fbldata'      => $fbldata,
    'spamdatainfo' => $datainfo{'spam'},
    'hamdatainfo'  => $datainfo{'ham'},
    'fbldatainfo'  => $datainfo{'fbl'},
    'errordata'    => join('', map {$dbCollection{$_}{'lastError'} || ''} qw(logs different_suids dates_info abuses_stat))
});
