#!/usr/bin/perl -w
# -*- Encoding: utf-8; Mode: cperl -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
use strict;
use warnings;
use CGI;
use CGI::Carp qw(carpout fatalsToBrowser set_message);

BEGIN { push @INC, 'WORKING_DIR', 'WORKING_DIR/SO'; }
use SO::MongoCollection;
use SO::IniFile qw(loadIni);
use SO::LogFile;

my ($q, $cfg, $iniFilePath) = (CGI->new(), {}, 'WORKING_DIR/so-complaints-fcgi-server.ini');
writeLog("Unable to locate configuration file '$iniFilePath'"), exit 1 unless -e $iniFilePath and -f $iniFilePath;
$SO::LogFile::defaultLogFile = $$cfg{'errorsLogFile'} || 'WORKING_DIR/logs/web-errors.log';
$SO::MongoDatabase::defaultIniFile = $iniFilePath;

my $iniFile = SO::IniFile->new($iniFilePath);
$iniFile->loadIni($cfg, 'fbl-out');
my %dbCollections = eval {(
    'sender_domains'  => SO::MongoCollection->new('sender_domains', 'domains'),
    'strange_domains' => SO::MongoCollection->new('strange_domains', 'domains'),
    'settings'        => SO::MongoCollection->new('settings', 'domains')
)};

print $q->header(-type => 'text/html', -charset => 'utf-8');
print $q->start_html(-title => 'Complainants\' domains', -script => <<EOS, -head => '<link rel="shortcut icon" href="/images/favicon.ico" />');
    function ChangeTopDomain() {
        var domains = document.getElementById('domains');
        if (domains && domains.value != '') {
            var top_domain = document.getElementById('top_domain');
            if (top_domain) top_domain.value = domains.value;
            domainsform.submit();
        }
    }
    function onCustomDomain(d) {
        var isregexp = document.getElementById('isregexp');
        if (isregexp) {
            isregexp.value = d ? (d.toString().match(/[^a-z0-9\.-]/) ? '(задано регулярное выражение для поиска домена)' : '') :
                                '(пожалуйста, задайте непустую строку (или регулярное выражение) для поиска домена)';
            isregexp.innerHTML = isregexp.value;
            domainsform.submit();
        }
    }
EOS
my ($top_domain, $isregexp) = ($q->param('top_domain') || 'mail.ru', $q->param('isregexp') || '');
my ($customdomain, $proto) = ($q->param('customdomain') || '', 'http'.($ENV{'HTTPS'} ? 's' : ''));
print qq{<table width=100%><tr><td style="width: 20em;"><img width=90 height=90 src="/images/sign_so.gif"><a href="$proto://}.$ENV{'HTTP_HOST'}.'/internal/"><img src="/images/logo.gif"></a></td>';
print '<td style="text-align: left;">', $q->h2('Complainants\' domains');
print $q->start_form(-method => 'POST', -id => 'domainsform');
print $q->hidden(-name => 'top_domain', -id => 'top_domain', -default => $top_domain);

my @top_domains = $dbCollections{'sender_domains'}->get({}, '_id.top_domain', 1);
print 'Domain:&nbsp;&nbsp;'.$q->popup_menu(-name => 'domains', -id => 'domains', -values => [@top_domains], -default => $top_domain, -onChange => 'ChangeTopDomain()');
print '&nbsp;&nbsp;Domain search string:&nbsp;&nbsp;'.$q->textfield(-name => 'customdomain', -id => 'customdomain', -rows => 1, -cols => 80, -value => '', -onChange => 'onCustomDomain(this.value);');
print "<span id='isregexp'>$isregexp</span>", $q->br x 2;
print '</td></tr></table>', $q->br;
if ($top_domain) {
    my @sub_domains = $dbCollections{'sender_domains'}->get({'_id.top_domain' => $top_domain}, '_id.sub_domain', 1);
    my @custom_domains = ();
    if ($customdomain) {
        my $d1 = $dbCollections{'sender_domains'}->find({'_id.sub_domain' => {'$regex' => qr/$customdomain/i}}, 'sub_domain');
        my $d2 = $dbCollections{'strange_domains'}->find({'_id.sub_domain' => {'$regex' => qr/$customdomain/i}}, 'sub_domain');
        @custom_domains = sort (keys %$d1, keys %$d2)
    }
    print '<table cellspacing="0" cellpadding="2" border="1" style="margin-left: 20em;"><tr><td><i>Detected '.(scalar @sub_domains).' subdomains for '.$top_domain.'</i></td><td>';
    print '<i>Detected '.(scalar @custom_domains).' subdomains for search string "'.($customdomain || '&nbsp;').'"</i>';
    print '</td></tr><tr style="vertical-align: top;"><td>', $q->br;
    print $_, $q->br foreach (@sub_domains);
    print '</td><td>', $q->br;
    print $_, $q->br foreach (@custom_domains);
    print '</td></tr></table>';
}
print $q->end_form, $q->end_html;
