function UiMessaging(errorModal, okToast) {
    this.errorModal = $(errorModal);
    this.errorModalText = this.errorModal.find('.modal-body');
    this.okToast = $(okToast);
    this.okToastText = this.okToast.find('.toast-body');
    this.okToastDate = this.okToast.find('.toast-date');
}

UiMessaging.prototype.ErrorCb = function () {
    return (text) => {
        this.errorModalText.text(text.toString());
        this.errorModal.modal('show');
    };
};

UiMessaging.prototype.Error = function (text) {
    this.ErrorCb()(text);
};

UiMessaging.prototype.SuccessCb = function () {
    return (text) => {
        this.okToastText.text(text || "Ok");
        this.okToastDate.text(new Date().toString());
        this.okToast.toast('show');
    };
};

UiMessaging.prototype.Success = function (text) {
    this.SuccessCb()(text);
};
