from django.conf import settings
from django.conf.urls import static
from django.urls import path, include

from . import views

app_label = 'complshingler_ui'

urlpatterns = [
    path('ban_shingles', views.ComplView.as_view(), name='complshingler'),
    path('unban', views.UnbanView.as_view(), name='unban'),
    path('ban_shingles/shingles', views.request_shingles, name='ban_shingles.shingles'),
    path('ban_shingles/fetch_user_weights', views.fetch_user_weights, name='ban_shingles.fetch_user_weights'),
    path('ban_shingles/weights', views.set_weights, name='ban_shingles.weights'),
    path('unban/shingles', views.request_shingles, name='unban.shingles'),
    path('unban/weights', views.set_weights, name='unban.weights'),
    path(r'idm/', include('django_idm_api.urls'))]

urlpatterns += static.static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
