# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
# import os.path
import sys

from library.python.django.utils import patch_settings_for_arcadia

PROJECT_PATH = '{arcadia_path}'.format(arcadia_path=os.getenv('ARCADIA_PATH'))
ALLOWED_HOSTS = ['web.so.yandex-team.ru', 'so-web.n.yandex-team.ru']

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.getenv('DB_PATH')
    }
}

SOSEARCH_HOST = os.getenv('SOSEARCH_HOST', "http://sosearch-proxy.mail.yandex.net:80")
SOSEARCH_TIMEOUT = int(os.getenv('SOSEARCH_TIMEOUT', 1))

DEBUG = int((os.getenv('DEBUG', 0)))
if DEBUG:
    ALLOWED_HOSTS += ['.localhost', '127.0.0.1', '[::1]']
IDM_INSTANCE = 'testing' if DEBUG else 'production'

ROOT_URLCONF = 'mail.so.spamstop.web.complshingler.complshingler_app.urls'

REST_FRAMEWORK = {
    'DEFAULT_PAGINATION_CLASS': 'rest_framework.pagination.PageNumberPagination',
    'PAGE_SIZE': 10
}

SECRET_KEY = 'foo'
STATIC_URL = '/static/'
STATIC_ROOT = 'static'
STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder'
]

STATICFILES_DIRS = [
    os.path.join(PROJECT_PATH, 'static')
]

FIXTURE_DIRS = ['common_fixtures']

TEMPLATES = [
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': True,
            'loaders': [
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ],
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    }
]

INSTALLED_APPS = [
    'mail.so.spamstop.web.complshingler.complshingler_app',
    'rest_framework',
    'django_idm_api',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
]

LOG_FORMAT = os.environ.get('QLOUD_LOGGER_STDOUT_PARSER', 'default')

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
    },
    'handlers': {
        'stdout': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stdout,
        },
        'stderr': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stderr,
        },
    },
    'loggers': {
        '': {
            'handlers': ['stderr'],
            'propagate': False,
            'level': 'WARNING',
        },
        'requests': {
            'handlers': ['stdout'],
            'propagate': False,
            'level': 'INFO',
        },
        'django': {
            'handlers': ['stdout'],
            'propagate': False,
            'level': 'WARNING',
        },
    },
    'root': {
        'handlers': ['stdout'],
        'level': 'INFO',
    },
}

TVM_ID = os.environ.get("TVM_ID")
TVM_SECRET = os.environ.get("TVM_SECRET")
SENDERS_TVM_ID = os.environ.get("SENDERS_TVM_ID")

patch_settings_for_arcadia()
