#!/bin/bash
set -ex

RULES_TYPE="$1"
SECRET_DIR="$(echo $RULES_TYPE | tr '[a-z]' '[A-Z]')_SECRET"
RULES_TAR="${RULES_TYPE}.tar.gz"
RULES_TAR_ENC="$RULES_TAR.enc"

rm -rf $RULES_TAR
rm -rf $RULES_TYPE

openssl aes-256-cbc -d -pass "file:$SECRET_DIR/aes-256-key" -in $RULES_TAR_ENC -out $RULES_TAR
mkdir -p $RULES_TYPE
tar xf $RULES_TAR --directory $RULES_TYPE
