#!/bin/bash
ROTATE_DAYS=${1:-2}
LOGS=(
"/logs/so-auxiliary-web.log 1"
"/logs/so-fbl-out.log 1"
"/logs/so-imapchick-ui.log"
"/logs/so-ml-ui.log"
"/logs/so-ml-web.log"
"/logs/so-ml.log"
"/logs/so-plotnik-ui.log"
"/logs/so-uwsgi.log"
"/logs/so-web.log 2"
"/logs/cron-scripts.log"
"/logs/so-web-stat.log 1"
)

for log in "${LOGS[@]}"; do
  set -- $log
  for i in $(seq ${2:-$ROTATE_DAYS} -1 1); do
    [ -f $1.$i ] && mv -f $1.$i $1.`expr $i + 1` 2>/dev/null
  done
  [ -f $1 ] && mv $1 $1.1
  touch $1
  chmod 0666 $1
done

# Reload services, when logs rotated
/bin/kill $(cat pids/so_web)
