#!/bin/bash
set -ex

echo 'PREPARING OF SO_WEB: START'
# View of all input env vars
env

source so_web_config.sh

substitute_vars() {
    local file_path=$1
    for v in $(grep -ohE '\$\(\w+\)' $file_path | grep -ohE '\w+' | sort -u); do
        [ -z "$v" ] && continue
        eval val=\$$v
        sed -i "s#\$($v)#$val#g" $file_path
    done
}

# preparing of folders & files
mkdir -p pids
mkdir -p logs
mkdir -p temp/check_rules
mkdir -p nginx_temp/body/issconfig
mkdir -p nginx_temp/proxy
mkdir -p nginx_temp/cache
mkdir -p nginx_temp/temp
mkdir -p nginx_temp/fastcgi
mkdir -p nginx_temp/uwsgi
mkdir -p nginx_temp/scgi
mkdir -p .mongodb
mkdir -p .pgsql
mkdir -p .config/git
mkdir -p .local
mkdir -p .cache

export LANG=ru_RU.utf8
tar xvf ./so-web.tar.gz
tar xvf ./complshingler.tar.gz
tar xvf ./so-web-django-ui.tar.gz
tar xf ./openjdk.tar.xz
chmod +x web/*.py

[ ! -e "/usr/local/www/logs" ] && ln -s /logs /usr/local/www/logs
[ ! -e "./Reader" ] && ln -s ./reader/pack/Reader
find nginx_temp/ -type d | xargs -n 1 chmod 777 || true

touch logs/error.log
chmod 666 logs/error.log
touch logs/access.log
chmod 666 logs/access.log
touch /usr/local/www/logs/current-nginx-${BSCONFIG_IPORT}-access.log
chmod 666 /usr/local/www/logs/current-nginx-${BSCONFIG_IPORT}-access.log
touch /usr/local/www/logs/current-nginx-${BSCONFIG_IPORT}-error.log
chmod 666 /usr/local/www/logs/current-nginx-${BSCONFIG_IPORT}-error.log
touch /logs/current-nginx-so-fbl-out-access.log
chmod 666 /logs/current-nginx-so-fbl-out-access.log
touch /logs/current-nginx-so-fbl-out-error.log
chmod 666 /logs/current-nginx-so-fbl-out-error.log
touch /logs/current-fbl-out-errors.log
chmod 666 /logs/current-fbl-out-errors.log
touch /logs/current-fbl-out.log
chmod 666 /logs/current-fbl-out.log
touch /logs/current-nginx-so-special-labels-access.log
chmod 666 /logs/current-nginx-so-special-labels-access.log
touch /logs/current-nginx-so-special-labels-error.log
chmod 666 /logs/current-nginx-so-special-labels-error.log
touch /logs/current-special-labels-errors.log
chmod 666 /logs/current-special-labels-errors.log
touch /usr/local/www/logs/current-nginx-so-ml-${BSCONFIG_IPORT}-access.log
chmod 666 /usr/local/www/logs/current-nginx-so-ml-${BSCONFIG_IPORT}-access.log
touch /usr/local/www/logs/current-nginx-so-ml-${BSCONFIG_IPORT}-error.log
chmod 666 /usr/local/www/logs/current-nginx-so-ml-${BSCONFIG_IPORT}-error.log
touch /usr/local/www/logs/current-nginx-so-auxiliary-${BSCONFIG_IPORT}-access.log
chmod 666 /usr/local/www/logs/current-nginx-so-auxiliary-${BSCONFIG_IPORT}-access.log
touch /usr/local/www/logs/current-nginx-so-auxiliary-${BSCONFIG_IPORT}-error.log
chmod 666 /usr/local/www/logs/current-nginx-so-auxiliary-${BSCONFIG_IPORT}-error.log
touch /usr/local/www/logs/current-nginx-so-plotnik-${BSCONFIG_IPORT}-access.log
chmod 666 /usr/local/www/logs/current-nginx-so-plotnik-${BSCONFIG_IPORT}-access.log
touch /usr/local/www/logs/current-nginx-so-plotnik-${BSCONFIG_IPORT}-error.log
chmod 666 /usr/local/www/logs/current-nginx-so-plotnik-${BSCONFIG_IPORT}-error.log
touch /usr/local/www/logs/current-nginx-so-web-${BSCONFIG_IPORT}-access.log
chmod 666 /usr/local/www/logs/current-nginx-so-web-${BSCONFIG_IPORT}-access.log
touch /usr/local/www/logs/current-nginx-so-web-${BSCONFIG_IPORT}-error.log
chmod 666 /usr/local/www/logs/current-nginx-so-web-${BSCONFIG_IPORT}-error.log

# preparing of rules
for rules_type in $SO_RULES_DIR $AF_RULES_DIR; do
    if [ -e "${rules_type}.tar.gz.enc" ]; then
        ./decode-unpack-rules.sh $rules_type
        mkdir -p "${rules_type}_checked"
        cp -rf ${rules_type}/* ${rules_type}_checked/
    else
        echo "Failed to find resource ${rules_type}.tar.gz.enc!"
        exit 1
    fi
done
echo "ssh -i ${BSCONFIG_IDIR}/rules-key/id_rsa -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no \$*" > ssh-rules.sh
chmod +x ssh-rules.sh
export GIT_SSH="${BSCONFIG_IDIR}/ssh-rules.sh"

# substituting of vars
sed -i "s#WORKING_DIR#${BSCONFIG_IDIR}#g" ./web/*.pl ./web/*.py ./cron/*.py ./cron/*/*.py ./cron/*/*.ini
sed -i "s#WORKING_DIR#${BSCONFIG_IDIR}#g" ./web/*/*.py ./web/*/*.pl ./web/*/*.ini ./web/hooks/*.sh
sed -i "s#WORKING_DIR#${BSCONFIG_IDIR}#g" ./*.ini ./SO/*.pm ./SO/Mail/*.pm
sed -i "s#WORKING_DIR#${BSCONFIG_IDIR}#g" ./so-ml/*.ini ./so-ml/*.py ./so-web/*.ini ./so-web/*.py
sed -i "s#WORKING_DIR#${BSCONFIG_IDIR}#g" ./so-auxiliary/*.ini ./so-auxiliary/*.py
sed -i "s#WORKING_DIR#${BSCONFIG_IDIR}#g" ./so-plotnik-ui/*.ini ./so-plotnik-ui/*.py
sed -i "s#WORKING_DIR#${BSCONFIG_IDIR}#g" ./so-imapchick-ui/*.ini ./so-imapchick-ui/*.py
sed -i "s#WORKING_DIR#${BSCONFIG_IDIR}#g" ./so-fbl-out/*.ini ./so-fbl-out/*.py
sed -i "s#WORKING_DIR#${BSCONFIG_IDIR}#g" ./so-special-labels/*.ini ./so-special-labels/*.py
for file_path in nginx.conf; do
    cp "${BSCONFIG_IDIR}/${file_path}.template" "${BSCONFIG_IDIR}/$file_path"
    # walk through all referenced vars and substitute by its values
    substitute_vars $file_path
done

# preparing of secrets
[ ! -e "./.pgpass.plotnik" ] && ln -s so-plotnik-db/pass .pgpass.plotnik
[ ! -e "./.pgpass.complaints" ] && ln -s so-complaints-db/pass .pgpass.complaints
[ ! -e "./.pgpass.rules" ] && ln -s so-rules-db/pass .pgpass.rules
[ ! -e "./.pgpass.psndr" ] && ln -s so-psndr-db/pass .pgpass.psndr
[ ! -e "./.pgpass.so_frodo_stat" ] && ln -s so-frodo-stat-db/pass .pgpass.so_frodo_stat
[ ! -e "./.pgpass.pl" ] && ln -s so-actdb/pass .pgpass.pl
[ ! -e "./.pgpass.web-tools-ui" ] && ln -s so-web-tools-ui/passwd .pgpass.web-tools-ui
[ ! -e "./.redis.users_stat" ] && ln -s so-users-stat-db/pass .redis.users_stat
[ ! -e "./.redis.imapchick" ] && ln -s so-imapchick-db/pass .redis.imapchick
[ ! -e "./.mongodb.so_ml" ] && ln -s so-ml-db/pass .mongodb.so_ml
[ ! -e "./.mongodb.solog" ] && ln -s solog-db/pass .mongodb.solog
[ ! -e "./.mongodb.rules" ] && ln -s so-rules-mongodb/pass .mongodb.rules
[ ! -e "./.mongodb.cmpl" ] && ln -s so-cmpl-db/pass .mongodb.cmpl
[ ! -e "./.mongodb.journal" ] && ln -s so-journal-db/pass .mongodb.journal
[ ! -e "./.app_token" ] && ln -s so-robot-mailspam-app/token .app_token
[ ! -e "./.conductor_token" ] && ln -s so-robot-mailspam-conductor/token .conductor_token
[ ! -e "./.yt_token" ] && ln -s so-robot-mailspam-yt/token .yt_token
[ ! -e "./.passport_adminka_token" ] && ln -s so-robot-mailspam-passport-adminka/token .passport_adminka_token
[ ! -e "./.mongodb/allCAs.pem" ] && cp so-allcas/cert .mongodb/allCAs.pem
[ ! -e "./.pgsql/root.crt" ] && cp so-allcas/cert .pgsql/root.crt
[ ! -e "./.tvm2.token" ] && cp so-web-tvm/token .tvm2.token

# all other operations
touch /logs/so-uwsgi.log /logs/so-ml.log /logs/so-ml-web.log /logs/so-ml-ui.log /logs/so-web.log /logs/so-web-stat.log /logs/so-auxiliary-web.log /logs/so-plotnik-ui.log /logs/so-imapchick-ui.log /state/logrotate /logs/compldlv_yt.log
chmod 666 /logs/so-uwsgi.log /logs/so-ml.log /logs/so-ml-web.log /logs/so-ml-ui.log /logs/so-web.log /logs/so-web-stat.log /logs/so-auxiliary-web.log /logs/so-plotnik-ui.log /logs/so-imapchick-ui.log /state/logrotate
rm -rf ./static
rm -rf ./web_tools_static

DB_PATH="/state/db.sqlte" ./complshingler_manage collectstatic -c --noinput
DB_PATH="/state/db.sqlte" ./complshingler_manage migrate

export DB_SECRET_FILE="./.pgpass.web-tools-ui"
[ -e "$DB_SECRET_FILE" ] && [ -f "$DB_SECRET_FILE" ] && export DB_PASSWORD=$(cat $DB_SECRET_FILE)

./web_tools_manage collectstatic -c --noinput
./web_tools_manage migrate

cd web_tools_static
ln -s images/favicon.ico
cd ..

echo 'PREPARING OF SO_WEB: END'
