#!/bin/bash

source so_web_config.sh

export DB_SECRET_FILE="./.pgpass.web-tools-ui"
[ -e "$DB_SECRET_FILE" ] && [ -f "$DB_SECRET_FILE" ] && export DB_PASSWORD=$(cat $DB_SECRET_FILE)

./web_tools_ui \
    --bind=unix:pids/web_tools_ui.sock \
    --pid=pids/web_tools_ui.pid \
    --access-logfile ${LOG_PATH} \
    --error-logfile ${LOG_PATH} \
    --log-level debug \
    --capture-output \
    --workers=8 \
    --limit-request-line 8190 \
    --limit-request-field_size 0 \
    --keep-alive 70 \
    --timeout 180 \
    mail.so.spamstop.web.ui.cmd.wsgi.app
