#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, time, types
sys.path.insert(0, 'WORKING_DIR')
from cron.tab import CronTab
from web.common import CFG
from web.log_utils import writelog
from web.db_utils import loadMongoDbCredentials, getMongoDB, getPGCredentials, getPGdb, getRedisCredentials, redisReconnect


CFG['logfile'] = '/logs/cron-scripts.log'


def getDbConnection(db_config, db_mode='read-write'):
    if db_mode is None:
        db_mode = 'read-write'
    db_type = (db_config["db_type"] if "db_type" in db_config and db_config["db_type"] else '').lower()
    if db_type == "maas" or db_type.startswith("mongo"):
        if "user" in db_config and "passwd" not in db_config:
            loadMongoDbCredentials(db_config)
        return getMongoDB(db_config, db_mode)
    elif db_type == "redis":
        getRedisCredentials(db_config)
        return redisReconnect(db_config, db_mode)
    else:
        if "user" in db_config and "password" not in db_config:
            getPGCredentials(db_config)
        return getPGdb(db_config, db_mode)


def startScript(db_conn, script_name, subfolder):
    task, update_res, script_info, t, p, n = None, [], [], time.time(), 0, 0
    try:
        pg_cursor = db_conn.cursor()
        pg_cursor.execute("SELECT EXTRACT(EPOCH FROM last_start_ts), EXTRACT(EPOCH FROM last_end_ts), cron_expr, options FROM cron_scripts WHERE id = '%s'" % script_name)
        script_info = pg_cursor.fetchall()
        pg_cursor.close()
    except Exception, e:
        writelog("Attempt to start script '%s' failed: %s" % (script_name, str(e)), True)
    for script_instance_info in script_info:
        if script_instance_info and len(script_instance_info) == 4:
            cron = CronTab(script_instance_info[2])
            p, n = cron.previous(t, default_utc=False), cron.next(t, default_utc=False)
            if script_instance_info[0] is not None and (script_instance_info[1] is None or script_instance_info[0] > script_instance_info[1] and script_instance_info[0] >= t - n + p or script_instance_info[1] >= t + p):
                if script_instance_info[1] < t + p:
                    writelog("Attempt to start cron script '%s': another script's instance already running or finished!" % script_name)
                continue
        else:
            writelog("DB error while attempt to start cron script '%s'" % script_name)
            continue
        try:
            pg_cursor = db_conn.cursor()
            pg_cursor.execute("""UPDATE cron_scripts SET last_start_ts = to_timestamp(%s) WHERE id = %s AND cron_expr = %s AND (last_start_ts IS NULL OR last_end_ts IS NOT NULL AND (last_start_ts <= last_end_ts OR
                            last_start_ts < to_timestamp(%s)) AND last_end_ts < to_timestamp(%s)) RETURNING last_start_ts, last_end_ts""", (t, script_name, script_instance_info[2], t - n + p, t + p))
            db_conn.commit()
            update_res = pg_cursor.fetchone()
            pg_cursor.close()
        except Exception, e:
            writelog("Attempt to start cron script '%s' with cron task '%s' failed: %s" % (script_name, script_instance_info[2], str(e)), True)
            continue
        if not update_res or len(update_res) < 1:
            writelog("Attempt to start cron script '%s' with cron task '%s' canceled: another script's instance already running or finished!" % (script_name, script_instance_info[2]))
            continue
        options = dict(map(lambda op: op.split('='), script_instance_info[3].split()))
        _temp = __import__('cron.%s%s' % ('{0}.'.format(subfolder) if subfolder else '', script_name), globals(), locals(), ['run_task'], -1)
        if isinstance(_temp.run_task, types.ClassType) or isinstance(_temp.run_task, types.TypeType) or isinstance(_temp.run_task, types.InstanceType):
            if callable(_temp.run_task):
                task = _temp.run_task()
            else:
                writelog("Wrong definition of run_task() callable in cron script '%s'!" % script_name)
        elif isinstance(_temp.run_task, types.FunctionType) or isinstance(_temp.run_task, types.LambdaType) or isinstance(_temp.run_task, types.LambdaType) or isinstance(_temp.run_task, types.BuiltinFunctionType):
            task = _temp.run_task
        if task:
            writelog("Cron script '%s%s' started" % ('{0}/'.format(subfolder) if subfolder else '', script_name))
            yield [task, options, script_instance_info[2]]
        else:
            writelog("Unable find or load task: %s%s" % ('{0}/'.format(subfolder) if subfolder else '', script_name))


def runScript(db_conn, db_config, task = None, options = {}):
    db_mode = getattr(task, 'db_mode') if task and hasattr(task, 'db_mode') else None
    if task:
        task(db_conn if db_mode is None else getDbConnection(db_config, db_mode), writelog, **options)


def endScript(db_conn, script_name, subfolder, cron_expr):
    try:
        db_cursor = db_conn.cursor()
        db_cursor.execute("UPDATE cron_scripts SET last_end_ts = to_timestamp(%s) WHERE id = %s AND cron_expr = %s", (time.time(), script_name, cron_expr))
        db_conn.commit()
        db_cursor.close()
    except Exception, e:
        writelog("Attempt to finalize cron script '%s': error while saving last_end_ts: %s" % (script_name, str(e)), True)
    writelog("Cron script '%s%s' done" % ('{0}/'.format(subfolder) if subfolder else '', script_name))
