#!/usr/bin/env python
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import sys, string, email.message
sys.path.insert(0, 'WORKING_DIR/web')
from datetime import datetime, date, timedelta
from collections import defaultdict
from cron.common import getDbConnection
from web.common import CFG
from web.log_utils import writelog
from web.email_utils import sendEmail


MONGO = {
    'db_type': 'mongodb',
    'cluster': 'mail_so_813',
    'hosts':   'compldb1m.so.yandex.net,compldb1j.so.yandex.net,compldb1o.so.yandex.net',
    'port':    27017,
    'db':      'imap'
}
REDIS = {
    'db_type':       'redis',
    "cluster_name":  'imapchick',
    "hosts":         ['sas-9hj1mqfnn09ivo2p.db.yandex.net', 'vla-lypu9dngze8qheim.db.yandex.net'],
    "port":          6379,
    "sentinel_port": 26379,
    "db":            0,
    "timeout":       30.0,
    "auth":          True
}
DATE = (date.today() + timedelta(days = -1)).isoformat()

def printDayTop(day):
    count_total = 0
    txt = "<div width='100%' align='center'><table cellspacing='0' cellpadding='5' border='1'>\n"
    txt += "<thead><tr><th style='width:10em;'>Count</th><th>Folder</th></tr></thead>\n"
    for foldertitle, count in sorted(day.iteritems(), key = lambda (k, v): v, reverse = True):
        count_total += count
        if count > 0:
            txt += "<tr><td style='text-align:right;'>%d</td><td>%s</td></tr>\n" % (count, foldertitle)
    txt += "<tr><td style='text-align:right;'>Total:</td><td>%d</td></tr>\n" % count_total
    txt += "</table></div><br />\n"
    return txt

def printTotalTop(total, cnt = 20):
    txt = "<div width='100%' align='center'><table cellspacing='0' cellpadding='5' border='1'>\n"
    txt += "<thead><tr><th style='width:10em;'>Count</th><th>Folder</th></tr></thead>\n"
    for foldertitle, count in sorted(total.iteritems(), key = lambda (k, v): v, reverse = True)[:cnt]:
        txt += "<tr><td style='text-align:right;'>%d</td><td>%s</td></tr>\n" % (count, foldertitle)
    txt += "</table></div>\n"
    return txt

def run_task(pg, writelog = writelog):
    redis_db, mongo_db = getDbConnection(REDIS), getDbConnection(MONGO)
    today = datetime.today()
    yesterday = today - timedelta(days = 1)
    total, day, txt = defaultdict(int), defaultdict(int), "<html>\n<body>\n<h3 align='center'>Object-813</h3>\n"
    t1, t2 = yesterday.strftime('%Y-%m-%d 00:00:00'), today.strftime('%Y-%m-%d 00:00:00')
    script = """
        local data = redis.call("get", KEYS[1])
        local cnt = 0
        for elem in string.gmatch(data, "[^\\n]+") do
            local date_str = string.match(elem, "cmpldate\\": \\"([0-9\\:\\ \\-]+)")
            if date_str >= ARGV[1] and date_str < ARGV[2] then cnt = cnt + 1 end
        end
        return cnt
        """
    for folder in mongo_db['folders'].find(sort=[('_id', 1)]):
        nmin, nmax = redis_db.hget('info', folder['_id'] + "_min_msgid"), redis_db.hget('info', folder['_id'] + "_max_msgid")
        nmin = int(nmin) if nmin else 0
        nmax = int(nmax) if nmax else 0
        total[folder['_id']] = nmax - nmin
        for key in sorted(redis_db.keys(folder['_id'] + '_*')):
            day[folder['_id']] += redis_db.eval(script, 1, key, t1, t2)
    txt += yesterday.strftime("<p align='center'><b>Complaints count for date %d-%m-%Y:</b></p>\n")
    txt += printDayTop(day)
    txt += "<p align='center'><b>TOP 20 folders by messages count:</b></p>\n"
    txt += printTotalTop(total)
    txt += "</body>\n</html>"
    msg = email.message.Message()
    msg['Content-Type'] = 'text/html'
    msg.set_payload(txt, 'utf-8')
    msg['From'] = CFG['robot']['name']
    msg['To'] = CFG['report']
    msg['Subject'] = '[%s] Abuse count' % DATE
    sendEmail(msg.as_string())
    writelog("Message has sended to '%s' successfully." % CFG['report'])

if __name__ == "__main__":
    CFG['logfile'] = 'WORKING_DIR/logs/cron-scripts.log'
    run_task(None, writelog)
