#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys
sys.path.insert(0, 'WORKING_DIR')
from tempfile import NamedTemporaryFile
from datetime import date, datetime, timedelta
from collections import defaultdict
from cron.common import getDbConnection
from web.common import CFG
from web.log_utils import writelog


PREFIX = "so.complfrictions"
CHUNK_SIZE = 10000


class run_task():
    db_mode = 'read-only'

    def __call__(self, pg, writelog = writelog, days_ago = 1):
        stat, self.days_ago = defaultdict(set), int(days_ago)
        midnight = int((datetime.today() - timedelta(days = self.days_ago - 1)).date().strftime("%s"))
        yesterday = int((datetime.today() - timedelta(days = self.days_ago)).date().strftime("%s"))
        try:
            pg_cursor = pg.cursor()
            pg_cursor.execute("SELECT source, foo, stid, uid FROM abuses WHERE cmpldata >= %s AND cmpldata < %s AND foo IN (0,1)", (yesterday, midnight))
            while True:
                n = 0
                for row in pg_cursor.fetchmany(CHUNK_SIZE):
                    n += 1
                    stat[(row[2], row[3])].add(row[1])
                    stat[(row[2], row[3])].add(row[0])
                if n == 0:
                    break
            pg_cursor.close()
        except Exception, e:
            writelog("DB exception: %s" % str(e), True)
        count = 0
        for key, value in stat.iteritems():
            if (0 in value) and (1 in value) and ("imap" in value):
                count += 1
        f = NamedTemporaryFile(dir = 'WORKING_DIR/temp', delete = True)
        print >> f, "%s.total" % PREFIX, "set_%d" % count, yesterday
        f.flush()
        os.system("WORKING_DIR/plotnik_collector.py -f %s" % f.name)
        f.close()

if __name__ == "__main__":
    from cron.complaints._config import CFG as PG
    CFG['logfile'], d = 'WORKING_DIR/logs/cron-scripts.log', 1
    try:
        cur_date = date.today()
        dt = sys.argv[1] if len(sys.argv) > 1 else cur_date.isoformat()
        d = (cur_date - datetime.strptime(dt, '%Y-%m-%d').date()).days
    except Exception, e:
        writelog("Exception: %s" % str(e), True)
    rt = run_task(getDbConnection(PG, 'read-only'), writelog, d)
    rt()
