#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys
sys.path.insert(0, 'WORKING_DIR')
from time import strftime
from cron.common import getDbConnection
from web.common import CFG
from web.log_utils import writelog


def run_task(pg, writelog = writelog):
    try:
        pg_cursor = pg.cursor()
        pg_cursor.execute("DELETE FROM abuses WHERE cmpldata < EXTRACT(EPOCH FROM (date '%s' - interval '1 year'))::int" % strftime("%Y-%m-%d"))
        pg.commit()
        pg_cursor.close()
    except Exception, e:
        writelog("DB exception: %s" % str(e), True)

if __name__ == "__main__":
    from cron.complaints._config import CFG as PG
    CFG['logfile'] = 'WORKING_DIR/logs/cron-scripts.log'
    run_task(getDbConnection(PG), writelog)
