#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re, time, bson.max_key
sys.path.insert(0, 'WORKING_DIR/web')
from datetime import date, timedelta
from bson.objectid import ObjectId
from cron.common import getDbConnection
from web.common import CFG
from web.log_utils import writelog
from web.db_utils import redisReconnect


MONGO = {
    'db_type': 'mongodb',
    'cluster': 'mail_so_813',
    'hosts':   'compldb1m.so.yandex.net,compldb1j.so.yandex.net,compldb1o.so.yandex.net',
    'port':    27017,
    'db':      'imap'
}
REDIS = {
    'db_type':       'redis',
    "cluster_name":  'imapchick',
    "hosts":         ['sas-9hj1mqfnn09ivo2p.db.yandex.net', 'vla-lypu9dngze8qheim.db.yandex.net'],
    "port":          6379,
    "sentinel_port": 26379,
    "db":            0,
    "timeout":       30.0,
    "auth":          True
}


def run_task(pg, writelog=writelog, script_name=''):
    script_path = "{0}/{1}".format(os.path.dirname(os.path.abspath(__file__)), script_name)
    if not script_name or not os.path.exists(script_path):
        writelog("Error: cleanup lua script is absent!")
        return
    f = open(script_path)
    script = f.read()
    f.close()
    redis_db, mongo_db = getDbConnection(REDIS), getDbConnection(MONGO)
    writelog("Cleanup DB for obsolete complaints [%s]:" % date.today())
    for key in sorted(redis_db.keys()):
        if key == 'info' or key == 'blocks': continue
        m = re.search(r'(\w+)_\d+', key)
        if not m or not m.group(1):
            writelog("Cleanup DB error: unable to determine folder name for block '%s'" % key)
            continue
        folder = m.group(1)
        writelog("Folder: %s (key: %s)" % (folder, key))
        folder_cfg = mongo_db['folders'].find_one({'_id': folder})
        if not folder_cfg:
            writelog("Cleanup DB error: unable to find settings for folder '%s' in DB" % folder)
            continue
        if 'dtl' not in folder_cfg: continue
        d = (date.today() - timedelta(folder_cfg['dtl'])).isoformat()
        sd, data = '%s 00:00:00' % d, []
        try:
            res = mongo_db.command("dropPartition", folder, max = {'time': sd, '_id': bson.max_key.MaxKey})
        except Exception, e:
            res = str(e)
        writelog("Drop partitions [older then %s] from '%s' (key: %s): %s" % (d, folder, key, res))
        try:
            data = redis_db.eval(script, 1, key, sd).split(',')
        except Exception, e:
            writelog("Redis DB query exception: %s" % str(e), True)
            try:
                redis_db = redisReconnect(REDIS)
            except Exception, e:
                writelog("Redis DB reconnect exception: %s" % str(e), True)
                continue
            data = redis_db.eval(script, 1, key, sd).split(',')
        for data_id in data:
            if data_id:
                try:
                    mongo_db[folder].remove({'_id': ObjectId(data_id)})
                except Exception, e:
                    writelog("Cleanup DB error: %s" % str(e), True)

if __name__ == "__main__":
    CFG['logfile'], script = 'WORKING_DIR/logs/cron-scripts.log', ''
    script_name = sys.argv[1] if len(sys.argv) > 1 else ''
    run_task(None, writelog, script_name=script_name)
