#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys
sys.path.insert(0, 'WORKING_DIR/web')
from datetime import datetime, date, timedelta
from cron.common import getDbConnection
from web.common import CFG
from web.log_utils import writelog


MONGO = {
    'db_type': 'mongodb',
    'cluster': 'mail_so_813',
    'hosts':   'compldb1m.so.yandex.net,compldb1j.so.yandex.net,compldb1o.so.yandex.net',
    'port':    27017,
    'db':      'imap'
}


def run_task(pg, writelog = writelog):
    db = getDbConnection(MONGO)
    d = datetime.today().strftime("[%Y-%m-%d %H:%M:%S]")
    writelog('Adding partition to partitioned collections %s:' % d)
    for collection in db.collection_names(False):
        if collection == 'folders':
            continue
        d = date.today() + timedelta(days=1)
        try:
            writelog("Add partition to %s: %s" % (collection, db.command("addPartition", collection, newMax = {'time': "%s 00:00:00" % d})))
        except Exception, e:
            writelog("Adding partition to %s failed: %s" % (collection, str(e)), True)
    writelog('[ Done ]')


if __name__ == "__main__":
    CFG['logfile'] = 'WORKING_DIR/logs/cron-scripts.log'
    run_task(None, writelog)

