#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys, time
sys.path.insert(0, 'WORKING_DIR')
from cron.common import getDbConnection
from web.common import CFG
from web.log_utils import writelog


def run_task(pg, writelog=writelog):
    try:
        pg_cursor = pg.cursor()
        pg_cursor.execute("SELECT id FROM abuses_stat WHERE foo_uniq = 0 AND id >= (date '%s' - interval '1 year')::date::text" % time.strftime("%Y-%m-%d"))
        for record in pg_cursor.fetchall():
            time_start = int(time.mktime(time.strptime(record[0], "%Y-%m-%d")))
            time_end = time_start + 86400
            if time_end > time.time():
                continue
            foo, antifoo = set(), set()
            pg_cursor.execute("SELECT foo, uid FROM abuses WHERE cmpldata >= %s AND cmpldata < %s", (time_start, time_end))
            for row in pg_cursor:
                footype = row[0]
                if footype == 0:
                    antifoo.add(row[1])
                elif footype == 1:
                    foo.add(row[1])
            pg_cursor.execute("UPDATE abuses_stat SET foo_uniq = %s, antifoo_uniq = %s WHERE id = %s", (len(foo), len(antifoo), record[0]))
            pg.commit()
            writelog("Update abuses_stat for date %s done" % record[0])
    except Exception, e:
        writelog("DB exception: %s" % str(e), True)


if __name__ == "__main__":
    from cron.complaints._config import CFG as PG
    CFG['logfile'] = 'WORKING_DIR/logs/cron-scripts.log'
    run_task(getDbConnection(PG), writelog)
