#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, time
sys.path.insert(0, 'WORKING_DIR')
#from cron.common import getDbConnection
from pymongo import DeleteOne
from multiprocessing.pool import Pool
from web.db_utils import loadMongoDbCredentials, getMongoDB
from web.log_utils import writelog
from web.rules_common import MONGO_RULES, RULES_DIRS


CURDIR = os.path.dirname(os.path.abspath(__file__))
DETAILED_RECORDS_TTL = 183 * 86400   # 183 days
BATCH_SIZE=10000


def cleanupRoute((route, batchCommands)):
    try:
        table = "detailed_Rules_%s" % route
        mongo = getMongoDB(MONGO_RULES)
        count = mongo[table].count()
        writelog("Proceeding with collection '%s': %s records" % (table, count))
        count = 0
        while True:
            res = mongo[table].bulk_write(batchCommands)
            if res and hasattr(res, 'deleted_count'):
                if res.deleted_count == 0:
                    break
                count += res.deleted_count
                writelog("Deleted %s records in collection '%s'" % (count, table))
            else:
                writelog("Deleting records in collection '%s' failed" % table)
                return False
    except Exception, e:
        writelog("DB exception (route=%s): %s" % (route, str(e)), True)
    return True


loadMongoDbCredentials(MONGO_RULES)
writelog("Mongo credentials: %s" % str(MONGO_RULES))

pool = Pool(len(RULES_DIRS))
minTs = int(time.time()) - DETAILED_RECORDS_TTL
n = 0
requests = [DeleteOne({'time': {'$lt': minTs}})] * BATCH_SIZE

for answer in pool.map(cleanupRoute, zip(RULES_DIRS.keys(), [requests] * len(RULES_DIRS))):
    n += 1

if n >= len(RULES_DIRS):
    pool.terminate()

writelog("DONE")

