#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re
sys.path.insert(0, 'WORKING_DIR/web')
import yt.wrapper as ytw
from datetime import date, timedelta
from subprocess import check_call
from common import CFG
from web.log_utils import writelog
from rules_common import RULES_TYPES, RULES_DIRS, pullRepo


YT_SEO_ABUSE_PATH = "//home/so_fml/seo_abuse"
YT_SEO_ABUSE_FOLDER = "//home/so_fml/seo-abuse"
YT_PROXY = 'hahn.yt.yandex.net'
RULES_REPO_FOLDER = RULES_DIRS['In'][0]


def loadYTCredentials():
    try:
        if os.path.exists('WORKING_DIR/.yt_token'):
            f = open('WORKING_DIR/.yt_token')
            ytw.config['token'] = f.read().strip()
            f.close()
    except Exception, e:
        writelog("loadYTCredentials error: %s" % str(e), True)


def run_task(pg, writelog=writelog):
    seo_abuse, i = [], 0
    pullRepo(RULES_REPO_FOLDER)
    f = open(RULES_REPO_FOLDER + "seo_abuse_u.roll")
    yesterday, days90_ago = (date.today() - timedelta(days=1)).isoformat(), (date.today() - timedelta(days=90)).isoformat()
    two_days_ago, three_days_ago = (date.today() - timedelta(days=2)).isoformat(), (date.today() - timedelta(days=3)).isoformat()
    two_days_ago, three_days_ago = "%s/%s" % (YT_SEO_ABUSE_FOLDER, two_days_ago), "%s/%s" % (YT_SEO_ABUSE_FOLDER, three_days_ago)
    for line in f:
        if re.match(r'^\s*$', line) or re.match(r'^#', line):
            continue
        seo_abuse.append({'num': i, 'uid': line.strip(), 'date': yesterday}); i += 1
    f.close()
    try:
        ytw.config['proxy']['url'] = YT_PROXY
        loadYTCredentials()
        if not ytw.exists(two_days_ago) and ytw.exists(three_days_ago):
            ytw.copy(three_days_ago, two_days_ago)
        if ytw.exists(YT_SEO_ABUSE_PATH):
            ytw.remove(YT_SEO_ABUSE_PATH)
        ytw.write_table(YT_SEO_ABUSE_PATH, seo_abuse, format = ytw.YsonFormat(), raw = False)
        ytw.write_table("%s/%s" % (YT_SEO_ABUSE_FOLDER, yesterday), seo_abuse, format = ytw.YsonFormat(), raw = False)
        yt_map = ytw.get(YT_SEO_ABUSE_FOLDER, attributes = ['modification_time', 'type'])
        for table in yt_map.keys():
            if table < days90_ago:
                ytw.remove("%s/%s" % (YT_SEO_ABUSE_FOLDER, table), force = True)
    except ytw.errors.YtError, e:
        writelog("YT error: %s" % str(e), True)


if __name__ == "__main__":
    CFG['logfile'] = '/logs/cron-scripts.log'
    run_task(None, writelog)
