#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, ConfigParser, time
sys.path.insert(0, 'WORKING_DIR')
from email.mime.text import MIMEText
from datetime import date, timedelta
from collections import defaultdict
from cron.common import getDbConnection
from web.common import CFG
from web.log_utils import writelog
from web.email_utils import sendEmail
from web.rules_common import RULES_TYPES, RULE_PARAM, MONGO_RULES, getRulesMonitoringInfo, time2str


CURDIR = os.path.dirname(os.path.abspath(__file__))
specRules = {
    'In':  'VER_130507',
    'Out': 'VER_SMTP130314'
}


class run_task():
    db_mode = 'read-only'

    def __call__(self, pg, writelog=writelog, period='10min', email_address='so-alerts@yandex-team.ru'):
        cfg = ConfigParser.SafeConfigParser()
        cfg.optionxform = str
        cfg_file = sys.argv[3] if len(sys.argv) > 3 else '%s/so-monrules.ini' % CURDIR
        cfg.read(cfg_file)

        match, res = {}, defaultdict(lambda: defaultdict(lambda: defaultdict(dict)))
        if period == 'daily':
            match['date'] = (date.today() - timedelta(days=1)).isoformat()
        else:
            match['time'] = int(time.time() // 600 - 1) * 600;

        db, txt = None, ''
        try:
            db = getDbConnection(MONGO_RULES)
        except Exception, e:
            writelog("DB exception while connection creation: %s" % str(e), True)
        for route in map(lambda rt: rt[0], RULES_TYPES):
            try:
                dbCollection = db['{0}Rules_{1}'.format('' if period == 'daily' else 'detailed_', route)]
                rules = getRulesMonitoringInfo('', route, 'on')
                if not rules:
                    continue
                if period == '10min' and cfg.has_option('general', "min{0}Msgs_10min".format(route)) and route in specRules:
                    r = {}
                    for row in dbCollection.aggregate([{'$match': {'rule': specRules[route], 'time': match['time']}}, {'$group': {
                        '_id':   '$time',
                        'total': {'$sum': {'$add': [{'$ifNull': ['$R1', 0]}, {'$ifNull': ['$R2', 0]}, {'$ifNull': ['$R4', 0]},
                            {'$ifNull': ['$R8', 0]}, {'$ifNull': ['$R127', 0]}, {'$ifNull': ['$R256', 0]}]}}
                    }}]):
                            r = row
                    if not r or 'total' not in r or not r['total'] or r['total'] < cfg.get('general', "min{0}Msgs_10min".format(route)):
                        if r and 'total' in r and r['total']:
                            writelog("Count of parsed messages' blocks of delivery-log is too small for '%s' mail: %s" % (route, r['total']))
                        continue
                h = {
                    '_id':   '$' + ('daily' if period == 'daily' else 'time'),
                    'malic': {'$sum': '$R256'},
                    'spam':  {'$sum': '$R4'}
                }
                if route[:2] == 'So':
                    h['ham']         = {'$sum': '$R1'};
                    h['total']       = {'$sum': {'$add': [{'$ifNull': ['$R1', 0]}, {'$ifNull': ['$R4', 0]}]}}
                else:
                    h['ham']         = {'$sum': {'$add': [{'$ifNull': ['$R1', 0]}, {'$ifNull': ['$R2', 0]}]}}
                    h['hampf']       = {'$sum': '$R8'};
                    h['spampf']      = {'$sum': '$R127'};
                    h['total']       = {'$sum': {'$add': [{'$ifNull': ['$R1', 0]}, {'$ifNull': ['$R2', 0]}, {'$ifNull': ['$R4', 0]},
                        {'$ifNull': ['$R8', 0]}, {'$ifNull': ['$R127', 0]}, {'$ifNull': ['$R256', 0]}]}}
                    h['cmpl_spam']      = {'$sum': '$cmpl_spam'}
                    h['cmpl_spam_nopf'] = {'$sum': '$cmpl_spam_nopf'}
                    h['cmpl_ham']       = {'$sum': '$cmpl_ham'}
                    h['cmpl_ham_nopf']  = {'$sum': '$cmpl_ham_nopf'}

                for rule in rules:
                    if len(rules[rule].keys()) < 1:
                        continue
                    match['rule'] = rule
                    r = {}
                    for row in dbCollection.aggregate([{'$match': match}, {'$group': h}]):
                        r = row
                    if not r or dbCollection.count(match) < 1:
                        r = {'spam': 0, 'malic': 0, 'ham': 0, 'total': 0}
                        if route[:2] != 'So':
                            r['spampf'] = r['hampf'] = r['cmpl_spam'] = r['cmpl_ham'] = 0
                    if route[:2] == 'So':
                        r['spampercent'] = (r['spam'] * 100.0 / r['total']) if r['total'] > 0 else 0
                    else:
                        r['spampercent'] = ((r['spam'] + r['spampf'] + r['malic']) * 100.0 / r['total']) if r['total'] > 0 else 0
                        r['nopf'] = ((r['spam'] + r['hampf'] + r['malic']) * 100.0 / r['total']) if r['total'] > 0 else 0
                        r['cmpl_spam_percent'] = (r['cmpl_spam_nopf'] * 100.0 / r['ham']) if r['ham'] > 0 else 0
                        r['cmpl_ham_percent'] = (r['cmpl_ham_nopf'] * 100.0 / r['spam']) if r['spam'] > 0 else 0
                    for p in RULE_PARAM[route]:
                        p1, p2 = "{0}_{1}_min".format(period, p), "{0}_{1}_max".format(period, p)
                        if (p1 not in rules[rule] or rules[rule][p1] is None) and (p2 not in rules[rule] or rules[rule][p2] is None):
                            continue
                        if p1 in rules[rule] and rules[rule][p1] is not None and rules[rule][p1] > r[p]:
                            res[route][rule][p] = {
                                'val':   r[p],
                                'type':  'min',
                                'bound': rules[rule][p1]
                            }
                        if p2 in rules[rule] and rules[rule][p2] is not None and rules[rule][p2] < r[p]:
                            res[route][rule][p] = {
                                'val':   r[p],
                                'type':  'max',
                                'bound': rules[rule][p2]
                            }
            except Exception, e:
                writelog("Monitoring rules for '%s' failed: %s" % (route, str(e)), True)
        if len(res.keys()) > 0:
            r = u'за сутки {0}'.format(match['date']) if period == 'daily' else u'за период времени с {0} по {1}'.format(time2str(match['time']), time2str(match['time'] + 600))
            for rt in filter(lambda t: t[0] in res, RULES_TYPES):
                route = rt[1].lower()
                txt += u"""<div><p><b>Правила: {0}</p><p>из '{1}' {2} послужили причиной следующих тревог:</b></p></div>
    <div>
    <table cellspacing="0" cellpadding="4" border="1" style="margin-top:0.5em;">
        <thead><th>Правило</th><th>Недопустимые значения параметров</th></thead><tbody>
    """.format(', '.join(res[rt[0]].keys()), route, r)
                route, s = rt[0], ''
                for rule in res[route].keys():
                    s += '<tr><td>{0}</td><td>{1}</td></tr>'.format(rule, ', '.join(map(lambda p:
                        "{0}:{1} ({2}:{3})".format(p,  res[route][rule][p]['val'], res[route][rule][p]['type'], res[route][rule][p]['bound']), res[route][rule].keys())))
                txt += u"""
        {0}
    </tbody></table>
    </div>
    """.format(s)
            txt = u"""<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru">
    <head>
        <meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
        <title>Сигнал тревоги службы мониторинга правил СО</title>
        <!-- Переводим MSIE8 в режим эмуляции MSIE7 -->
        <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7"/>
    </head>
    <body>
    {0}
    </body>
    """.format(txt)
            msg = MIMEText(txt, _charset='utf8')
            msg['From'] = CFG['robot']['name']
            msg['To'] = email_address
            msg['Content-Type'] = 'text/html; charset="utf-8"'
            msg['Subject'] = "Yandex Spamooborona's Rules Monitoring Service Alert"
            sendEmail(msg.as_string(), toaddr=email_address)


if __name__ == "__main__":
    from cron.rules._config import CFG as PG
    CFG['logfile'], period = '/logs/cron-scripts.log', ''
    try:
        period = sys.argv[1] if len(sys.argv) > 1 else 'daily'
        email_address = sys.argv[2] if len(sys.argv) > 2 else 'so-alerts@yandex-team.ru'
        if period != 'daily' and period != '10min':
            sys.exit(0)
    except Exception, e:
        writelog("Exception: %s" % str(e), True)
    rt = run_task(getDbConnection(PG, 'read-only'), writelog, period, email_address)
    rt()
