#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, re
sys.path.insert(0, 'WORKING_DIR')
from cron.common import getDbConnection, startScript, runScript, endScript
from web.common import CFG
from web.log_utils import writelog


CFG['logfile'] = '/logs/cron-scripts.log'


class CronScript():
    def __init__(self, config, subfolder):
        self.script_name = ''
        self.subfolder = subfolder
        self.db_config = config.copy()
        self.db_conn = getDbConnection(self.db_config)

    def start(self, script_name):
        for task_info in startScript(self.db_conn, script_name, self.subfolder):
            if task_info is not None:
                self.task = task_info[0]
                self.cron_expr = task_info[2]
                yield task_info[1]

    def run(self, options):
        runScript(self.db_conn, self.db_config, self.task, options)

    def end(self, script_name):
        endScript(self.db_conn, script_name, self.subfolder, self.cron_expr)


def filterScriptName(file_name):
    if file_name.startswith("_"):
        return ''
    m = re.search(r'^(.+)\.(\w+)$', file_name)
    if m and m.group(2) == 'py':
        return m.group(1)
    return ''


def runScriptFile(script_file, subfolder = ''):
    script_name = filterScriptName(script_file)
    if not script_name or script_name == 'common':
        return
    try:
        _temp = __import__('%s_config' % ('{0}.'.format(subfolder) if subfolder else ''), globals(), locals(), ['CFG'], -1)
        if hasattr(_temp, 'CFG'):
            cron_script = CronScript(_temp.CFG, subfolder)
            for options in cron_script.start(script_name):
                cron_script.run(options)
                cron_script.end(script_name)
        else:
            writelog("Warning: There are no config for the cron-script '%s' in subfolder '%s', all scripts in this subfolder will be ignored!" % (script_name, subfolder))
    except Exception, e:
        writelog("Run cron script '%s' failed: %s" % (script_name, str(e)), True)


this_file_name = os.path.basename(__file__)
for file_name in os.listdir('WORKING_DIR/cron'):
    is_dir = os.path.isdir('WORKING_DIR/cron/%s' % file_name)
    if is_dir and file_name == 'tab':
        continue
    elif not is_dir:
        if file_name != this_file_name:
            runScriptFile(file_name)
        continue
    for file_name2 in os.listdir('WORKING_DIR/cron/%s' % file_name):
        is_dir = os.path.isdir('WORKING_DIR/cron/%s/%s' % (file_name, file_name2))
        if is_dir:
            continue
        runScriptFile(file_name2, file_name)
