#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, redis, psycopg2, pymongo
from log_utils import writelog
from common import getHosts4Group


DB = {
    "host": "iva-xb3w4z7jjjpuf8sd.db.yandex.net,myt-3mdnt0clvntgeqmv.db.yandex.net,sas-5nnjcnus304urap7.db.yandex.net",
    "port": 6432,
    "db":   "complaints",
    "user": "cmpl"
}
REDIS = {
    "cluster_name":  "users_stat",
    "hosts":         ['sas-667541avf1c1ontn.db.yandex.net', 'vla-9cp0yx8ud9yrt90n.db.yandex.net'],
    "port":          6379,
    "sentinel_port": 26379,
    "db":            0,
    "timeout":       3.0,
    "auth":          True
}
REDIS_STAT = REDIS.copy()
REDIS_STAT["db"] = 1
REDIS_QUEUE = {
    'host':    "127.0.0.1",
    'port':    26379,
    'db':      0,
    'timeout': 3.0
}
REDIS_GREY = REDIS.copy()
REDIS_GREY["db"] = 2
REDIS_GREY["key"] = "grey_complainaints"
REDIS_GREY["batch_size"] = 100000
IMAPCHICK = {
    "mongodb" : {
        "cluster": "mail_so_813",
        "hosts":   "compldb1j.so.yandex.net,compldb1m.so.yandex.net,compldb1o.so.yandex.net",
        "port":    27017,
        "db":      "imap"
    },
    "redis": {
        "cluster_name":  "imapchick",
        "hosts":         ['sas-9hj1mqfnn09ivo2p.db.yandex.net', 'vla-lypu9dngze8qheim.db.yandex.net'],
        "port":          6379,
        "sentinel_port": 26379,
        "db":            0,
        "timeout":       30.0,
        "auth":          True
    }
}


def mongoConnStr(cfg, log_fh=None):
    s = ''
    if 'user' in cfg and cfg['user']:
        s = "%s:%s@" % (cfg['user'], cfg['passwd'])
    return "mongodb://%s%s/%s" % (s, ','.join(getHosts4Group(cfg.get('cluster', ''), cfg['hosts'] if isinstance(cfg['hosts'], list) else cfg['hosts'].split(','), log_fh)), cfg['db'])


def loadMongoDbCredentials(cfg, log_fh=None):
    f, CURDIR = None, 'WORKING_DIR'
    try:
        if not os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])) and 'HOME' in os.environ:
                CURDIR = '/root'
        if os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
            f = open('%s/.mongodb.%s' % (CURDIR, cfg['db']))
            for line in f:
                sf = line.split(':')
                if len(sf) == 2:
                    cfg['user'], cfg['passwd'] = sf[0], sf[1].strip()
                    break
            f.close()
            if cfg.get('ssl', False):
                CURDIR = 'WORKING_DIR'
                if not os.path.exists('%s/allCAs.pem' % CURDIR):
                    CURDIR += '/.mongodb'
                    if not os.path.exists('%s/allCAs.pem' % CURDIR):
                        CURDIR = os.path.dirname(os.path.abspath(__file__))
                if os.path.exists('%s/allCAs.pem' % CURDIR):
                    cfg['ssl_ca_certs'] = '%s/allCAs.pem' % CURDIR
            else:
                cfg['ssl'] = False
        elif 'user' in cfg:
            writelog("ERROR: Unable to locate file with DB credentials!", False, log_fh)
    except Exception, e:
        writelog("loadMongoDbCredentials exception: %s" % str(e), True, log_fh)


def getMongoDB(cfg, mode='read-write', log_fh=None):
    if not hasattr(getMongoDB, "%s_connection" % cfg['db']):
        timeout = int(cfg['timeout'] if 'timeout' in cfg and cfg['timeout'] else 10000)
        mongo_cfg = {
            'host':             mongoConnStr(cfg, log_fh),
            'port':             int(cfg['port']),
            'connectTimeoutMS': timeout,
            'socketTimeoutMS':  timeout,
            'read_preference':  pymongo.read_preferences.ReadPreference.NEAREST
        }
        if cfg.get('ssl', False) and 'ssl_ca_certs' in cfg:
            mongo_cfg.update({'ssl': True, 'ssl_ca_certs': cfg['ssl_ca_certs']})
        setattr(getMongoDB, "%s_connection" % cfg['db'], pymongo.MongoClient(**mongo_cfg)[cfg['db']])
    return getattr(getMongoDB, "%s_connection" % cfg['db'])


def getPGCredentials(cfg, log_fh=None):
    f, CURDIR, dbname = None, 'WORKING_DIR', cfg['db'][:len(cfg['db']) - 2] if cfg['db'].endswith('db') else cfg['db']
    try:
        if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)):
                CURDIR = os.environ['HOME'] if 'HOME' in os.environ else '/root'
        f = open('{0}/.pgpass.{1}'.format(CURDIR, dbname))
        for line in f:
            sf = line.split(':')
            if len(sf) == 5 and sf[2] == cfg['db']:
                cfg['host'], cfg['port'], cfg['user'], cfg['password'] = sf[0], int(sf[1]), sf[3], sf[4].strip()
                break
            elif len(sf) == 2 and sf[0] == cfg['user']:
                cfg['password'] = sf[1].strip()
                break
        f.close()
    except Exception, e:
        writelog("getPGCredentials exception: %s" % str(e), True, log_fh)


def getPGdb(cfg, mode='read-write', log_fh=None):
    pg = None
    CURDIR = 'WORKING_DIR'
    if not os.path.exists('{0}/.pgsql/root.crt'.format(CURDIR)):
        CURDIR = '/root'
    if hasattr(psycopg2, '__libpq_version__'):
        pg = psycopg2.connect(dbname=cfg['db'], user=cfg['user'], password=cfg['password'], host=cfg['host'], port=cfg['port'], sslmode='verify-full', sslrootcert='%s/.pgsql/root.crt' % CURDIR, target_session_attrs=('read-write' if mode == 'read-write' else 'any'))
    else:
        if ',' in cfg['host']:
            for host in cfg['host'].split(','):
                try:
                    pg = psycopg2.connect(database=cfg['db'], user=cfg['user'], password=cfg['password'], host=host, port=cfg['port'], sslmode='verify-full', sslrootcert='%s/.pgsql/root.crt' % CURDIR)
                    pg_cursor = pg.cursor()
                    pg_cursor.execute("SELECT pg_is_in_recovery()")
                    res = pg_cursor.fetchone()
                    pg_cursor.close()
                    if res and (mode == 'read-write' and not res[0] or mode != 'read-write' and res[0]):
                        return pg
                except Exception, e:
                    writelog("getPGdb exception: %s" % str(e), True)
                    continue
        else:
            pg = psycopg2.connect(database=cfg['db'], user=cfg['user'], password=cfg['password'], host=cfg['host'], port=cfg['port'], sslmode='verify-full', sslrootcert='%s/.pgsql/root.crt' % CURDIR)
    return pg


def getRedisCredentials(cfg, log_fh=None):
    f, CURDIR, dbname = None, 'WORKING_DIR', cfg['cluster_name'][:len(cfg['cluster_name']) - 2] if 'cluster_name' in cfg and cfg['cluster_name'].endswith('db') else cfg.get('cluster_name', '')
    try:
        if not os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
                CURDIR = os.environ['HOME'] if 'HOME' in os.environ else '/root'
        if os.path.exists('{0}/.redis.{1}'.format(CURDIR, dbname)):
            f = open('{0}/.redis.{1}'.format(CURDIR, dbname))
            for line in f:
                sf = line.split(':')
                if len(sf) == 1:
                    cfg['password'] = sf[0].strip()
                    break
                elif len(sf) == 2 and sf[0] == cfg['cluster_name']:
                    cfg['cluster_name'], cfg['password'] = sf[0], sf[1].strip()
                    break
            f.close()
        else:
            writelog("getRedisCredentials: file '{0}/.redis.{1}' does not exist".format(CURDIR, dbname))
    except Exception, e:
        writelog("getRedisCredentials exception: %s" % str(e), True, log_fh)


def redisConnect(host, port, cfg):
    if 'passwd' in cfg and cfg['passwd']:
        return redis.Redis(host=host, port=port, db=cfg['db'], password=cfg['passwd'], socket_timeout=cfg.get('timeout', None))
    elif 'password' in cfg and cfg['password']:
        return redis.Redis(host=host, port=port, db=cfg['db'], password=cfg['password'], socket_timeout=cfg.get('timeout', None))
    else:
        return redis.Redis(host=host, port=port, db=cfg['db'], socket_timeout=cfg.get('timeout', None))


def redisReconnect(cfg, mode='read-write', log_fh=None):
    rediscli = None
    try:
        if 'auth' in cfg and cfg['auth']:
            getRedisCredentials(cfg, log_fh)
        if 'host' in cfg and cfg['host']:
            rediscli = redis.Redis(host=cfg['host'], port=cfg['port'], db=cfg['db'], socket_timeout=cfg.get('timeout', None))
        elif 'hosts' in cfg and cfg['hosts']:
            if 'cluster_name' in cfg and cfg['cluster_name']:
                try:
                    redis_sentinel = redis.Redis(host=cfg['hosts'][0], port=cfg.get('sentinel_port', 26379), socket_timeout=cfg.get('timeout', None))
                    host=redis_sentinel.sentinel_get_master_addr_by_name(cfg['cluster_name'])
                    rediscli = redisConnect(host[0], host[1], cfg)
                except Exception, e:
                    writelog("Exception in redis_reconnect for cluster '%s': %s" % (cfg['cluster_name'], str(e)), True, log_fh)
            else:
                for host in cfg['hosts']:
                    try:
                        rediscli = redisConnect(host, cfg['port'], cfg)
                        if mode == 'read-write' and rediscli.info()["role"] == "master" or mode == 'read-only' and rediscli.info()["role"] != "master":
                            return rediscli
                    except Exception, e:
                        writelog("Exception in redis_reconnect: %s" % str(e), True, log_fh)
    except Exception, e:
        writelog("Exception while redis_reconnect: %s" % str(e), True, log_fh)
    return rediscli
