#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, cgi
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR')
import re, subprocess, json
from multiprocessing import Pool
from time import mktime, strptime, strftime, time, localtime
from collections import defaultdict
from jinja2 import Environment, FileSystemLoader, Markup
from urllib import quote, unquote_plus
from IPy import IP
from log_utils import writelog
from common import getLogin, getUserInfo, doRequest
from users_utils import querySologger


reload(sys)
sys.setdefaultencoding('utf-8')


CONCURRENCY = 5
RETRY_COUNT = 2


def ip_reverse(ipstr):
    ip = IP(ipstr)
    if not ip:
        return None
    return re.sub(r'\.(?:in\-addr|ip6)\.arpa\.', r'', ip.reverseName())


def extract_date(s):
    s = re.sub(r'mess: [^-]+\-\s*(\d+)', r'\1', s)
    return int(s) if s else 0


def renderCountry(short_country, long_country):
    href = '<img src="/images/flags/{0}.gif"></img>'.format(short_country.lower() if short_country else '_')
    return "{0} {1} ({2})".format(href, short_country, long_country if long_country else 'unknown')


def ip_to_country(sIP):
    reversed_ip = ip_reverse(sIP)
    if not reversed_ip:
        return None
    resolve = ''
    try:
        resolve = subprocess.check_output('host -t txt {0}.geozone.yandex.ru georbl.so.yandex.net'.format(reversed_ip), shell=True)
    except Exception, e:
        writelog("Web Get by ID ip_to_country exception: %s" % str(e), True)
    short_country = long_country = ''
    m = re.search(r'descriptive text "([A-Z]{2}) (\S.*?)"', resolve)
    if m:
        short_country, long_country = m.group(1), m.group(2)
    return renderCountry(short_country, long_country)


def ip_to_spamsource(sIP):
    reversed_ip = ip_reverse(sIP)
    if not reversed_ip:
        return None
    resolve = ''
    try:
        resolve = subprocess.check_output('host {0}.spamsource.yandex.ru georbl.so.yandex.net'.format(reversed_ip), shell=True)
    except Exception, e:
        writelog("Web Get by ID ip_to_spamsource exception: %s" % str(e), True)
    return resolve


def param2Timestamp(ts):
    return int(mktime(strptime(ts, "%Y-%m-%d %H:%M")))


def replace_url(m):
    g = m.groups("")
    return u"{0}{1}{2}<a target='_blank' href='http://complshingler1h.so.yandex.net/compl_shingler?shingle={3}&type={1}&actiface=viewshinfo&authlogin={6}'>{3}</a>{4}{5}".format(g[0], g[1], g[2], g[3], g[4], g[5], getLogin())


def restoreDlvLog(dataStr):
    if dataStr[0] == '[': # expecting of array in JSON format
        log, data = "", []
        try:
            data = json.loads(dataStr)
        except Exception, e:
            try:
                data = json.loads(unicode(dataStr, 'utf8', 'replace'))
            except Exception, e:
                writelog("Parsing of JSON failed: %s" % str(e), True)
        for t in data:
            log += t[0] + ": " + t[1] + "\n"
        return log
    elif dataStr[0] == '{': # expecting of dict in JSON format
        log, data = "", {}
        try:
            data = json.loads(dataStr)
        except Exception, e:
            writelog("Parsing of JSON failed: %s" % str(e), True)
        for k, v in data.iteritems():
            if isinstance(v, list):
                for it in v:
                    log += k + ": " + it + "\n"
            else:
                log += k + ": " + v + "\n"
        return log
    else:
        return dataStr


def getDlvLog4Route((params, route)):
    uri = "{0}&route={1}".format('&'.join(map(lambda (k, v): '{0}={1}'.format(k, v), params.iteritems())), route)
    writelog("getDlvLog4Route: uri=" + uri)
    text = querySologger(uri).strip()
    if text:
        logs = []
        for rawLog in text.split("\n"):
            if rawLog:
                logs.append(restoreDlvLog(rawLog))
        return route, logs
    return route, []


def _parseRule(s):
    a = s.split()
    return (a[0], a[1] if len(a) > 1 else "0")


routeOrder = {'in': 2, 'out': 1, 'corp': 0}
form = cgi.FieldStorage()
key, key_type, ban, ip_geo, geo, logs, data, params = form.getfirst("key", ""), form.getfirst("key_type", ""), False, '', '', [], [], {}
uid, rcpt_uid, suid, login = form.getfirst("uid", ""), form.getfirst("rcpt_uid", ""), form.getfirst("suid", ""), form.getfirst("login", "")
fromaddr, msgid, qid, ip = form.getfirst("from", ""), form.getfirst("msgid", ""), form.getfirst("qid", ""), form.getfirst("ip", "")
reg_exp, limit, skip, count = form.getfirst("reg_exp", ""), form.getfirst("limit", "20"), form.getfirst("skip", "0"), 0
startDate, endDate = form.getfirst("start_date", ""), form.getfirst("end_date", "")
uri = os.environ['REQUEST_URI'] if 'REQUEST_URI' in os.environ else ''
proto = 'http{0}'.format('s' if 'HTTPS' in os.environ else '')
uri = re.sub(r'/?[^/]+$', '', uri)

if uid:
    key_type, key = 'uid', uid
elif rcpt_uid:
    key_type, key = 'rcpt_uid', rcpt_uid
elif suid:
    key_type, key = 'suid', suid
elif login:
    key_type, key = 'login', login
elif fromaddr:
    key_type, key = 'fromaddr', fromaddr
elif msgid:
    key_type, key = 'msgid', msgid
elif qid:
    key_type, key = 'queueid', qid
elif ip:
    key_type, key = 'source_ip', ip

print "Content-type: text/html\r\n\r\n"

if key:
    routes = form.getlist('cb_route') if 'cb_route' in form else ['in', 'out', 'corp']
    params = {
        'mintime': param2Timestamp(startDate) if startDate else 0,
        'limit':   limit,
        'skip':    skip
    }
    if endDate:
        ts = param2Timestamp(endDate)
        if ts >= params['mintime']:
            params['maxtime'] = ts
    if 'cb_filter' in form:
        code = ','.join(sorted(form.getlist('cb_filter'), cmp=lambda x, y: cmp(int(x), int(y))))
        if code and code != "1,2,4,8,127,256":
            params['code'] = code
    if key_type == "uid":
        uid, suid, login = getUserInfo(uid=key)
    elif key_type == "suid":
        uid, suid, login = getUserInfo(suid=key)
    elif key_type == "login":
        uid, suid, login = getUserInfo(login=key)
        if not uid:
            uid, suid, login = getUserInfo(login=key, bbType="corp")
        params["uid"] = uid
    if key_type == "rcpt_uid":
        params["rcpt_uid"] = key
    elif key_type == "msgid":
        key = key.strip(" \t\n")
        params["msgid"] = quote(key)
    elif key_type == "ip":
        if re.search(r'has address 127.0.0.8$', ip_to_spamsource(key)):
            ban = True
        ip_geo = ip_to_country(key)
        params["source_ip"] = key
    elif key_type == "qid":
        params["queueid"] = key
    elif key_type == "from":
        params["fromaddr"] = quote(key)
    else:
        params[key_type] = quote(key)
    pool = Pool(len(routes))
    result = []
    for route, logsArray in pool.map(getDlvLog4Route, zip([params] * len(routes), routes)):
        if not logsArray:
            continue
        for log in logsArray:
            m = re.search("mess:[^-]+-\s*(\d+):", log[:log.find("\n")])
            ts = int(m.group(1) if m else time())
            result.append([strftime("%Y-%m-%d", localtime(ts)), routeOrder[route], ts, log])
    if result:
        try:
            data = map(lambda block: block[3].encode("utf-8", "ignore"), sorted(result, reverse=True))
            count = len(data)
        except Exception, e:
            writelog("Decoding JSON exception: %s" % str(e), True)
    limit = int(limit) if limit and limit.isdigit() and int(limit) > 0 else 0
    user_login = getLogin()
    for i, dlvlog in enumerate(data, 1):
        if reg_exp and not re.search(reg_exp, dlvlog) or limit and i > limit or not re.match('^mess:', dlvlog.strip()):
            continue
        m, country = re.search(r'^iy-geozone:\s+(\w+)\s+(\w+)', dlvlog, re.M), ''
        if m and m.group(1):
            country = renderCountry(m.group(1), m.group(2))
        else:
            m = re.search('source ip =\s*(\S+)', dlvlog)
            if m and m.group(1):
                country = ip_to_country(m.group(1))
        dlvlog = re.sub(r'&', r'&amp;', dlvlog)
        dlvlog = re.sub(r'<', r'&lt;', dlvlog)
        dlvlog = re.sub(r'>', r'&gt;', dlvlog)
        r_sp_s = re.findall(r'^r_sp:\s(.+)$', dlvlog, re.M)
        r_nl_s = re.findall(r'^r_nl:\s(.+)$', dlvlog, re.M)
        r_dl_s = re.findall(r'^r_dl:\s(.+)$', dlvlog, re.M)
        r_sp = dict(map(_parseRule, filter(lambda s: len(s.strip()) > 0, re.split(r'\s*[,;]\s*', r_sp_s[0])))) if len(r_sp_s) > 0 else {}
        r_dl = dict(map(_parseRule, filter(lambda s: len(s.strip()) > 0, re.split(r'\s*[,;]\s*', r_dl_s[0])))) if len(r_dl_s) > 0 else {}
        r_nl = re.split(r'\s*[,;]\s*', r_nl_s[0]) if len(r_nl_s) > 0 else []
        m = re.match(r'^mess: (.*)$', dlvlog, re.M)
        sdh = m.group(1) if m else ''
        sdh = re.sub(r'\bid=(\d+)', r"id=<a target='_blank' href='{0}/users_abuse.py?suid=\1'>\1</a>".format(uri), sdh)
        sdh = re.sub(r'\buid=(\d+)', r"uid=<a target='_blank' href='{0}/users_abuse.py?uid=\1'>\1</a>".format(uri), sdh)
        dlvlog = re.sub(r'^mess: (.*)$', r"mess: {0}".format(sdh), dlvlog, flags=re.M)
#       dlvlog = re.sub(r'^(mfrm:.*\bid=)(\d+)(.*)$', r"\1<a target='_blank' href='http://freemail.so.yandex.net/fms/getsenderinfo/?type=YAN&email=\2&shingle='>\2</a>\3", dlvlog, flags=re.M)
#       dlvlog = re.sub(r'^(log : t = )(\d+)(.*\s)([0-9a-fA-F]+)(\s*)(\([^\)]*\))?$', r"\1\2\3<a target='_blank' href='http://longshingler1h.mail.yandex.net/longshingler2?shingle=\4&type=\2&action=complshget&authlogin={0}'>\4</a>\5\6".format(user_login), dlvlog, re.M)
        #dlvlog = re.sub(r'^(log : t = )(\d+)(.*\s)([0-9a-fA-F]+)(\s*)(\([^\)]*\))?$', replace_url, dlvlog, flags=re.M)
        dlvlog = re.sub(r'^(rcvd: source ip = )(\d+\.\d+\.\d+\.\d+)(.*)$', r"\1<a target='_blank' href='http://statip.so.yandex.net/sostatip?ip=\2&actiface=viewipstat&authlogin={0}'>\2</a>\3".format(user_login), dlvlog, flags=re.M)
        dlvlog = re.sub(r'^(rcvd: source ip = )(\S+:\S+)(.*)$', r"\1<a target='_blank' href='http://statip.so.yandex.net/sostatip?ip=\2&actiface=viewipstat&authlogin={0}'>\2</a>\3".format(user_login), dlvlog, flags=re.M)
        dlvlog = re.sub(r'^r_sp:.+$', r'r_sp: {0}\n'.format(',  '.join(map(lambda r: '<a style="color:black; text-decoration:none;" class="blacklink" href="{0}/showrule.py?rule={1}">{1}</a> {2}'.format(uri, r, r_sp[r]), sorted(r_sp.keys(), cmp = lambda a, b: cmp(float(r_sp[a]), float(r_sp[b])))))), dlvlog, flags=re.M)
        dlvlog = re.sub(r'^r_dl:.+$', r'r_dl: {0}\n'.format(',  '.join(map(lambda r: '<a style="color:black; text-decoration:none;" class="blacklink" href="{0}/showrule.py?rule={1}">{1}</a> {2}'.format(uri, r, r_dl[r]), sorted(r_dl.keys(), cmp = lambda a, b: cmp(float(r_dl[a]), float(r_dl[b])))))), dlvlog, flags=re.M)
        dlvlog = re.sub(r'^r_nl:.+$', r'r_nl: {0}\n'.format(',  '.join(map(lambda r: '<a style="color:black; text-decoration:none;" class="blacklink" href="{0}/showrule.py?rule={1}">{1}</a>'.format(uri, r), r_nl))), dlvlog, flags=re.M)
        dlvlog = u'<a href="{0}/statrules.py?rules={1}" target="_blank"><B>[Rules\' statistics]</B></a>\n{2}'.format(uri, ','.join([','.join(r_sp.keys()), ','.join(r_dl.keys()), ','.join(r_nl)]), dlvlog)
        dlvlog = re.sub(r'^([^:]+:)', r'<b>\1</b>', dlvlog, flags=re.M)   # bold fieldnames
        if country:
            dlvlog = u'<h4>geo: {0}</h4>{1}'.format(country, dlvlog)
        s0 = ''
        for s in dlvlog.splitlines():
            s0 += u"{0}<br/>\n".format(s)
        logs.append(u"<p><tt>{0}</tt></p>".format(s0))
try:
    env = Environment(loader = FileSystemLoader("WORKING_DIR/web/internal"))
    env.globals['include_html'] = Markup
    template = env.get_template("web_fgbd.html.template")
    print template.render(locals())
except Exception, e:
    writelog("Exception caught (tell developer, please): %s" % str(e), True)
