#!/usr/bin/python2
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/web')
import re, json, time
from subprocess import check_output, call, Popen, PIPE, STDOUT, CalledProcessError
from multiprocessing.pool import Pool
from email.mime.text import MIMEText
from glob import glob
from shutil import rmtree
from urllib import unquote_plus
from log_utils import writelog
from common import CFG, RE, getUUID
from email_utils import sendEmail
from rules_common import CheckingRepoContext, checkoutBranch, refreshRepo, createTmpDir, pullRepo, pushRepo, verifyAFRules


MAX_COMMIT_MSG_LENGTH = 1023
RULES = CFG["af_rules"]
PARENT_REPO = RULES["folder_name"]
SUBMODULES = RULES["submodules"]
res = payload = c = ''
faultRulesTotal = 0

DIFF_RE = re.compile(u'^(diff --git) (a/\S+) (b/\S+)\s*$', re.M)
PLUS_RE, PLUS3_RE = re.compile(u'^\+[^\n]*?$', re.M), re.compile(u'^\+{3} [^\n]+?$', re.M)
MINUS_RE, MINUS3_RE = re.compile(u'^\-[^\n]*?$', re.M), re.compile(u'^\-{3} [^\n]+?$', re.M)
ATAT_RE = re.compile(u'^(\@\@ .*? \@\@)\s+(.*?)$', re.M)
RULES_SUCCESS_RE = re.compile(r'^\*{3} All success rules', re.M)
RULES_RESULTS_RE = re.compile(r'^(.*?(?:All\b|Rules cs:).*?)$', re.M)
RULES_FAULT_RE = re.compile(r'^(.*?\bfault\b.*?\brules: (\d+).*?)$', re.M|re.I)
RULES_SUBRESULTS_RE = re.compile(r'^(\*{3}\s.*?)$', re.M)
RULES_ERRORS_RE = re.compile(r'\n((?:Exception|Caused by) [^\n]+\n(\s+[^\n]+\n)+)', re.M)
HEADER = u"""<html>
<head>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <style>
    .rules-types {
      margin-bottom: 12px;
      font-size: .9rem;
    }
    .rules-types li {
      line-height: 1.2;
      padding-bottom: 10px;
    }
    ul, ul.option-list {
      list-style-type: none;
    }
    li {
      display: list-item;
      text-align: -webkit-match-parent;
    }
    a, details, li, ul {
      margin: 0;
      padding: 0;
      border: 0;
    }
    ul {
      display: block;
      list-style-type: none;
      margin-block-start: 1em;
      margin-block-end: 1em;
      margin-inline-start: 0px;
      margin-inline-end: 0px;
      padding-inline-start: 12px;
    }
    .rules-types details {
      margin-bottom: 10px;
      margin-left: 24px;
      padding-left: 10px;
    }
    details {
      margin-bottom: 12px;
      margin-left: 24px;
      display: block;
    }
    details summary {
        margin-left: -24px;
    }
    a i[class^=icon-]:before, label, summary {
      cursor: pointer;
    }
    summary {
      display: block;
    }
    .rules-types details summary:before {
      font-size: .6rem;
    }
    details[open]>summary:before {
      content: '\25BC\FE0E';
    }
    summary:before {
      display: inline-block;
      width: 20px;
      color: #3d7e9a;
      content: "▶︎";
    }
    .rules-types li li:first-child {
      padding-top: 10px;
    }
    .rules-types details li {
      padding-left: 0;
    }
    .rules-types li li {
      padding-bottom: 0;
      padding-left: 12px;
    }
  </style>
</head>
<body><pre>"""


def changeRow(row):
    r = RE["rules_folder"].sub(r' {}/'.format(PARENT_REPO), row)
    r = RE["rules_timestamp"].sub(r'', r)
    if RULES_SUCCESS_RE.match(r):
        r = '</details>\n<span style="color: #0F940F;"><b>{0}</b></span>'.format(r)
    elif RULES_ERRORS_RE.search(r):
        r = '<span style="color: #FF0000;"><b>{0}</b></span>'.format(r)
    else:
        m = RULES_FAULT_RE.search(r)
        if m and m.group(2) and int(m.group(2)) > 0:
            r = '<span style="color: #FF0000;"><b>{0}</b></span>'.format(r)
        elif RULES_RESULTS_RE.search(r):
            r = '<span style="color: #0F940F;"><b>{0}</b></span>'.format(r)
        elif RULES_SUBRESULTS_RE.search(r):
            r = '<span style="color: #9C4040;">{0}</span>'.format(r)
        elif r.startswith('Rules checking regime'):
            r = '</li>'
    return r


def getChangedFiles(payloadCommits):
    files = []
    onlySubmodules = True       # if and only if submodules changed each as a whole
    for c in payloadCommits:
        for changeType in ["added", "removed", "modified"]:
            for f in c[changeType]:
                files.append(f)
                if f not in SUBMODULES:
                    onlySubmodules = False
    return onlySubmodules, files


def uploadRulesBundleResource(info, tmpFolder, token):
    output, commits, commitsInfo = '', ', '.join(info['commits']), '; '.join(info['info'])
    try:
        rmtree("{}/{}/.git".format(tmpFolder, PARENT_REPO), ignore_errors=True)
        os.remove("{}/{}/.gitmodules".format(tmpFolder, PARENT_REPO))
    except Exception, e:
        writelog('uploadRulesBundleResource: Exception occurred while preparing antifraud rules bundle in folder "%s": %s' % (tmpFolder, str(e)), True)
    try:
        output = check_output('WORKING_DIR/sandbox_upload -b "{0}/{1}" -t SO_ANTIFRAUD_RULES_BUNDLE -s {2} -o MAIL_SO -d "SO ANTIFRAUD rules bundle (commits: {3})" -l 14 -c "linux" -p stable -q "Autorelease of SO ANTIFRAUD rules bundle (commits: {3}, info: {4})" -m "WORKING_DIR/temp" -g rules -x -i {0}/rules_antifraud_task_id -r {0}/rules_antifraud_resource_id -u {0}/rules_antifraud_resource_url'.format(tmpFolder, PARENT_REPO, token, commits, commitsInfo), stderr=STDOUT, shell=True, universal_newlines=True)
    except Exception, e:
        writelog('uploadRulesBundleResource: Exception uploading antifraud rules bundle from folder %s to SandBox: %s' % (tmpFolder, str(e)), True)
    return output


def copyMaster2TempFolder(repoPath, tmpFolder):
    writelog("Antifraud rules hook: Copying of files from the master branch to temp folder '%s'" % tmpFolder)
    checkoutBranch(repoPath, 'master')
    try:
        writelog("copyMaster2TempFolder: Copying master branch of antifraud rules repo with new changes to temporary folder '%s'" % repoPath)
        call("mkdir -p {0} && cp -ar {1}* {0}/".format(tmpFolder, repoPath), shell=True)
    except Exception, e:
        writelog("copyMaster2TempFolder: Copying master branch of rules repo with new changes to temporary folder failed: %s" % str(e), True)


def pushMainRepoChanges(commitMsg, branch):
    writelog("Antifraud rules hook: Making commit to the master branch of main repository")
    c = checkoutBranch(RULES["folder"], branch)
    c += pullRepo(RULES["folder"])
    if re.search(r'reject|error|fatal', c, re.I):
        writelog('pushMainRepoChanges: Pulling commits into "%s" branch of main antifraud repo from remote error: %s' % (branch, c))
    commitMsg = commitMsg.strip()
    if len(commitMsg) > MAX_COMMIT_MSG_LENGTH:
        commitMsg = commitMsg[:MAX_COMMIT_MSG_LENGTH-3] + "..."
    try:
        (output, rows) = Popen('cd {0} && git add . 2>&1 && git commit -m"{1}" --author="{2}"'.format(RULES["folder"], commitMsg, CFG['robot']['name']), stdout=PIPE, stderr=PIPE, shell=True, universal_newlines=True).communicate()
    except Exception, e:
        writelog('pushMainRepoChanges: Exception while git commit into "%s" branch of main antifraud repo: %s' % (branch, str(e)), True)
    #if re.search(r'reject|error|fatal', rows, re.I):
    #    writelog('pushMainRepoChanges: Committing into "%s" branch of main antifraud repo failed: %s' % (branch, output))
    #else:
    c = pushRepo(RULES["folder"], branch)
    if re.search(r'reject|error|fatal', c, re.I):
        writelog('pushMainRepoChanges: Pushing commits into "%s" branch of main antifraud repo to upstream error: %s' % (branch, c))
    checkoutBranch(RULES["folder"], branch)


def makeAndUploadRulesBundle(payload, repoPath, tmpFolder):
    writelog("makeAndUploadRulesBundle: making of bundle and upload it to SandBox (temporary folder '%s')" % tmpFolder)
    pushMainRepoChanges('; '.join(map(lambda c: "'{}' ({})".format(c["message"], c["author"].get("username", c["author"]["name"])), payload['commits'])), "stable")
    copyMaster2TempFolder(repoPath, "{}/{}".format(tmpFolder, PARENT_REPO))
    writelog("Uploading rules bundle to SandBox: %s" % uploadRulesBundleResource({
        "commits": map(lambda c: c["id"], payload['commits']),
        "info":    map(lambda c: "'{}' ({})".format(c["message"], c["author"].get("username", c["author"]["name"])), payload['commits'])
    }, tmpFolder, os.environ['ROBOT_SANDBOX_TOKEN']))


#######################################################################################################################
try:
    contentLength = int(os.environ['CONTENT_LENGTH'] if 'CONTENT_LENGTH' in os.environ else (os.environ['HTTP_CONTENT_LENGTH'] if 'HTTP_CONTENT_LENGTH' in os.environ else 0))
    if contentLength:
        payload = sys.stdin.read(contentLength)
    if not payload or len(payload) < 3:
        writelog("Antifraud rules hook: Invalid payload for the event '{0}'. Payload: {1}. Env: {2}.".format(os.environ['HTTP_X_GITHUB_EVENT'] if 'HTTP_X_GITHUB_EVENT' in os.environ else '', payload, str(os.environ)))
        sys.exit(1)
    if 'HTTP_USER_AGENT' not in os.environ or not os.environ['HTTP_USER_AGENT'] or not re.match(r'^GitHub[ -]Hookshot\b', os.environ['HTTP_USER_AGENT']):
        writelog('Antifraud rules hook: Request not from GitHub has detected. Processing has canceled. Env: %s.' % str(os.environ))
        sys.exit(1)
    try:
        payload = json.loads(payload)
    except Exception, e:
        try:
            s = unquote_plus(payload)
            if s.startswith("payload="):
                s = s[8:]
            payload = json.loads(s)
        except Exception, e:
            writelog("Antifraud rules hook: Error while parsing JSON: %s. Payload: %s. Env: %s." % (str(e), s, str(os.environ)), True)
            sys.exit(1)
except Exception, e:
    writelog("Antifraud rules hook exception: %s" % str(e), True)

if 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'push' and payload['ref'] == 'refs/heads/master':
    curDate, url, diffLog, c = time.strftime('%a, %d %b %Y %H:%M:%S %z'), payload['repository']['url'], '', ''
    url = re.sub(r'^https://{0}/'.format(CFG['github_host']), r'', url)
    repo = ""
    if url.startswith("so/{}".format(PARENT_REPO)):
        n = len("so/{}".format(PARENT_REPO))
        repo = url[n:]
    submodule = repo[1:] if repo.startswith("-") else ""
    # HTTP_X_GITHUB_DELIVERY variable contains UUID
    rulesDir = os.environ['HTTP_X_GITHUB_DELIVERY'] if 'HTTP_X_GITHUB_DELIVERY' in os.environ and os.environ['HTTP_X_GITHUB_DELIVERY'] else getUUID()
    onlySubmodules, changedFiles = getChangedFiles(payload['commits'])
    with CheckingRepoContext(CFG['af_rules']['check_lock_path']) as RulesLock:
        repoPath = RULES["folder"] + ("{}/".format(submodule) if submodule else "")
        writelog("Antifraud rules hook: Checking out repository for submodule %s" % submodule)
        checkoutBranch(repoPath)
        refreshRepo(repoPath)
        if not submodule:
            writelog("Antifraud rules hook: Checking out repositories for all submodules")
            for folder in SUBMODULES.keys():
                checkoutBranch(RULES["folder"] + folder + "/")
                refreshRepo(RULES["folder"] + folder + "/")
        # verification of rules in 'antifraud' folder
        resText, faultRulesCnt = verifyAFRules(rulesDir, submodule, PARENT_REPO + repo)
        s, diffLog, commits, files, authors = '', '', {}, {}, {}
        if not onlySubmodules:
            submoduleName = SUBMODULES[submodule].replace('&', '&amp;') if submodule in SUBMODULES else submodule.capitalize()
            if submoduleName:
                submoduleName = u" Я." + submoduleName
            res += u"<li class='toggle'><details open><summary><b>Проверка правил Антифрода{}</b></summary>\n<details><summary>Подробности статистики по файлам правил</summary>{}</details></li>\n".format(submoduleName, '\n'.join(map(lambda r: changeRow(r), resText.strip().split('\n'))))
            faultRulesTotal += faultRulesCnt
            # composing and sending email
            if faultRulesTotal:  # send pushed commits log to author in a case of failed rules verification
                #try:
                #    c = check_output('cd %s && git reset --hard HEAD^' % RULES["folder"], stderr=STDOUT, shell=True, universal_newlines=True)
                #except Exception, e:
                #    writelog('Exception while "git reset --hard HEAD^": %s' % str(e), True)
                emailText = u"""{0}
<div class="rules-types" id="rules-types"><ul>
{1}
</ul></div>
{2}
</pre></body></html>""".format(HEADER, res, c if c else '')
                msg = MIMEText(emailText, _charset='utf8')
                msg["From"] = CFG['robot']['name']
                msg['To'] = payload['head_commit']['author']['email']
                msg["Date"] = curDate
                msg["MIME-Version"] = "1.0"
                msg["Content-Type"] = 'text/html; charset="UTF-8"'
                msg["Subject"] = "[%s] Rules verification report" % url
                s = sendEmail(msg.as_string(), msg['From'], msg['To'])
                writelog("Antifraud rules hook: AF rules have {} faults, sendEmail answered: {}".format(faultRulesTotal, s))
            else:
                for c in payload['commits']:
                    commits[c['id']] = c["message"]
                    if "username" in c["author"]:
                        authors[c["author"]["username"]] = 1
                    elif "username" in c["committer"]:
                        authors[c["committer"]["username"]] = 1
                    elif "name" in c["author"]:
                        authors[c["author"]["name"]] = 1
                    elif "name" in c["committer"]:
                        authors[c["committer"]["name"]] = 1
                    else:
                        authors["<unknown>"] = 1
                    d = c['timestamp']
                    m = re.match('^(\d{4})-(\d\d)-(\d\d)[T\s](\d\d):(\d\d):(\d\d)\s*([+-]?\d+)\W(\d+).*?$', d)
                    if m:
                        d = u"{0}-{1}-{2} {3}:{4}:{5} {6}{7}".format(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5), m.group(6), m.group(7), m.group(8))
                    output, rows, info = '', '', []
                    try:
                        (output, rows) = Popen('cd {0} && git diff --name-status {1}^ {1}'.format(repoPath, c['id']), stdout=PIPE, stderr=PIPE, shell=True, universal_newlines=True).communicate()
                    except Exception, e:
                        writelog('Antifraud rules hook: Exception while git diff: %s.' % str(e), True)
                    if output.strip():
                        for row in output.strip().split('\n'):
                            m = re.match(r'^\s*([A-Z])\s+(.*?)$', row)
                            if m:
                                info.append('  {0}  <a href="{1}/blob/{2}/{3}">{3}</a>'.format(m.group(1), payload['repository']['url'], c['id'], m.group(2)))
                                filePath = m.group(2).rstrip()
                                files[filePath] = m.group(1)
                        output = ''
                    try:
                        (output, rows) = Popen('cd {0} && git diff {1}^..{1}'.format(repoPath, c['id']), stdout=PIPE, stderr=PIPE, shell=True, universal_newlines=True).communicate()
                    except Exception, e:
                        writelog('Antifraud rules hook: Exception while git diff: %s.' % str(e), True)
                    #if rows.strip():
                    #    writelog("Git diff output: %s. Error: %s" % (output, rows))
                    output = DIFF_RE.sub(u'<span style="color:#000000;"><b>\g<1></b></span> <span style="color:#9F0000;"><b>\g<2></b></span> <span style="color:#007F00;"><b>\g<3></b></span>', unicode(output, 'utf-8', 'ignore'))
                    output = MINUS3_RE.sub(u'<span style="color:#9F0000;"><b>\g<0></b></span>', PLUS3_RE.sub(u'<span style="color:#007F00;"><b>\g<0></b></span>', output))
                    output = MINUS_RE.sub(u'<span style="color:#9F0000;">\g<0></span>', PLUS_RE.sub(u'<span style="color:#007F00;">\g<0></span>', output))
                    output = ATAT_RE.sub(u'<span style="color:#0097C9;"><b>\g<1></b></span> <span style="color:#0097C9;">\g<2></span>', output)
                    diffLog += u"""
<b>Commit:</b> <a href="{0}?diff=split">{1}</a>
<b>Author:</b> {2} <{3}>
<b>Date:</b> {4}

<b>Changed paths:</b>
{5}

<b>Log Message:</b>
------------
{6}

<b>Rules verification report:</b>
--------------------------
{7}

<b>Git Diff:</b>
---------
{8}

""".format(c['url'], c['id'], c['author']['name'], c['author']['email'], d, '\n'.join(info), RE['url'].sub(u'<a href="\g<0>">\g<0></a>', c['message']), res, output)
                email_text = u"""{0}
<b>Branch:</b> {1}
<b>Home:</b> <a href="{2}">{2}</a>
{3}

</pre></body></html>""".format(HEADER, payload['ref'], payload['repository']['url'], diffLog)
                msg = MIMEText(email_text, _charset='utf8')
                msg['From'] = "{} <{}>".format(payload['head_commit']['author']['name'], payload['head_commit']['author']['email'])
                msg['To'] = "spamstop-commits@yandex-team.ru"
                msg["Date"] = curDate
                msg["MIME-Version"] = "1.0"
                msg["Content-Type"] = 'text/html; charset="UTF-8"'
                msg["Subject"] = "[%s] Commits of code to GitHub" % url
                # send pushed commits log to public maillist spamstop-commits@mail.yandex-team.ru
                s = sendEmail(msg.as_string(), msg['From'], msg['To'])
                writelog("Antifraud rules hook: Rules have no faults, sendEmail answered: %s" % s)

        if not faultRulesTotal: # Pushing commits to stable branch
            tmpFolder = '{}/{}'.format(CFG['rules_check_tmp_dir'], createTmpDir(rulesDir, inner_folder=PARENT_REPO))
            tmpRulesDir = "{}/{}".format(tmpFolder, PARENT_REPO)
            writelog("Antifraud rules hook: Pushing commits to stable branch for submodule '%s' (temporary folder '%s')" % (submodule, tmpFolder))
            if onlySubmodules:
                makeAndUploadRulesBundle(payload, repoPath, tmpFolder)
            else:
                writelog("Antifraud rules hook: Copying changes to the stable branch%s" % (" for submodule %s" % submodule if submodule else ""))
                cs = '{}^..{}'.format(payload['commits'][0]['id'], payload['commits'][-1]['id'])
                copyMaster2TempFolder(repoPath, '{}/{}'.format(tmpRulesDir, submodule) if submodule else tmpRulesDir)
                c = checkoutBranch(repoPath, 'stable')
                c += pullRepo(repoPath)
                if re.search(r'reject|error|fatal', c, re.I):
                    writelog('Antifraud rules hook: Pulling commits into stable branch from remote error: %s.' % c)
                sf = {}
                for f in map(lambda (f, t): f, filter(lambda (f, t): t != 'D' and (not submodule or submodule and f not in SUBMODULES), files.items())):
                    n = f.rfind('/')
                    s = f[: n + 1] if n > -1 else ''
                    if s in sf:
                        sf[s].append(f)
                    else:
                        sf[s] = [f]
                try:
                    call("cd {0}/{1} && {2}".format(tmpRulesDir, submodule, ' && '.join(map(lambda (s, fs): "mkdir -p {0}{1} && cp -a {2} {0}{1}/".format(repoPath, s, ' '.join(fs)), sf.items()))), shell=True)
                except Exception, e:
                    writelog("Antifraud rules hook: Copying changes to stable branch of rules repo failed: %s" % str(e), True)
                try:
                    deletes = filter(lambda (f, t): t == 'D', files.items())
                    if len(deletes) > 0:
                        deleting_files = ' '.join(map(lambda (f, t): f, deletes))
                        c = check_output("cd {0} && git rm -f {1}".format(repoPath, deleting_files), stderr=STDOUT, shell=True, universal_newlines=True)
                        if c:
                            writelog("Antifraud rules hook: Deleting files %s: %s." % (deleting_files, c), False)
                except Exception, e:
                    writelog("Antifraud rules hook: Removing files {%s} from repo failed: %s" % (str(deletes), str(e)), True)
                commitsMsg = ""
                try:
                    writelog("Antifraud rules hook: Making commit to the stable branch%s" % (" for submodule %s" % submodule if submodule else ""))
                    c = check_output('cd {0} && git log --format="%B (%an)" --reverse {1}'.format(repoPath, cs), stderr=STDOUT, shell=True, universal_newlines=True)
                    for i, line in enumerate(filter(str, map(lambda s: s.strip().rstrip('.'), c.split('\n'))), start=1):
                        commitsMsg += ("; " if i % 2 and i > 1 else " ") + line
                    (output, rows) = Popen('cd {0} && git add . 2>&1 && git commit -m"{1}" --author="{2}"'.format(repoPath, commitsMsg.strip(), CFG['robot']['name']), stdout=PIPE, stderr=PIPE, shell=True, universal_newlines=True).communicate()
                except Exception, e:
                    writelog('Antifraud rules hook: Exception while git commit to stable branch: %s' % str(e), True)
                writelog("Antifraud rules hook: Result of making commit to the stable branch%s: %s. Errors: '%s'." % (" for submodule %s" % submodule if submodule else "", output, rows))
                if re.search(r'reject|error|fatal', output, re.I):
                    writelog('Antifraud rules hook: Committing into stable branch failed: %s' % output)
                else:
                    writelog("Antifraud rules hook: Push commits to the stable branch%s" % (" for submodule %s" % submodule if submodule else ""))
                    c = pushRepo(repoPath, 'stable')
                    if re.search(r'reject|error|fatal', c, re.I):
                        writelog('Antifraud rules hook: Pushing commits in stable branch to upstream error: %s' % c)
                checkoutBranch(repoPath, 'master')
                # Commiting to main (parent) repo
                if submodule:
                    if not commitsMsg:
                        commitsMsg = '; '.join(map(lambda c: "'{}' ({})".format(c["message"], c["author"].get("username", c["author"]["name"])), payload['commits']))
                    pushMainRepoChanges(commitsMsg, "master")
                else:
                    makeAndUploadRulesBundle(payload, repoPath, tmpFolder)
            # Cleaning up
            try:
                rmtree(tmpFolder)
            except Exception, e:
                writelog('Antifraud rules hook: Exception while deleting of temporary folder "%s": %s' % (tmpFolder, str(e)), True)

elif 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'push' and payload['ref'] == 'refs/heads/stable' and not res:
    res = u"Changes made by {0} <{1}>\nhave pushed to stable branch.".format(payload['head_commit']['author']['name'], payload['head_commit']['author']['email'])

elif 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'pull_request':
    writelog('Antifraud rules hook: You have pull request: %s' % json.dumps(payload))

elif 'HTTP_X_GITHUB_EVENT' in os.environ and os.environ['HTTP_X_GITHUB_EVENT'] == 'ping':
    writelog('Antifraud rules hook: You have ping request: %s' % json.dumps(payload))

elif 'HTTP_X_GITHUB_EVENT' in os.environ:
    writelog('Antifraud rules hook: You have %s request: %s' % (os.environ['HTTP_X_GITHUB_EVENT'], json.dumps(payload)))

else:
    writelog('Antifraud rules hook: You have unknown request: %s' % json.dumps(payload))

#print("HTTP/1.1 %s\r\n" % ('500 Internal Server Error' if faultRulesTotal else '200 OK'), end='')
try:
    print(u'Content-Type: text/html; charset="UTF-8"\r\n\r\n%s\r\n' % res, end='')
except:
    print(u'Content-Type: text/html; charset="UTF-8"\r\n\r\n', end='')

if faultRulesTotal:
    sys.exit(1)

