#!/bin/bash
RULES_FOLDER=${1:-WORKING_DIR/antifraud}
RULES_CONFIG_PATH=WORKING_DIR/antifraud/channels.conf
RULES_CHECKER_PATH=WORKING_DIR/web/hooks/antifraud_rules_check.sh
BINBASE_PATH=WORKING_DIR/binbase.txt
REQUEST_JSON_PATH=file://WORKING_DIR/web/hooks/request.json.txt
RESPONSE_JSON_PATH=file://WORKING_DIR/web/hooks/response.json.txt
BROWSER_DATA_PATH=WORKING_DIR/web/hooks/browser.xml
CURRENCIES_RATE_MAP_PATH=WORKING_DIR/currencies_rate_map
GLOBAL_FUNCS_TOTAL=0
RULES_TOTAL=0
FAULT_RULES_TOTAL=0

cd $RULES_FOLDER

for file in $(find -depth -type f -path "./*.lua"); do
    GLOBAL_FUNCS_CNT=$(grep -P '^function global\.' $file | wc -l)
    RULES_CNT=$(grep -P '^function ruleset\.' $file | wc -l)
    FILE_PATH=$(echo $file | sed -e 's#^./##')
    GLOBAL_FUNCS_TOTAL=$(( GLOBAL_FUNCS_TOTAL + GLOBAL_FUNCS_CNT ))
    RULES_TOTAL=$(( RULES_TOTAL + RULES_CNT ))
    echo "INFO *** Data file $FILE_PATH"
    echo "INFO Rules count: $RULES_CNT"
    echo "INFO Global functions count: $GLOBAL_FUNCS_CNT"
done

echo
$RULES_CHECKER_PATH validate $REQUEST_JSON_PATH $RULES_CONFIG_PATH $RESPONSE_JSON_PATH $BROWSER_DATA_PATH $CURRENCIES_RATE_MAP_PATH 2>&1
RETVAL=$?
echo

[ "$RETVAL" -ne "0" ] && FAULT_RULES_TOTAL=1

echo "INFO *** All success rules: $RULES_TOTAL"
echo "INFO *** All global functions: $GLOBAL_FUNCS_TOTAL"
echo "INFO *** All fault rules: $FAULT_RULES_TOTAL"

cd ..
